/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow.util;

import coins.aflow.util.BitVector;
import coins.aflow.util.BitVectorIterator;

public class BitVectorIteratorImpl
implements BitVectorIterator {
    private int fLongWordLength;
    private int fBitCount;
    private int fShiftMax = 63;
    private long[] fVectorWord;
    private final BitVector fBitVector;
    private int fBitPosition;

    public BitVectorIteratorImpl(BitVector pBitVector) {
        this.fLongWordLength = pBitVector.getWordLength();
        this.fBitCount = pBitVector.getBitLength() + 1;
        this.fVectorWord = pBitVector.getVectorWord();
        this.fBitPosition = 0;
        this.fBitVector = pBitVector;
    }

    public boolean hasNext() {
        return this.fBitPosition < this.fBitCount - 1;
    }

    public int next() {
        return ++this.fBitPosition;
    }

    public int nextIndex() {
        int lValue = 0;
        while (this.fBitPosition < this.fBitCount - 1) {
            ++this.fBitPosition;
            int lWordPosition = this.fBitPosition / 64;
            int lInx = this.fBitPosition - lWordPosition * 64;
            lValue = (int)(this.fVectorWord[lWordPosition] >>> this.fShiftMax - lInx & 1L);
            if (lValue <= 0) continue;
        }
        if (lValue == 1) {
            return this.fBitPosition;
        }
        return 0;
    }

    public int currentIndex() {
        return this.fBitPosition;
    }

    public void resetBit() {
        this.fBitVector.resetBit(this.fBitPosition);
    }

    public void setBit() {
        this.fBitVector.setBit(this.fBitPosition);
    }
}

