/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.FlowRoot;
import coins.HirRoot;
import coins.IoRoot;
import coins.aflow.AssignFlowExpId;
import coins.aflow.AssignHashBasedFlowExpIdHir;
import coins.aflow.BBlock;
import coins.aflow.BBlockHir;
import coins.aflow.BBlockHirImpl;
import coins.aflow.BBlockStmtIterator;
import coins.aflow.BBlockSubtreeIterator;
import coins.aflow.BBlockVector;
import coins.aflow.BBlockVectorImpl;
import coins.aflow.DefUseCell;
import coins.aflow.DefUseCellImpl;
import coins.aflow.DefUseList;
import coins.aflow.DefUseListImpl;
import coins.aflow.DefVector;
import coins.aflow.DefVectorImpl;
import coins.aflow.Edge;
import coins.aflow.EdgeImpl;
import coins.aflow.ExpVector;
import coins.aflow.ExpVectorImpl;
import coins.aflow.FlowAnalSymVector;
import coins.aflow.FlowAnalSymVectorImpl;
import coins.aflow.FlowResults;
import coins.aflow.HirSubpFlow;
import coins.aflow.HirSubpFlowImpl;
import coins.aflow.PointVector;
import coins.aflow.PointVectorImpl;
import coins.aflow.RegisterFlowAnalClasses;
import coins.aflow.SetRefRepr;
import coins.aflow.SetRefReprHirEImpl;
import coins.aflow.SetRefReprList;
import coins.aflow.SetRefReprListHir;
import coins.aflow.ShowFlow;
import coins.aflow.SubpFlow;
import coins.aflow.UDChain;
import coins.aflow.UDChainImpl;
import coins.aflow.UDList;
import coins.aflow.UDListImpl;
import coins.aflow.util.FAList;
import coins.aflow.util.FlowError;
import coins.driver.CoinsOptions;
import coins.driver.CompileSpecification;
import coins.driver.Trace;
import coins.ir.IR;
import coins.ir.IrList;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.HirList;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.Program;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.sym.Sym;
import coins.sym.SymIterator;
import coins.sym.SymNestIterator;
import coins.sym.SymTable;
import coins.sym.Var;
import java.util.List;
import java.util.ListIterator;

public class Flow {
    public final FlowRoot flowRoot;
    public final HirRoot hirRoot;
    public final IoRoot ioRoot;
    public final Flow flow;
    private final CompileSpecification fSpec;
    private final Trace fTrace;
    private final CoinsOptions fCoinsOptions;
    protected SubpFlow fSubpFlow;

    public Flow(FlowRoot pFlowRoot) {
        this.flow = pFlowRoot.aflow;
        this.flowRoot = pFlowRoot;
        this.hirRoot = this.flowRoot.hirRoot;
        this.ioRoot = this.flowRoot.ioRoot;
        this.fSpec = this.ioRoot.getCompileSpecification();
        this.fCoinsOptions = this.fSpec.getCoinsOptions();
        this.fTrace = this.fSpec.getTrace();
    }

    public int doHirForC() {
        FlowResults lResults = this.flow.results();
        ShowFlow lShowFlow = new ShowFlow(lResults);
        IrList lSubpDefList = ((Program)this.hirRoot.programRoot).getSubpDefinitionList();
        ListIterator subpDefIterator = lSubpDefList.iterator();
        int lReturnValue = 0;
        while (subpDefIterator.hasNext()) {
            SubpFlow lSubpFlow;
            SubpDefinition subpDef = (SubpDefinition)subpDefIterator.next();
            this.fSubpFlow = lSubpFlow = this.flow.subpFlow(subpDef, lResults);
            lSubpFlow.controlFlowAnal();
            lResults.find("Initiate", lSubpFlow);
            lResults.find("DefUseList", lSubpFlow);
            boolean lUnreachableCodeExists = false;
            FAList lBBlockTable = lSubpFlow.getBBlockTable();
            List lBBlocks = lSubpFlow.getBBlocks();
            lBBlockTable.toList().removeAll(lBBlocks);
            for (BBlock lBBlock : lBBlockTable) {
                Stmt lStmt = null;
                BBlockStmtIterator lBBlockStmtIt = new BBlockStmtIterator((BBlockHir)lBBlock);
                while (lStmt != BBlockStmtIterator.EOB) {
                    lStmt = (Stmt)lBBlockStmtIt.next();
                    int lOpCode = lStmt.getOperator();
                    switch (lOpCode) {
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 36: {
                            this.flow.warning(subpDef.getSubpSym() + ": unreachable code exists.");
                            lUnreachableCodeExists = true;
                            lReturnValue = -1;
                        }
                    }
                }
            }
            if (!lUnreachableCodeExists) {
                SymIt lIt = new SymIt(this.flowRoot.symRoot.symTableCurrentSubp);
                block9: while (lIt.hasNext()) {
                    Sym lSym = lIt.next();
                    if (lSym.getDefinedIn() == null || !(lSym instanceof Var)) continue;
                    if (!((FAList)lResults.get("SymIndexTable", lSubpFlow)).contains(lSym)) {
                        this.flow.warning(subpDef.getSubpSym() + ": unused variable " + lSym.getName());
                        continue;
                    }
                    if (lSym.getSymKind() == 10) continue;
                    switch (lSym.getSymType().getTypeKind()) {
                        case 23: 
                        case 24: 
                        case 25: {
                            continue block9;
                        }
                    }
                    for (DefUseCell lCell : ((DefUseList)lResults.get("DefUseList", lSym, lSubpFlow)).getDefUseCells()) {
                        if (lCell.getDefNode() != DefUseCell.UNINITIALIZED) continue;
                        this.flow.warning(subpDef.getSubpSym() + ": uninitialized variable " + lSym.getName());
                        lReturnValue = -2;
                        continue block9;
                    }
                }
            }
            if (!this.fTrace.shouldTrace("Flow", 1)) continue;
            subpDef.printHir("After HIR flow analysis");
        }
        return lReturnValue;
    }

    public void doHir() {
        FlowResults.putRegClasses(new RegisterFlowAnalClasses());
        IrList lSubpDefList = ((Program)this.hirRoot.programRoot).getSubpDefinitionList();
        ListIterator subpDefIterator = lSubpDefList.iterator();
        boolean lReturnValue = false;
        this.dbg(1, "doHir", "");
        while (subpDefIterator.hasNext()) {
            SubpFlow lSubpFlow;
            SubpDefinition subpDef = (SubpDefinition)subpDefIterator.next();
            this.dbg(2, "doHir", subpDef.getSubpSym().getName());
            FlowResults lResults = this.flow.results();
            ShowFlow lShowFlow = new ShowFlow(lResults);
            this.fSubpFlow = lSubpFlow = this.flow.subpFlow(subpDef, lResults);
            this.fSubpFlow.computeSetOfGlobalVariables();
            if (!Flow.checkTreeStructure(subpDef, this.ioRoot)) {
                throw new FlowError("Not tree.");
            }
            if (this.flowRoot.getFlowAnalOption(1)) {
                lSubpFlow.controlFlowAnal();
            }
            if (this.flowRoot.getFlowAnalOption(2)) {
                lSubpFlow.makeDominatorTree();
            }
            if (this.flowRoot.getFlowAnalOption(3)) {
                lSubpFlow.makePostdominatorTree();
            }
            if (this.flowRoot.getFlowAnalOption(5)) {
                lSubpFlow.initiateDataFlow();
            }
            if (this.flowRoot.getFlowAnalOption(6)) {
                lSubpFlow.findPDef();
                lSubpFlow.findDKill();
            }
            if (this.flowRoot.getFlowAnalOption(7)) {
                lSubpFlow.findPReach();
            }
            if (this.flowRoot.getFlowAnalOption(8)) {
                lSubpFlow.findDDefined();
                lSubpFlow.findPDefined();
                lSubpFlow.findPExposedUsed();
            }
            if (this.flowRoot.getFlowAnalOption(9)) {
                lSubpFlow.findDEGen();
                lSubpFlow.findPEKill();
            }
            if (this.flowRoot.getFlowAnalOption(10)) {
                lSubpFlow.findDAvailInAvailOut();
            }
            if (this.flowRoot.getFlowAnalOption(11)) {
                lSubpFlow.findPLiveInLiveOut();
            }
            if (this.flowRoot.getFlowAnalOption(12)) {
                lSubpFlow.findDDefInDefOut();
            }
            if (this.flowRoot.getFlowAnalOption(5)) {
                lSubpFlow.findDefUse();
            }
            if (this.fTrace.shouldTrace("Flow", 1)) {
                lShowFlow.showControlFlow(lSubpFlow);
            }
            if (this.fTrace.shouldTrace("Flow", 2)) {
                lShowFlow.showDominatorTree(lSubpFlow);
                lShowFlow.showPostdominatorTree(lSubpFlow);
            }
            if (this.fTrace.shouldTrace("Flow", 3)) {
                lShowFlow.showImmediateDominators(lSubpFlow);
                lShowFlow.showImmediatePostdominators(lSubpFlow);
            }
            if (this.fTrace.shouldTrace("Flow", 1)) {
                lShowFlow.showVectorsByName("PDef", lSubpFlow);
                lShowFlow.showVectorsByName("DKill", lSubpFlow);
                lShowFlow.showVectorsByName("PReach", lSubpFlow);
                lShowFlow.showVectorsByName("DDefined", lSubpFlow);
                lShowFlow.showVectorsByName("PDefined", lSubpFlow);
                lShowFlow.showVectorsByName("PExposed", lSubpFlow);
                lShowFlow.showVectorsByName("PUsed", lSubpFlow);
                lShowFlow.showVectorsByName("DEGen", lSubpFlow);
                lShowFlow.showVectorsByName("PEKill", lSubpFlow);
                lShowFlow.showVectorsByName("DAvailIn", lSubpFlow);
                lShowFlow.showVectorsByName("DAvailOut", lSubpFlow);
                lShowFlow.showVectorsByName("PLiveIn", lSubpFlow);
                lShowFlow.showVectorsByName("PLiveOut", lSubpFlow);
                lShowFlow.showVectorsByName("DDefIn", lSubpFlow);
                lShowFlow.showVectorsByName("DDefOut", lSubpFlow);
                lShowFlow.showPDefUse(lSubpFlow);
                lShowFlow.showPUseDef(lSubpFlow);
            }
            if (!this.fTrace.shouldTrace("Flow", 4)) continue;
            for (BBlock lBBlock : lSubpFlow.getBBlocks()) {
                lShowFlow.showVectorsByName("PDef", lBBlock);
                lShowFlow.showVectorsByName("DKill", lBBlock);
                lShowFlow.showVectorsByName("PReach", lBBlock);
                lShowFlow.showVectorsByName("DDefined", lBBlock);
                lShowFlow.showVectorsByName("PDefined", lBBlock);
                lShowFlow.showVectorsByName("PExposed", lBBlock);
                lShowFlow.showVectorsByName("PUsed", lBBlock);
                lShowFlow.showVectorsByName("DEGen", lBBlock);
                lShowFlow.showVectorsByName("PEKill", lBBlock);
                lShowFlow.showVectorsByName("DAvailIn", lBBlock);
                lShowFlow.showVectorsByName("PLiveOut", lBBlock);
                lShowFlow.showVectorsByName("DDefIn", lBBlock);
            }
        }
    }

    public void doHir0(SubpDefinition subpDef, FlowResults lResults, SubpFlow lSubpFlow) {
        this.dbg(1, "\ndoHir0", " BEGIN" + subpDef.getSubpSym().getName());
        boolean lReturnValue = false;
        ShowFlow lShowFlow = new ShowFlow(lResults);
        if (!Flow.checkTreeStructure(subpDef, this.ioRoot)) {
            throw new FlowError("Not tree.");
        }
        lSubpFlow.controlFlowAnal();
        if (this.flowRoot.getFlowAnalOption(2)) {
            lSubpFlow.makeDominatorTree();
        }
        if (this.flowRoot.getFlowAnalOption(3)) {
            lSubpFlow.makePostdominatorTree();
        }
        if (this.flowRoot.getFlowAnalOption(5)) {
            lSubpFlow.initiateDataFlow();
        }
        if (this.flowRoot.getFlowAnalOption(6)) {
            lSubpFlow.findPDef();
            lSubpFlow.findDKill();
        }
        if (this.flowRoot.getFlowAnalOption(7)) {
            lSubpFlow.findPReach();
        }
        if (this.flowRoot.getFlowAnalOption(8)) {
            lSubpFlow.findDDefined();
            lSubpFlow.findPDefined();
            lSubpFlow.findPExposedUsed();
        }
        if (this.flowRoot.getFlowAnalOption(9)) {
            lSubpFlow.findDEGen();
            lSubpFlow.findPEKill();
        }
        if (this.flowRoot.getFlowAnalOption(10)) {
            lSubpFlow.findDAvailInAvailOut();
        }
        if (this.flowRoot.getFlowAnalOption(11)) {
            lSubpFlow.findPLiveInLiveOut();
        }
        if (this.flowRoot.getFlowAnalOption(12)) {
            lSubpFlow.findDDefInDefOut();
        }
        if (this.flowRoot.getFlowAnalOption(5)) {
            lSubpFlow.findDefUse();
        }
        if (this.fTrace.shouldTrace("Flow", 1)) {
            lShowFlow.showControlFlow(lSubpFlow);
        }
        if (this.fTrace.shouldTrace("Flow", 2)) {
            lShowFlow.showDominatorTree(lSubpFlow);
            lShowFlow.showPostdominatorTree(lSubpFlow);
        }
        if (this.fTrace.shouldTrace("Flow", 3)) {
            lShowFlow.showImmediateDominators(lSubpFlow);
            lShowFlow.showImmediatePostdominators(lSubpFlow);
        }
        if (this.fTrace.shouldTrace("Flow", 1)) {
            lShowFlow.showVectorsByName("PDef", lSubpFlow);
            lShowFlow.showVectorsByName("DKill", lSubpFlow);
            lShowFlow.showVectorsByName("PReach", lSubpFlow);
            lShowFlow.showVectorsByName("DDefined", lSubpFlow);
            lShowFlow.showVectorsByName("PDefined", lSubpFlow);
            lShowFlow.showVectorsByName("PExposed", lSubpFlow);
            lShowFlow.showVectorsByName("PUsed", lSubpFlow);
            lShowFlow.showVectorsByName("DEGen", lSubpFlow);
            lShowFlow.showVectorsByName("PEKill", lSubpFlow);
            lShowFlow.showVectorsByName("DAvailIn", lSubpFlow);
            lShowFlow.showVectorsByName("DAvailOut", lSubpFlow);
            lShowFlow.showVectorsByName("PLiveIn", lSubpFlow);
            lShowFlow.showVectorsByName("PLiveOut", lSubpFlow);
            lShowFlow.showVectorsByName("DDefIn", lSubpFlow);
            lShowFlow.showVectorsByName("DDefOut", lSubpFlow);
            lShowFlow.showPDefUse(lSubpFlow);
            lShowFlow.showPUseDef(lSubpFlow);
        }
        if (this.fTrace.shouldTrace("Flow", 4)) {
            for (BBlock lBBlock : lSubpFlow.getBBlocks()) {
                lShowFlow.showVectorsByName("PDef", lBBlock);
                lShowFlow.showVectorsByName("DKill", lBBlock);
                lShowFlow.showVectorsByName("PReach", lBBlock);
                lShowFlow.showVectorsByName("DDefined", lBBlock);
                lShowFlow.showVectorsByName("PDefined", lBBlock);
                lShowFlow.showVectorsByName("PExposed", lBBlock);
                lShowFlow.showVectorsByName("PUsed", lBBlock);
                lShowFlow.showVectorsByName("DEGen", lBBlock);
                lShowFlow.showVectorsByName("PEKill", lBBlock);
                lShowFlow.showVectorsByName("DAvailIn", lBBlock);
                lShowFlow.showVectorsByName("PLiveOut", lBBlock);
                lShowFlow.showVectorsByName("DDefIn", lBBlock);
            }
        }
        this.dbg(1, "\ndoHir0", " END");
    }

    public void doLir() {
        FlowResults.putRegClasses(new RegisterFlowAnalClasses());
        IrList lSubpDefList = ((Program)this.hirRoot.programRoot).getSubpDefinitionList();
        ListIterator subpDefIterator = lSubpDefList.iterator();
        boolean lReturnValue = false;
        while (subpDefIterator.hasNext()) {
            SubpDefinition subpDef = (SubpDefinition)subpDefIterator.next();
            FlowResults lResults = this.flow.results();
            ShowFlow lShowFlow = new ShowFlow(lResults);
            SubpFlow lSubpFlow = this.flow.subpFlow(subpDef, lResults);
            if (this.flowRoot.getFlowAnalOption(1)) {
                lSubpFlow.controlFlowAnal();
            }
            if (this.flowRoot.getFlowAnalOption(2)) {
                lSubpFlow.makeDominatorTree();
            }
            if (this.flowRoot.getFlowAnalOption(3)) {
                lSubpFlow.makePostdominatorTree();
            }
            if (this.flowRoot.getFlowAnalOption(5)) {
                lSubpFlow.initiateDataFlow();
            }
            if (this.flowRoot.getFlowAnalOption(6)) {
                lSubpFlow.findPDef();
                lSubpFlow.findDKill();
            }
            if (this.flowRoot.getFlowAnalOption(7)) {
                lSubpFlow.findPReach();
            }
            if (this.flowRoot.getFlowAnalOption(8)) {
                lSubpFlow.findDDefined();
                lSubpFlow.findPDefined();
                lSubpFlow.findDExposedUsed();
                lSubpFlow.findPExposedUsed();
            }
            if (this.flowRoot.getFlowAnalOption(9)) {
                lSubpFlow.findDEGen();
                lSubpFlow.findPEKill();
            }
            if (this.flowRoot.getFlowAnalOption(10)) {
                lSubpFlow.findDAvailInAvailOut();
            }
            if (this.flowRoot.getFlowAnalOption(11)) {
                lSubpFlow.findPLiveInLiveOut();
            }
            if (this.flowRoot.getFlowAnalOption(12)) {
                lSubpFlow.findDDefInDefOut();
            }
            if (this.flowRoot.getFlowAnalOption(5)) {
                lSubpFlow.findDefUse();
            }
            if (this.fTrace.shouldTrace("Flow", 1)) {
                lShowFlow.showControlFlow(lSubpFlow);
            }
            if (this.fTrace.shouldTrace("Flow", 2)) {
                lShowFlow.showDominatorTree(lSubpFlow);
                lShowFlow.showPostdominatorTree(lSubpFlow);
            }
            if (this.fTrace.shouldTrace("Flow", 3)) {
                lShowFlow.showImmediateDominators(lSubpFlow);
                lShowFlow.showImmediatePostdominators(lSubpFlow);
            }
            if (!this.fTrace.shouldTrace("Flow", 1)) continue;
            lShowFlow.showVectorsByName("DDef", lSubpFlow);
            lShowFlow.showVectorsByName("PDef", lSubpFlow);
            lShowFlow.showVectorsByName("DKill", lSubpFlow);
            lShowFlow.showVectorsByName("PKill", lSubpFlow);
            lShowFlow.showVectorsByName("DReach", lSubpFlow);
            lShowFlow.showVectorsByName("PReach", lSubpFlow);
            lShowFlow.showVectorsByName("DDefined", lSubpFlow);
            lShowFlow.showVectorsByName("PDefined", lSubpFlow);
            lShowFlow.showVectorsByName("DExposed", lSubpFlow);
            lShowFlow.showVectorsByName("PExposed", lSubpFlow);
            lShowFlow.showVectorsByName("DUsed", lSubpFlow);
            lShowFlow.showVectorsByName("PUsed", lSubpFlow);
            lShowFlow.showVectorsByName("DEGen", lSubpFlow);
            lShowFlow.showVectorsByName("PEKill", lSubpFlow);
            lShowFlow.showVectorsByName("DAvailIn", lSubpFlow);
            lShowFlow.showVectorsByName("DAvailOut", lSubpFlow);
            lShowFlow.showVectorsByName("PLiveIn", lSubpFlow);
            lShowFlow.showVectorsByName("PLiveOut", lSubpFlow);
            lShowFlow.showVectorsByName("DDefIn", lSubpFlow);
            lShowFlow.showVectorsByName("DDefOut", lSubpFlow);
            lShowFlow.showPDefUse(lSubpFlow);
            lShowFlow.showPUseDef(lSubpFlow);
        }
    }

    public static boolean isExecutable(IR pIR) {
        if (pIR instanceof HIR) {
            switch (pIR.getOperator()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 21: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 32: 
                case 35: 
                case 36: 
                case 73: {
                    return false;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 33: 
                case 34: 
                case 38: 
                case 39: 
                case 41: 
                case 42: 
                case 43: 
                case 46: 
                case 47: 
                case 48: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 58: 
                case 59: 
                case 60: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 70: 
                case 71: 
                case 72: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: {
                    return true;
                }
            }
            throw new FlowError();
        }
        throw new FlowError();
    }

    public static boolean checkTreeStructure(HIR pHIR, IoRoot pIoRoot) {
        int lOpCode = pHIR.getOperator();
        if (lOpCode == 35) {
            for (Stmt lStmt = ((BlockStmt)pHIR).getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                if (Flow.checkTreeStructure(lStmt, pIoRoot)) continue;
                return false;
            }
        } else if (lOpCode == 14) {
            ListIterator lIt = ((HirList)pHIR).iterator();
            while (lIt.hasNext()) {
                HIR lHir = (HIR)lIt.next();
                HIR lParent = (HIR)lHir.getParent();
                if (lParent != null && lParent != pHIR) {
                    boolean lVerified = false;
                    for (int i = 1; i <= lParent.getChildCount(); ++i) {
                        if (lParent.getChild(i) != lHir) continue;
                        lVerified = true;
                    }
                    if (!lVerified) {
                        pIoRoot.msgRecovered.put(5555, "Flow: HIR tree check for (" + lHir + ") failed. (" + lHir + ")'s parent (" + lParent + ") does not have (" + lHir + ") as its child.");
                        return false;
                    }
                }
                Flow.checkTreeStructure(lHir, pIoRoot);
            }
        } else {
            for (int i = 1; i <= pHIR.getChildCount(); ++i) {
                HIR lChild = (HIR)pHIR.getChild(i);
                if (lChild == null) continue;
                if (lChild.getParent() != pHIR) {
                    pIoRoot.msgRecovered.put(5555, "Flow: HIR tree check for (" + pHIR + ") failed. (" + pHIR + ")'s " + i + "th child (" + lChild + ")'s parent is (" + lChild.getParent() + ")");
                    return false;
                }
                if (Flow.checkTreeStructure(lChild, pIoRoot)) continue;
                return false;
            }
        }
        return true;
    }

    public void dbg(int level, String pHeader, Object pObject) {
        this.ioRoot.dbgFlow.printObject(level, pHeader, pObject);
        this.ioRoot.dbgFlow.println(level);
    }

    public void dbg(int level, Object pObject) {
        if (pObject == null) {
            this.ioRoot.dbgFlow.print(level, " null ");
        } else {
            this.ioRoot.dbgFlow.print(level, " " + pObject.toString());
        }
    }

    public void message(int level, String mes) {
        this.ioRoot.dbgFlow.print(level, "", mes);
    }

    void warning(String mes) {
        this.ioRoot.msgWarning.put(5555, this.ioRoot.getSourceFile() + ": " + mes);
        this.message(6, "WARNING: " + this.ioRoot.getSourceFile() + ": " + mes);
        this.ioRoot.getCompileSpecification().getWarning().warning(5555, "Flow", this.ioRoot.getSourceFile() + ": " + mes);
    }

    public void test() {
        FlowResults.putRegClasses(new RegisterFlowAnalClasses());
        IrList lSubpDefList = ((Program)this.hirRoot.programRoot).getSubpDefinitionList();
        ListIterator subpDefIterator = lSubpDefList.iterator();
        boolean lReturnValue = false;
        while (subpDefIterator.hasNext()) {
            SubpDefinition subpDef = (SubpDefinition)subpDefIterator.next();
            FlowResults lResults = this.flow.results();
            ShowFlow lShowFlow = new ShowFlow(lResults);
            SubpFlow lSubpFlow = this.flow.subpFlow(subpDef, lResults);
            lSubpFlow.controlFlowAnal();
            if (this.flowRoot.getFlowAnalOption(6)) {
                lSubpFlow.findDExposedUsed();
            }
            System.out.println();
            System.out.println();
            System.out.println(lResults);
        }
    }

    public AssignFlowExpId assigner(SubpFlow pSubpFlow) {
        if (pSubpFlow instanceof HirSubpFlow) {
            return new AssignHashBasedFlowExpIdHir((HirSubpFlow)pSubpFlow);
        }
        throw new FlowError();
    }

    public BBlockHir bblock(LabeledStmt pLabeledStmt, HirSubpFlow pHirSubpFlow) {
        return new BBlockHirImpl(pLabeledStmt, pHirSubpFlow);
    }

    public BBlockSubtreeIterator bblockSubtreeIterator(BBlock pBBlock) {
        if (pBBlock instanceof BBlockHir) {
            return new BBlockStmtIterator((BBlockHir)pBBlock);
        }
        throw new FlowError();
    }

    public BBlockVector bblockVector(SubpFlow pSubpFlow) {
        return new BBlockVectorImpl(pSubpFlow);
    }

    public DefUseCell defUseCell(IR pDefNode) {
        return new DefUseCellImpl(this.flowRoot, pDefNode);
    }

    public DefUseList defUseList() {
        return new DefUseListImpl(this.flowRoot);
    }

    public DefVector defVector(SubpFlow pSubpFlow) {
        return new DefVectorImpl(pSubpFlow);
    }

    public Edge edge(BBlock pFrom, BBlock pTo) {
        return new EdgeImpl(this.flowRoot, pFrom, pTo);
    }

    public ExpVector expVector(SubpFlow pSubpFlow) {
        return new ExpVectorImpl(pSubpFlow);
    }

    public FlowAnalSymVector flowAnalSymVector(SubpFlow pSubpFlow) {
        return new FlowAnalSymVectorImpl(pSubpFlow);
    }

    public PointVector pointVector(SubpFlow pSubpFlow) {
        return new PointVectorImpl(pSubpFlow);
    }

    public FlowResults results() {
        return new FlowResults(this.flowRoot);
    }

    public SetRefRepr setRefRepr(Stmt pStmt, BBlockHir pBBlockHir) {
        return new SetRefReprHirEImpl(pStmt, pBBlockHir, false, null);
    }

    public SetRefReprList setRefReprList(BBlock pBBlock) {
        if (pBBlock instanceof BBlockHir) {
            return new SetRefReprListHir((BBlockHir)pBBlock);
        }
        throw new FlowError();
    }

    public SubpFlow subpFlow(SubpDefinition pSubpDef, FlowResults pResults) {
        if (pResults.flowRoot.isHirAnalysis()) {
            return new HirSubpFlowImpl(pSubpDef, pResults);
        }
        throw new FlowError();
    }

    public UDChain udChain(IR pUseNode) {
        return new UDChainImpl(this.flowRoot, pUseNode);
    }

    public UDList udList() {
        return new UDListImpl(this.flowRoot);
    }

    public SubpFlow getSubpFlow() {
        return this.fSubpFlow;
    }

    public void setSubpFlow(SubpFlow pSubpFlow) {
        this.fSubpFlow = pSubpFlow;
    }

    private static class SymIt
    implements SymIterator {
        private SymTable fSymTableCurrent;
        private final SymNestIterator fSymNestIt;
        private SymIterator fSymIt;
        private boolean fLookingDown = true;
        private boolean fNextChecked = false;

        private SymIt(SymTable pSymTable) {
            this.fSymTableCurrent = pSymTable;
            this.fSymNestIt = pSymTable.getSymNestIterator();
        }

        public boolean hasNext() {
            this.fNextChecked = true;
            if (this.fLookingDown) {
                if (this.fSymNestIt.hasNext()) {
                    return true;
                }
                this.fLookingDown = false;
            } else if (this.fSymIt.hasNext()) {
                return true;
            }
            do {
                this.fSymTableCurrent = this.fSymTableCurrent.getParent();
                if (this.fSymTableCurrent == null) {
                    return false;
                }
                this.fSymIt = this.fSymTableCurrent.getSymIterator();
            } while (!this.fSymIt.hasNext());
            return true;
        }

        public Sym next() {
            if (!this.fNextChecked) {
                throw new FlowError("hasNext() must be called before calling next().");
            }
            this.fNextChecked = false;
            if (this.fLookingDown) {
                return this.fSymNestIt.next();
            }
            return this.fSymIt.next();
        }

        public Var nextVar() {
            throw new UnsupportedOperationException();
        }
    }
}

