/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.aflow.BBlock;
import coins.aflow.ExpVector;
import coins.aflow.FindEKill;
import coins.aflow.FlowAnalSymVector;
import coins.aflow.FlowAnalSymVectorImpl;
import coins.aflow.FlowExpId;
import coins.aflow.FlowResults;
import coins.aflow.SetRefRepr;
import coins.alias.RecordAlias;
import java.util.Set;

public class FindPEKill
extends FindEKill {
    public FindPEKill(FlowResults pResults) {
        super(pResults);
    }

    protected void addEKill(Set pEKillSet, FlowExpId pFlowExpId, BBlock pBBlock) {
        RecordAlias lRecordAlias;
        if (this.flow.fSubpFlow != null && (lRecordAlias = this.flow.fSubpFlow.getRecordAlias()) != null) {
            this.addEKill(pEKillSet, pFlowExpId, pBBlock, lRecordAlias);
            return;
        }
        this.flow.dbg(5, "\n addEKill " + pFlowExpId.toString() + " " + pBBlock);
        FlowAnalSymVector lPDefined = pBBlock.getPDefined();
        this.flow.dbg(6, "definedSyms " + lPDefined.toString());
        Set lOperands = pFlowExpId.getOperandSet0();
        this.flow.dbg(6, " operands " + lOperands.toString());
        FlowAnalSymVector lUseVarVect = FlowAnalSymVectorImpl.forSet(lOperands, pBBlock.getSubpFlow());
        lUseVarVect.vectorAnd(lPDefined, lUseVarVect);
        if (!lUseVarVect.isZero()) {
            pEKillSet.add(pFlowExpId);
            this.flow.dbg(5, " add to EKill " + pFlowExpId.toStringShort());
        }
    }

    protected void register(BBlock pBBlock, ExpVector pEKill) {
        this.flow.dbg(5, " setPEkill " + pEKill.toStringShort() + "\n");
        pBBlock.setPEKill(pEKill);
    }

    protected boolean kills(SetRefRepr pSetRefRepr, FlowExpId pFlowExpId) {
        RecordAlias lRecordAlias = this.flow.fSubpFlow.getRecordAlias();
        if (lRecordAlias != null) {
            return this.killsByAlias(pSetRefRepr, pFlowExpId, lRecordAlias);
        }
        Set lModSyms = pSetRefRepr.modSyms00();
        return lModSyms.removeAll(pFlowExpId.getOperandSet0());
    }

    protected void addEKill(Set pEKillSet, FlowExpId pFlowExpId, BBlock pBBlock, RecordAlias pRecordAlias) {
        this.flow.dbg(5, "\n addEKill " + pFlowExpId.toString() + " " + pBBlock);
        RecordAlias lRecordAlias = this.flow.fSubpFlow.getRecordAlias();
        FlowAnalSymVector lPDefined = pBBlock.getPDefined();
        Set lDefinedSyms = lPDefined.flowAnalSyms();
        this.flow.dbg(6, "definedSyms " + lDefinedSyms.toString());
        Set lAliasSymGroup = lRecordAlias.aliasSymGroup(lDefinedSyms);
        this.flow.dbg(6, " aliasSymGroup " + lAliasSymGroup.toString());
        FlowAnalSymVector lAliasVect = FlowAnalSymVectorImpl.forSet(lAliasSymGroup, pBBlock.getSubpFlow());
        lPDefined.vectorOr(lAliasVect, lPDefined);
        Set lOperands = pFlowExpId.getOperandSet0();
        this.flow.dbg(6, " operands " + lOperands.toString());
        FlowAnalSymVector lUseVarVect = FlowAnalSymVectorImpl.forSet(lOperands, pBBlock.getSubpFlow());
        lUseVarVect.vectorAnd(lPDefined, lUseVarVect);
        this.flow.dbg(5, " addEKill " + pFlowExpId.toString() + " DefinedByAlias [" + lPDefined.toStringShort() + "]");
        if (!lUseVarVect.isZero()) {
            pEKillSet.add(pFlowExpId);
            this.flow.dbg(5, " add to EKill " + pFlowExpId.toStringShort());
        }
    }

    protected boolean killsByAlias(SetRefRepr pSetRefRepr, FlowExpId pFlowExpId, RecordAlias pRecordAlias) {
        Set lModSyms = pSetRefRepr.modSyms00();
        Set lModSymsAlias = pRecordAlias.aliasSymGroup(lModSyms);
        this.flow.dbg(5, " killsByAlias " + pFlowExpId.toString() + " mod " + lModSymsAlias);
        boolean lChanged = lModSymsAlias.removeAll(pFlowExpId.getOperandSet0());
        return lChanged;
    }

    protected void register(SetRefRepr pSetRefRepr, ExpVector pEKill) {
        this.flow.dbg(2, " putPEkill " + pEKill);
        this.fResults.put("PEKill", pSetRefRepr, pEKill);
    }
}

