/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.aflow.BBlock;
import coins.aflow.FlowAdapter;
import coins.aflow.FlowAnalSymVector;
import coins.aflow.FlowResults;
import coins.aflow.SetRefRepr;
import coins.aflow.SetRefReprList;
import coins.aflow.SubpFlow;
import java.util.ListIterator;

public abstract class FindExposedUsed
extends FlowAdapter {
    public FindExposedUsed(FlowResults pResults) {
        super(pResults);
    }

    public void find(SubpFlow pSubpFlow) {
        for (BBlock lBBlock : pSubpFlow.getBBlocks()) {
            this.find(lBBlock);
        }
    }

    public void find(BBlock pBBlock) {
        SetRefReprList lBBlockSetRefReprList = (SetRefReprList)this.fResults.get("BBlockSetRefReprs", pBBlock);
        SubpFlow lSubpFlow = pBBlock.getSubpFlow();
        FlowAnalSymVector lExposed = this.flow.flowAnalSymVector(lSubpFlow);
        FlowAnalSymVector lUsed = this.flow.flowAnalSymVector(lSubpFlow);
        if (lBBlockSetRefReprList != null) {
            ListIterator lBBlockSetRefReprIterator = lBBlockSetRefReprList.listIterator(lBBlockSetRefReprList.size());
            while (lBBlockSetRefReprIterator.hasPrevious()) {
                SetRefRepr lSetRefRepr = (SetRefRepr)lBBlockSetRefReprIterator.previous();
                lExposed.vectorSub(this.getDefined(lSetRefRepr), lExposed);
                lExposed.vectorOr(this.getExposed(lSetRefRepr), lExposed);
                lUsed.vectorOr(this.getUsed(lSetRefRepr), lUsed);
            }
        }
        this.registerExposed(pBBlock, lExposed);
        this.registerUsed(pBBlock, lUsed);
    }

    public abstract void find(SetRefRepr var1);

    protected abstract FlowAnalSymVector getDefined(SetRefRepr var1);

    protected abstract FlowAnalSymVector getExposed(SetRefRepr var1);

    protected abstract FlowAnalSymVector getUsed(SetRefRepr var1);

    protected abstract void registerExposed(BBlock var1, FlowAnalSymVector var2);

    protected abstract void registerUsed(BBlock var1, FlowAnalSymVector var2);
}

