/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.aflow.BBlock;
import coins.aflow.FlowAdapter;
import coins.aflow.FlowAnalSymVector;
import coins.aflow.FlowResults;
import coins.aflow.SetRefRepr;
import coins.aflow.SetRefReprList;
import coins.aflow.SubpFlow;
import java.util.Iterator;
import java.util.List;

public abstract class FindDefInDefOut
extends FlowAdapter {
    public FindDefInDefOut(FlowResults pResults) {
        super(pResults);
    }

    public void find(SubpFlow pSubpFlow) {
        boolean lChanged;
        FlowAnalSymVector lDefIn;
        FlowAnalSymVector lPredDefOut = pSubpFlow.flowAnalSymVector();
        FlowAnalSymVector lZeroVect = pSubpFlow.flowAnalSymVector();
        for (BBlock lBBlock : pSubpFlow.getBBlocks()) {
            lDefIn = pSubpFlow.flowAnalSymVector();
            if (!lBBlock.isEntryBBlock()) {
                lZeroVect.vectorNot(lDefIn);
            }
            this.registerDefIn(lBBlock, lDefIn);
        }
        do {
            lChanged = false;
            Iterator lCFGIterator = pSubpFlow.getBBlocksFromEntry().iterator();
            while (lCFGIterator.hasNext()) {
                BBlock lBBlock;
                FlowAnalSymVector lNewDefIn = pSubpFlow.flowAnalSymVector();
                lBBlock = (BBlock)lCFGIterator.next();
                if (lBBlock.isEntryBBlock()) continue;
                List lPredList = lBBlock.getPredList();
                lZeroVect.vectorNot(lNewDefIn);
                for (BBlock lPredBBlock : lPredList) {
                    FlowAnalSymVector lPredDefined = this.getDefined(lPredBBlock);
                    FlowAnalSymVector lPredDefIn = this.getDefIn(lPredBBlock);
                    lPredDefined.vectorOr(lPredDefIn, lPredDefOut);
                    lNewDefIn.vectorAnd(lPredDefOut, lNewDefIn);
                }
                if (lNewDefIn.vectorEqual(this.getDefIn(lBBlock))) continue;
                lChanged = true;
                this.registerDefIn(lBBlock, lNewDefIn);
            }
        } while (lChanged);
        for (BBlock lBBlock : pSubpFlow.getBBlocks()) {
            FlowAnalSymVector lDefined = this.getDefined(lBBlock);
            lDefIn = this.getDefIn(lBBlock);
            FlowAnalSymVector lDefOut = pSubpFlow.flowAnalSymVector();
            lDefined.vectorOr(lDefIn, lDefOut);
            this.registerDefOut(lBBlock, lDefOut);
        }
    }

    public void find(BBlock pBBlock) {
        this.find(pBBlock.getSubpFlow());
    }

    public void find(SetRefRepr pSetRefRepr) {
        BBlock lBBlock = pSetRefRepr.getBBlock();
        SetRefReprList lSetRefReprs = lBBlock.getSetRefReprs();
        SubpFlow lSubpFlow = lBBlock.getSubpFlow();
        FlowAnalSymVector lDefIn = lSubpFlow.flowAnalSymVector();
        if (lSetRefReprs.isEmpty()) {
            this.getDefIn(lBBlock).vectorCopy(lDefIn);
        } else if (lBBlock.getSetRefReprs().get(0) == pSetRefRepr) {
            this.getDefIn(lBBlock).vectorCopy(lDefIn);
        } else {
            SetRefRepr lPrevSetRefRepr = (SetRefRepr)lSetRefReprs.get(lSetRefReprs.indexOf(pSetRefRepr) - 1);
            lDefIn = this.getDefIn(lPrevSetRefRepr);
            lDefIn.vectorOr(this.getDefined(lPrevSetRefRepr), lDefIn);
        }
        this.registerDefIn(pSetRefRepr, lDefIn);
    }

    protected abstract void registerDefIn(SetRefRepr var1, FlowAnalSymVector var2);

    protected abstract void registerDefIn(BBlock var1, FlowAnalSymVector var2);

    protected abstract void registerDefOut(BBlock var1, FlowAnalSymVector var2);

    protected abstract FlowAnalSymVector getDefined(BBlock var1);

    protected abstract FlowAnalSymVector getDefIn(BBlock var1);

    protected abstract FlowAnalSymVector getDefined(SetRefRepr var1);

    protected abstract FlowAnalSymVector getDefIn(SetRefRepr var1);
}

