/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.aflow.ExpVector;
import coins.aflow.ExpVectorIterator;
import coins.aflow.ExpVectorIteratorImpl;
import coins.aflow.FlowExpId;
import coins.aflow.FlowResults;
import coins.aflow.SubpFlow;
import coins.aflow.util.BitVectorImpl;
import coins.aflow.util.FAList;
import java.util.HashSet;
import java.util.Set;

public class ExpVectorImpl
extends BitVectorImpl
implements ExpVector {
    FlowResults fResults;
    private final SubpFlow fSubpFlow;
    private Set fExps;

    protected ExpVectorImpl(SubpFlow pSubpFlow) {
        this.fSubpFlow = pSubpFlow;
        this.fResults = this.fSubpFlow.results();
        this.fBitLength = ((FAList)this.fResults.get("FlowExpIdTable", this.fSubpFlow)).size();
        this.fLongWordLength = this.fBitLength / 64 + 1;
        this.fVectorWord = new long[this.fLongWordLength];
    }

    public SubpFlow getSubpFlow() {
        return this.fSubpFlow;
    }

    public Set exps() {
        this.fExps = new HashSet();
        ExpVectorIteratorImpl lExpVectIt = new ExpVectorIteratorImpl(this);
        while (lExpVectIt.hasNext()) {
            FlowExpId lFlowExpId = lExpVectIt.nextFlowExpId();
            if (lFlowExpId == null) continue;
            this.fExps.add(lFlowExpId);
        }
        return this.fExps;
    }

    public boolean contains(FlowExpId pFlowExpId) {
        return this.isSet(pFlowExpId.getIndex());
    }

    public static ExpVector forSet(Set pExps, SubpFlow pSubpFlow) {
        ExpVector lExpVect = pSubpFlow.expVector();
        for (FlowExpId lFlowExpId : pExps) {
            lExpVect.setBit(lFlowExpId.getIndex());
        }
        return lExpVect;
    }

    public String toStringConcise() {
        return super.toString();
    }

    public String toStringShort() {
        Object lNextSym = null;
        StringBuffer lBuffer = new StringBuffer();
        lBuffer.append("[");
        ExpVectorIterator lIterator = this.expVectorIterator();
        while (lIterator.hasNext()) {
            FlowExpId lFlowExpId = lIterator.nextFlowExpId();
            if (lFlowExpId == null) continue;
            lBuffer.append(lFlowExpId.toStringShort() + ' ');
        }
        lBuffer.append("]");
        return lBuffer.toString();
    }

    public String toStringByName() {
        return this.exps().toString();
    }

    public String toStringDescriptive() {
        Object lNextSym = null;
        SubpFlow lSubpFlow = this.getSubpFlow();
        StringBuffer lBuffer = new StringBuffer();
        lBuffer.append("[");
        ExpVectorIterator lIterator = this.expVectorIterator();
        while (lIterator.hasNext()) {
            FlowExpId lFlowExpId = lIterator.nextFlowExpId();
            if (lFlowExpId == null) continue;
            lBuffer.append('\n' + lFlowExpId.toString());
        }
        lBuffer.append("]\n");
        return lBuffer.toString();
    }

    public ExpVectorIterator expVectorIterator() {
        return new ExpVectorIteratorImpl(this);
    }
}

