/*
 * Decompiled with CFR 0.152.
 */
package coins;

import coins.FlowRoot;
import coins.HirRoot;
import coins.IoRoot;
import coins.MachineParam;
import coins.SourceLanguage;
import coins.SourceLanguageC;
import coins.SourceLanguageFortran;
import coins.ir.IrList;
import coins.ir.IrListImpl;
import coins.ir.hir.HIR;
import coins.ir.hir.Program;
import coins.ir.hir.SubpDefinition;
import coins.sym.BoolConst;
import coins.sym.FloatConst;
import coins.sym.IntConst;
import coins.sym.Subp;
import coins.sym.Sym;
import coins.sym.SymImpl;
import coins.sym.SymTable;
import coins.sym.SymTableImpl;
import coins.sym.Type;
import coins.sym.TypeImpl;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class SymRoot {
    public final IoRoot ioRoot;
    public final SymRoot symRoot;
    public final Sym sym;
    public final SourceLanguage sourceLanguage;
    public final MachineParam machineParam;
    public SymTable symTable = null;
    public SymTable symTableRoot = null;
    public SymTable symTableConst = null;
    public SymTable symTableUnique = null;
    public SymTable symTableCurrent = null;
    public SymTable symTableCurrentSubp = null;
    public SymTable symTableFlow = null;
    public Type typeBool;
    public Type typeChar;
    public Type typeShort;
    public Type typeInt;
    public Type typeLong;
    public Type typeLongLong;
    public Type typeU_Char;
    public Type typeU_Short;
    public Type typeU_Int;
    public Type typeU_Long;
    public Type typeU_LongLong;
    public Type typeFloat;
    public Type typeDouble;
    public Type typeLongDouble;
    public Type typeVoid;
    public Type typeOffset;
    public Type typeAddress;
    public Type typeStringAny;
    public Type typeRegion;
    public Subp subpCurrent;
    public BoolConst boolConstTrue;
    public BoolConst boolConstFalse;
    public IntConst intConst0;
    public IntConst intConst1;
    public IntConst longConst0;
    public FloatConst floatConst0;
    public FloatConst doubleConst0;
    public Set conflictingSpecialSyms = new HashSet();
    public Set safeArray = new HashSet();
    private HirRoot fHirRoot;
    private FlowRoot fFlowRoot;
    private HIR fHir = null;
    private int fEntranceCount = 0;
    protected int fVarCount = 0;
    protected int fParamCount = 0;
    protected int fElemCount = 0;
    protected int fLabelCount = 0;
    protected int fGenSymCount = 0;
    protected int fARegCount = 0;
    protected int fMRegCount = 0;

    public SymRoot(IoRoot pIoRoot) {
        this.ioRoot = pIoRoot;
        this.symRoot = this;
        this.sym = new SymImpl(this);
        this.machineParam = this.ioRoot.machineParam;
        String lLanguage = this.ioRoot.getLanguageName();
        this.sourceLanguage = lLanguage.equals("C") ? new SourceLanguageC(this) : (lLanguage.equals("FORTRAN") ? new SourceLanguageFortran(this) : new SourceLanguage(this));
        this.ioRoot.symRoot = this;
        ((SymImpl)this.sym).setParameters(this.machineParam, this.sourceLanguage);
        new TypeImpl(this).setStaticTable(this.machineParam);
    }

    public IrList irList(LinkedList pList) {
        return new IrListImpl(this.fHirRoot, pList);
    }

    public void initiate() {
        this.symTableRoot = new SymTableImpl(this);
        this.symTableConst = new SymTableImpl(this);
        this.symTableUnique = new SymTableImpl(this);
        this.symTableCurrent = this.symTableRoot;
        this.symTable = this.symTableRoot;
        ((SymTableImpl)this.symTableRoot).fTableName = "Root";
        ((SymTableImpl)this.symTableConst).fTableName = "Constant";
        ((SymTableImpl)this.symTableUnique).fTableName = "Unique";
        if (this.fEntranceCount == 0) {
            ++this.fEntranceCount;
            this.typeInt = this.sym.baseType(" int".intern(), 4);
            this.typeOffset = this.sym.baseType(" offset".intern(), 14);
            this.typeInt.setSizeValue(this.machineParam.evaluateSize(4));
            this.typeOffset.setSizeValue(this.machineParam.evaluateSize(14));
            this.typeVoid = this.sym.baseType(" void".intern(), 15);
            this.typeBool = this.sym.baseType(" bool".intern(), 1);
            this.typeChar = this.sym.baseType(" char".intern(), 7);
            this.typeShort = this.sym.baseType(" short".intern(), 3);
            this.typeLong = this.sym.baseType(" long".intern(), 5);
            this.typeLongLong = this.sym.baseType(" long_long".intern(), 6);
            this.typeU_Char = this.sym.baseType(" u_char".intern(), 8);
            this.typeU_Short = this.sym.baseType(" u_short".intern(), 9);
            this.typeU_Int = this.sym.baseType(" u_int".intern(), 10);
            this.typeU_Long = this.sym.baseType(" u_long".intern(), 11);
            this.typeU_LongLong = this.sym.baseType(" u_long_long".intern(), 12);
            this.typeAddress = this.sym.baseType(" address".intern(), 13);
            this.typeFloat = this.sym.baseType(" float".intern(), 16);
            this.typeDouble = this.sym.baseType(" double".intern(), 17);
            this.typeLongDouble = this.sym.baseType(" long_double".intern(), 18);
            this.typeStringAny = this.sym.vectorType(this.getCharType(), 0L);
            this.typeRegion = this.sym.regionType(this.machineParam.blankRegionName(), 6);
            this.boolConstTrue = (BoolConst)this.symRoot.symTableConst.searchOrAdd(" true".intern(), 2, null, true, true);
            this.boolConstFalse = (BoolConst)this.symRoot.symTableConst.searchOrAdd(" false".intern(), 2, null, true, true);
            this.typeAddress.setFlag(3, true);
            this.typeBool.setFlag(3, true);
            this.typeChar.setFlag(3, true);
            this.typeDouble.setFlag(3, true);
            this.typeFloat.setFlag(3, true);
            this.typeInt.setFlag(3, true);
            this.typeLong.setFlag(3, true);
            this.typeLongDouble.setFlag(3, true);
            this.typeLongLong.setFlag(3, true);
            this.typeOffset.setFlag(3, true);
            this.typeShort.setFlag(3, true);
            this.typeU_Char.setFlag(3, true);
            this.typeU_Int.setFlag(3, true);
            this.typeU_Long.setFlag(3, true);
            this.typeU_LongLong.setFlag(3, true);
            this.typeU_Short.setFlag(3, true);
            this.typeVoid.setFlag(3, true);
            this.boolConstTrue.setFlag(3, true);
            this.boolConstFalse.setFlag(3, true);
            this.intConst0 = this.sym.intConst("0".intern(), this.typeInt);
            this.intConst1 = this.sym.intConst("1".intern(), this.typeInt);
            this.longConst0 = this.sym.intConst("00".intern(), this.typeLong);
            this.floatConst0 = this.sym.floatConst("0.0F".intern(), this.typeFloat);
            this.doubleConst0 = this.sym.floatConst("0.0".intern(), this.typeDouble);
            if (this.fHirRoot != null) {
                ((Program)this.fHirRoot.programRoot).setSymTable(this.symTableRoot);
            }
        }
    }

    public HirRoot getHirRoot() {
        return this.fHirRoot;
    }

    public FlowRoot getFlowRoot() {
        return this.fFlowRoot;
    }

    public void attachHirRoot(HirRoot pHirRoot) {
        this.fHirRoot = pHirRoot;
    }

    public void attachFlowRoot(FlowRoot pFlowRoot) {
        this.fFlowRoot = pFlowRoot;
    }

    public void useSymTableOfSubpDefinition(SubpDefinition pSubpDef) {
        if (pSubpDef != null) {
            this.subpCurrent = pSubpDef.getSubpSym();
            if (pSubpDef.getSymTable() != null) {
                this.symTableCurrent = pSubpDef.getSymTable();
                this.symTableCurrentSubp = pSubpDef.getSymTable();
            }
        }
    }

    public Type getIntTypeOfAddress() {
        switch (this.machineParam.getIntKindForAddress()) {
            case 0: {
                return this.typeInt;
            }
            case 1: {
                return this.typeU_Int;
            }
            case 2: {
                return this.typeLong;
            }
            case 3: {
                return this.typeU_Long;
            }
            case 4: {
                return this.typeU_LongLong;
            }
        }
        return this.typeU_Long;
    }

    public Type getIntTypeOfChar() {
        switch (this.machineParam.getIntKindForChar()) {
            case 0: {
                return this.typeInt;
            }
            case 1: {
                return this.typeU_Int;
            }
        }
        return this.typeU_Int;
    }

    public Type getCharType() {
        switch (this.machineParam.getIntKindForChar()) {
            case 0: {
                return this.typeChar;
            }
            case 1: {
                return this.typeU_Char;
            }
        }
        return this.typeU_Int;
    }

    public int getVarCount() {
        return this.fVarCount;
    }

    public int incrementVarCount() {
        return ++this.fVarCount;
    }

    public int getParamCount() {
        return this.fParamCount;
    }

    public int incrementParamCount() {
        return ++this.fParamCount;
    }

    public int getElemCount() {
        return this.fElemCount;
    }

    public int incrementElemCount() {
        return ++this.fElemCount;
    }

    public int getLabelCount() {
        return this.fLabelCount;
    }

    public int incrementLabelCount() {
        return ++this.fLabelCount;
    }

    public int getSymCount() {
        return this.fGenSymCount;
    }

    public int incrementSymCount() {
        return ++this.fGenSymCount;
    }

    public int getARegCount() {
        return this.fARegCount;
    }

    public int incrementARegCount() {
        return ++this.fARegCount;
    }

    public int getMRegCount() {
        return this.fMRegCount;
    }

    public int incrementMRegCount() {
        return ++this.fMRegCount;
    }

    public void resetCounters() {
        this.fARegCount = 0;
        this.fMRegCount = 0;
    }
}

