/*
 * Decompiled with CFR 0.152.
 */
package coins;

import coins.Debug;
import coins.MachineParam;
import coins.MachineParamAlpha;
import coins.MachineParamArm;
import coins.MachineParamCellSPE;
import coins.MachineParamMicroBlaze;
import coins.MachineParamMips;
import coins.MachineParamPpc;
import coins.MachineParamSH4;
import coins.MachineParamSimpleprocessor32;
import coins.MachineParamSparc;
import coins.MachineParamX86;
import coins.Message;
import coins.SymRoot;
import coins.driver.CompileSpecification;
import coins.ir.hir.HIR;
import coins.sym.Sym;
import java.io.File;
import java.io.PrintStream;

public class IoRoot {
    private final CompileSpecification fSpec;
    private final File fSourceFile;
    private final String fSourceFilePath;
    public final PrintStream printOut;
    public final PrintStream objectFile;
    public final PrintStream msgOut;
    public Message msgNote;
    public Message msgWarning;
    public Message msgRecovered;
    public Message msgError;
    public Message msgFatal;
    public Debug dbgControl;
    public Debug dbgHir;
    public Debug dbgSym;
    public Debug dbgFlow;
    public Debug dbgAlias;
    public Debug dbgParse;
    public Debug dbgToHir;
    public Debug dbgToLir;
    public Debug dbgOpt1;
    public Debug dbgPara1;
    public final MachineParam machineParam;
    public SymRoot symRoot;
    protected String machineName = "sparc";
    protected String languageName = "C";
    private int fTotalErrorCount = 0;
    private int fMessageCount = 0;

    public IoRoot(File pSourceFile, PrintStream pPrintOut, PrintStream pObjectFile, PrintStream pMsgOut, CompileSpecification pSpec) {
        this(pSourceFile, pPrintOut, pObjectFile, pMsgOut, pSpec, "sparc", "C");
    }

    public IoRoot(File pSourceFile, PrintStream pPrintOut, PrintStream pObjectFile, PrintStream pMsgOut, CompileSpecification pSpec, String pMachineName, String pLanguageName) {
        this.fSourceFile = pSourceFile;
        this.fSourceFilePath = this.fSourceFile.getAbsolutePath();
        this.printOut = pPrintOut;
        this.objectFile = pObjectFile;
        this.msgOut = pMsgOut;
        this.fSpec = pSpec;
        if (pMachineName != null) {
            this.machineName = pMachineName;
        }
        if (pLanguageName != null) {
            this.languageName = pLanguageName;
        }
        String lTarget = null;
        if (pSpec != null && pSpec.getCoinsOptions() != null) {
            lTarget = pSpec.getCoinsOptions().getArg("target");
        }
        if (lTarget == null) {
            lTarget = "sparc";
        }
        this.machineParam = lTarget.equals("sparc") ? new MachineParamSparc(this) : (lTarget.equals("x86") || lTarget.equals("x86-cygwin") ? new MachineParamX86(this) : (lTarget.equals("arm") ? new MachineParamArm(this) : (lTarget.equals("mips") || lTarget.equals("mips-spim") ? new MachineParamMips(this) : (lTarget.equals("sh4") ? new MachineParamSH4(this) : (lTarget.equals("ppc") ? new MachineParamPpc(this) : (lTarget.equals("alpha") ? new MachineParamAlpha(this) : (lTarget.equals("mb") ? new MachineParamMicroBlaze(this) : (lTarget.equals("simpleprocessor32") ? new MachineParamSimpleprocessor32(this) : (lTarget.equals("cellspe") ? new MachineParamCellSPE(this) : new MachineParam(this))))))))));
        this.initiate();
    }

    private void initiate() {
        Debug lDebug = new Debug(this);
        lDebug.initiate();
        Message lMessage = new Message(this);
        lMessage.initiate();
    }

    public CompileSpecification getCompileSpecification() {
        return this.fSpec;
    }

    public File getSourceFile() {
        return this.fSourceFile;
    }

    public String getSourceFilePath() {
        return this.fSourceFilePath;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public synchronized void incrementMessageCount() {
        ++this.fMessageCount;
    }

    public synchronized int getMessageCount() {
        return this.fMessageCount;
    }

    public synchronized void resetMessageCount() {
        this.fMessageCount = 0;
    }

    public synchronized int addToTotalErrorCount(int pCount) {
        this.fTotalErrorCount += pCount;
        return this.fTotalErrorCount;
    }

    public static String toStringObject(Object pItem) {
        if (pItem == null) {
            return "null";
        }
        return pItem.toString();
    }

    public static String toStringObjectShort(Object pItem) {
        if (pItem == null) {
            return "null";
        }
        if (pItem instanceof HIR) {
            return ((HIR)pItem).toStringShort();
        }
        if (pItem instanceof Sym) {
            return ((Sym)pItem).toStringShort();
        }
        return pItem.toString();
    }
}

