/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mjlib.xml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLParser {
    public static final String version = "XMLParser 0.3";
    public static final String author = "Takefumi MIYOSHI (miyo@wasamon.net)";
    public static final String copyright = "(c) 2003-2007 All right reserved";

    public static Node getTopNode(File file) throws XMLParserException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            return document.getFirstChild();
        }
        catch (IOException iOException) {
            throw new XMLParserException("cannot open the file " + file.getName());
        }
        catch (SAXParseException sAXParseException) {
            throw new XMLParserException("syntax error in config file.");
        }
        catch (SAXException sAXException) {
            throw new XMLParserException("sax error.");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XMLParserException("failure initializing of xml parser.");
        }
    }

    public static Node getNamedNode(Node node, String string) throws XMLParserException {
        NodeList nodeList = node.getChildNodes();
        Node node2 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node2 = nodeList.item(i);
            if (node2.getNodeType() == 3 || !string.equals(node2.getNodeName())) continue;
            return node2;
        }
        throw new XMLParserException(string + " is not found under " + node.getNodeValue());
    }

    public static boolean isNamedNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        Node node2 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node2 = nodeList.item(i);
            if (node2.getNodeType() == 3 || !string.equals(node2.getNodeName())) continue;
            return true;
        }
        return false;
    }

    public static Node[] getNamedNodeArray(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        Node node2 = null;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node2 = nodeList.item(i);
            if (node2.getNodeType() == 3 || !string.equals(node2.getNodeName())) continue;
            arrayList.add(node2);
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    public static String getNodeText(Node node) throws XMLParserException {
        NodeList nodeList = node.getChildNodes();
        Node node2 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node2 = nodeList.item(i);
            if (node2.getNodeType() != 3) continue;
            return node2.getNodeValue();
        }
        throw new XMLParserException("not found text");
    }

    public static Node getAttribute(Node node, String string) throws XMLParserException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = null;
        try {
            node2 = namedNodeMap.getNamedItem(string);
        }
        catch (NullPointerException nullPointerException) {
            throw new XMLParserException(string + " is not found under " + node.getNodeName());
        }
        if (node2 == null) {
            throw new XMLParserException(string + " is not found under " + node.getNodeName());
        }
        return node2;
    }

    public static boolean isAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = null;
        try {
            node2 = namedNodeMap.getNamedItem(string);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return node2 != null;
    }

    public static void main(String[] stringArray) {
        System.out.println(version);
        System.out.println(author);
        System.out.println("Copyright (c) 2003-2007 All right reserved");
    }
}

