/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mjlib.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.wasamon.mjlib.util.PathBalanceTreeConstructorTestLeaf;
import net.wasamon.mjlib.util.PathBalanceTreeConstructorTestNode;

public class PathBalanceTreeConstructor {
    TreeNode root;

    private boolean isPerfectTree(TreeElement treeElement) {
        if (treeElement.isLeaf()) {
            return true;
        }
        int n = ((TreeNode)treeElement).nKids();
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            bl &= this.isPerfectTree(((TreeNode)treeElement).kid(i));
        }
        if (bl) {
            return this.countKidsDepth(((TreeNode)treeElement).kid(0)) == this.countKidsDepth(((TreeNode)treeElement).kid(1));
        }
        return false;
    }

    private int countKidsDepth(TreeElement treeElement) {
        if (treeElement.isLeaf()) {
            return ((TreeLeaf)treeElement).value();
        }
        TreeNode treeNode = (TreeNode)treeElement;
        int n = treeNode.kid(0) != null ? this.countKidsDepth(treeNode.kid(0)) : 0;
        int n2 = treeNode.kid(1) != null ? this.countKidsDepth(treeNode.kid(1)) : 0;
        return 1 + (n > n2 ? n : n2);
    }

    private void add(TreeNode treeNode, TreeLeaf treeLeaf) {
        if (treeNode.kid(0) == null) {
            treeNode.setKid(0, treeLeaf);
            return;
        }
        if (treeNode.kid(1) == null) {
            treeNode.setKid(1, treeLeaf);
            return;
        }
        boolean bl = this.isPerfectTree(treeNode.kid(0));
        boolean bl2 = this.isPerfectTree(treeNode.kid(1));
        int n = this.countKidsDepth(treeNode.kid(0));
        int n2 = this.countKidsDepth(treeNode.kid(1));
        if (bl == bl2) {
            if (n > n2) {
                if (bl) {
                    TreeNode treeNode2 = treeNode.newNode();
                    treeNode2.setKid(0, treeLeaf);
                    treeNode2.setKid(1, treeNode.kid(1));
                    treeNode.setKid(1, treeNode2);
                } else {
                    this.add((TreeNode)treeNode.kid(1), treeLeaf);
                }
            } else if (bl) {
                TreeNode treeNode3 = treeNode.newNode();
                treeNode3.setKid(0, treeLeaf);
                treeNode3.setKid(1, treeNode.kid(0));
                treeNode.setKid(0, treeNode3);
            } else {
                this.add((TreeNode)treeNode.kid(0), treeLeaf);
            }
        } else if (!bl2) {
            if (n + 1 > n2) {
                this.add((TreeNode)treeNode.kid(1), treeLeaf);
            } else {
                this.add((TreeNode)treeNode.kid(0), treeLeaf);
            }
        } else if (n > n2 + 1) {
            this.add((TreeNode)treeNode.kid(1), treeLeaf);
        } else {
            this.add((TreeNode)treeNode.kid(0), treeLeaf);
        }
    }

    public TreeLeaf[] makeTestData(int n) {
        ArrayList<PathBalanceTreeConstructorTestLeaf> arrayList = new ArrayList<PathBalanceTreeConstructorTestLeaf>();
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new PathBalanceTreeConstructorTestLeaf(Math.abs(random.nextInt()) % 10 + 1));
        }
        return arrayList.toArray(new TreeLeaf[arrayList.size()]);
    }

    public void run(TreeNode treeNode, TreeLeaf[] treeLeafArray) {
        List<TreeLeaf> list = Arrays.asList(treeLeafArray);
        Collections.sort(list, new TreeLeafComparatorImpl());
        this.root = treeNode;
        Iterator<TreeLeaf> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.add(this.root, iterator.next());
        }
    }

    public static void main(String[] stringArray) {
        PathBalanceTreeConstructor pathBalanceTreeConstructor = new PathBalanceTreeConstructor();
        pathBalanceTreeConstructor.run(new PathBalanceTreeConstructorTestNode(), pathBalanceTreeConstructor.makeTestData(10));
        System.out.println(pathBalanceTreeConstructor.root);
    }

    class TreeLeafComparatorImpl
    implements Comparator {
        TreeLeafComparatorImpl() {
        }

        public int compare(Object object, Object object2) {
            TreeLeaf treeLeaf = (TreeLeaf)object;
            TreeLeaf treeLeaf2 = (TreeLeaf)object2;
            if (treeLeaf.value() > treeLeaf2.value()) {
                return -1;
            }
            if (treeLeaf.value() < treeLeaf2.value()) {
                return 1;
            }
            return 0;
        }
    }

    public static interface TreeLeaf
    extends TreeElement {
        public int value();
    }

    public static interface TreeNode
    extends TreeElement {
        public int nKids();

        public TreeElement kid(int var1);

        public void setKid(int var1, TreeElement var2);

        public TreeNode newNode();
    }

    public static interface TreeElement {
        public boolean isLeaf();
    }
}

