/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mjlib.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import net.wasamon.mjlib.net.NetworkException;
import net.wasamon.mjlib.util.GetOpt;
import net.wasamon.mjlib.util.GetOptException;

public class TelnetClient {
    public static final String version = "TelnetClient 0.1";
    public static final String author = "Takefumi MIYOSHI (miyo@wasamon.net)";
    public static final String copyright = "(c) 2003/11/04 All right reserved.";
    private static final byte[] cr_b = new byte[]{13};
    private static final byte[] lf_b = new byte[]{10};
    private static final String CR = new String(cr_b);
    private static final String LF = new String(lf_b);
    private static final String CRLF = new String(CR + LF);
    private static final int DEFALTPORT = 23;
    private Socket socket;
    private BufferedOutputStream out;
    private BufferedInputStream in;
    private String host;
    private int port;

    public TelnetClient(String string, int n) throws NetworkException {
        this.host = string;
        this.port = n;
        try {
            this.socket = new Socket(string, n);
            this.in = new BufferedInputStream(this.socket.getInputStream());
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
        }
        catch (UnknownHostException unknownHostException) {
            throw new NetworkException(unknownHostException);
        }
        catch (IOException iOException) {
            throw new NetworkException(iOException);
        }
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            System.out.println("cannot close socket.");
        }
    }

    public String sendln(String string) throws NetworkException {
        return this.send(string + CR + LF);
    }

    public String send(String string) throws NetworkException {
        StringBuffer stringBuffer = new StringBuffer();
        PrintWriter printWriter = new PrintWriter(this.out, true);
        printWriter.print(string);
        if (printWriter.checkError()) {
            throw new NetworkException("cannot send message");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.in));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2 + "\n");
            }
        }
        catch (IOException iOException) {
            throw new NetworkException(iOException);
        }
        return stringBuffer.toString();
    }

    private static void usage() {
        System.out.println(version);
        System.out.println(author);
        System.out.println(copyright);
        System.exit(0);
    }

    public static void main(String[] stringArray) throws NetworkException, GetOptException, IOException {
        String[] stringArray2;
        GetOpt getOpt = new GetOpt("p:v", "port:,version", stringArray);
        int n = 23;
        if (getOpt.flag("p")) {
            n = Integer.decode(getOpt.getValue("p"));
        }
        if (getOpt.flag("port")) {
            n = Integer.decode(getOpt.getValue("port"));
        }
        if (getOpt.flag("v")) {
            TelnetClient.usage();
        }
        if ((stringArray2 = getOpt.getArgs()).length == 0) {
            TelnetClient.usage();
        }
        String string = getOpt.getArgs()[0];
        TelnetClient telnetClient = new TelnetClient(string, n);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        block0: while (telnetClient.isConnected()) {
            while (true) {
                System.out.print(">");
                String string2 = bufferedReader.readLine();
                if (string2 == null) {
                    telnetClient.close();
                    continue block0;
                }
                System.out.println(telnetClient.sendln(string2));
            }
        }
        System.out.println("connection closed.");
        System.exit(0);
    }
}

