/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.jgdb;

import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import net.wasamon.jgdb.GDBClient;
import net.wasamon.jgdb.GDBMIInterface;
import net.wasamon.jgdb.RegisterFrame;
import net.wasamon.mjlib.ui.AWTOptionPane;
import net.wasamon.mjlib.ui.TextAreaOutputStream;

public class JGDBWindow
implements ActionListener {
    private Frame frame;
    private MenuBar menubar;
    private RegisterFrame register;
    private GDBClient gdb;
    private TextArea textArea;
    private MenuItem connectFileMenuItem;
    private MenuItem loadFileMenuItem;
    private MenuItem quitFileMenuItem;
    private MenuItem addBreakGDBMenuItem;
    private MenuItem stepGDBMenuItem;
    private MenuItem runGDBMenuItem;
    private MenuItem registerWindowItem;
    private CheckboxMenuItemList gdbTargetTypeList;

    public GDBClient gdb() {
        return this.gdb;
    }

    private void makeGUI() {
        this.frame = new Frame("J-GDB/MI");
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JGDBWindow.this.exit(0);
            }
        });
        this.frame.setSize(640, 480);
        this.menubar = new MenuBar();
        this.makeMenu(this.menubar);
        this.frame.setMenuBar(this.menubar);
        this.textArea = new TextArea();
        System.setOut(new PrintStream(new TextAreaOutputStream(this.textArea), true));
        this.frame.add((Component)this.textArea, "Center");
        this.register = new RegisterFrame(this);
        this.frame.setVisible(true);
        System.out.println("At first, please connect gdb process");
    }

    private void exit(int stat) {
        if (this.gdb != null) {
            this.gdb.doQuit();
        }
        System.exit(stat);
    }

    private MenuItem makeMenuItem(Menu menu, String label) {
        MenuItem item = new MenuItem(label);
        item.addActionListener(this);
        menu.add(item);
        return item;
    }

    private void makeMenu(MenuBar menubar) {
        this.makeFileMenu(menubar);
        this.makeGDBMenu(menubar);
        this.makeWindowMenu(menubar);
    }

    private void makeFileMenu(MenuBar menubar) {
        Menu m = new Menu("File");
        this.quitFileMenuItem = this.makeMenuItem(m, "Quit");
        menubar.add(m);
    }

    private void makeGDBMenu(MenuBar menubar) {
        Menu m = new Menu("GDB");
        this.connectFileMenuItem = this.makeMenuItem(m, "Connect");
        this.loadFileMenuItem = this.makeMenuItem(m, "Load");
        this.gdbTargetTypeList = new CheckboxMenuItemList(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                CheckboxMenuItem obj = (CheckboxMenuItem)e.getSource();
                String s = obj.getLabel();
                if (JGDBWindow.this.gdb.setTargetType(s)) {
                    System.out.println("set target as " + s);
                    JGDBWindow.this.gdbTargetTypeList.setSelectedCheckbox(obj);
                } else {
                    System.out.println("cannot set target as " + s);
                    JGDBWindow.this.gdbTargetTypeList.setSelectedCheckbox(null);
                }
            }
        }, "Type");
        this.gdbTargetTypeList.setEnabled(false);
        m.add(this.gdbTargetTypeList.menu());
        m.addSeparator();
        this.addBreakGDBMenuItem = this.makeMenuItem(m, "Add Break");
        this.stepGDBMenuItem = this.makeMenuItem(m, "Step I");
        this.runGDBMenuItem = this.makeMenuItem(m, "Run");
        menubar.add(m);
    }

    private void updateGDBTypeList(String[] types) {
        this.gdbTargetTypeList.removeAll();
        int i = 0;
        while (i < types.length) {
            this.gdbTargetTypeList.newCheckbox(types[i]);
            ++i;
        }
        this.gdbTargetTypeList.setEnabled(true);
    }

    private void makeWindowMenu(MenuBar menubar) {
        Menu m = new Menu("Window");
        this.registerWindowItem = this.makeMenuItem(m, "Register");
        menubar.add(m);
    }

    public void go() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JGDBWindow.this.makeGUI();
            }
        });
    }

    public static void main(String[] args) {
        new JGDBWindow().go();
    }

    private DialogStatus connectGDBDialog() {
        DialogStatus status = new DialogStatus();
        String s = AWTOptionPane.showTextFieldDialog(this.frame, "Connected to GDB", "Input path of GDB which you want to connect", "gdb");
        if ((s = s.trim()) != null && s.length() > 0) {
            try {
                this.gdb = new GDBMIInterface(s);
                this.updateGDBTypeList(this.gdb.getTargetList());
            }
            catch (IOException e) {
                status.setError("cannot execute: " + s);
            }
        }
        return status;
    }

    private DialogStatus loadFileDialog() {
        DialogStatus status = new DialogStatus();
        FileDialog dialog = new FileDialog(this.frame, "Open", 0);
        dialog.setVisible(true);
        String filename = dialog.getFile();
        File f = null;
        if (filename != null) {
            f = new File(dialog.getDirectory(), filename);
            if (f != null && !f.exists()) {
                status.setError("no such file: " + f.getAbsolutePath());
            } else if (!this.gdb.doInit(f, null)) {
                status.setError("cannot initialize for " + f.getAbsolutePath());
            }
        } else {
            status.setError("file is not selected");
        }
        return status;
    }

    private DialogStatus addBreakDialog() {
        DialogStatus status = new DialogStatus();
        String s = AWTOptionPane.showTextFieldDialog(this.frame, "Add Break Point", "Input Symbol or Address of Break Point", null);
        if (s != null && s.length() > 0 && !this.gdb.setBreakPoint(s)) {
            status.setError("cannot set break point at " + s);
        }
        return status;
    }

    public void actionPerformed(ActionEvent arg0) {
        Object obj = arg0.getSource();
        if (arg0 != null) {
            if (obj == this.connectFileMenuItem) {
                DialogStatus status = this.connectGDBDialog();
                if (status.flag) {
                    System.out.println("OK");
                } else {
                    System.out.println(status.message);
                }
            } else if (obj == this.loadFileMenuItem) {
                DialogStatus status = this.loadFileDialog();
                if (status.flag) {
                    System.out.println("OK");
                } else {
                    System.out.println(status.message);
                }
            } else if (obj == this.quitFileMenuItem) {
                this.exit(0);
            } else if (obj == this.addBreakGDBMenuItem) {
                DialogStatus status = this.addBreakDialog();
                if (status.flag) {
                    System.out.println("OK");
                } else {
                    System.out.println(status.message);
                }
            } else if (obj == this.stepGDBMenuItem) {
                String result = this.gdb.stepInstruction();
                System.out.println(result);
            } else if (obj == this.runGDBMenuItem) {
                boolean flag = this.gdb.doRun();
            } else if (obj == this.registerWindowItem) {
                this.register.setVisible(true);
            }
        }
    }

    class CheckboxMenuItemList {
        ArrayList checkBoxList;
        ItemListener listener;
        Menu menu;

        public CheckboxMenuItemList(ItemListener listener, String label) {
            this.listener = listener;
            this.checkBoxList = new ArrayList();
            this.menu = new Menu(label);
        }

        public Menu menu() {
            return this.menu;
        }

        public void newCheckbox(String name) {
            CheckboxMenuItem item = new CheckboxMenuItem(name);
            item.setState(false);
            item.addItemListener(this.listener);
            this.checkBoxList.add(item);
            this.menu.add(item);
        }

        public void removeAll() {
            this.checkBoxList.clear();
            this.menu.removeAll();
        }

        public void setEnabled(boolean flag) {
            this.menu.setEnabled(flag);
        }

        public void setSelectedCheckbox(CheckboxMenuItem btn) {
            Iterator it = this.checkBoxList.iterator();
            while (it.hasNext()) {
                CheckboxMenuItem b = (CheckboxMenuItem)it.next();
                if (b == btn) {
                    b.setState(true);
                    continue;
                }
                b.setState(false);
            }
        }
    }

    class DialogStatus {
        boolean flag = true;
        String message = "";

        DialogStatus() {
        }

        public void setError(String mesg) {
            this.flag = false;
            this.message = mesg;
        }
    }
}

