/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.jgdb;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import net.wasamon.jgdb.GDBClient;
import net.wasamon.jgdb.XMLRPCGDBClient;

public class GDBXMLClient
implements GDBClient {
    private String id;
    private XMLRPCGDBClient server = XMLRPCGDBClient.getInstance();

    public GDBXMLClient(String gdbPath) throws IOException {
        String id = (String)this.makeNewGdb(gdbPath);
        if (id.startsWith("[EE]")) {
            throw new IOException("cannot connect gdb process");
        }
        this.id = id;
    }

    private Object makeNewGdb(String gdbPath) {
        Vector<String> v = new Vector<String>();
        v.add(gdbPath);
        return this.server.execCommand("makeNewGdb", v);
    }

    public Object execGdbCommand(String cmd) {
        Vector<String> v = new Vector<String>();
        v.add(this.id);
        v.add(cmd);
        return this.server.execCommand("execCommand", v);
    }

    public Object doInit(String path) {
        Vector<String> v = new Vector<String>();
        v.add(this.id);
        v.add(path);
        return this.server.execCommand("doInit", v);
    }

    public Object doInit(File srcFile) {
        byte[] buf = new byte[1024];
        int len = 0;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            FileInputStream src = new FileInputStream(srcFile);
            while ((len = src.read(buf, 0, buf.length)) != -1) {
                data.write(buf, 0, len);
            }
        }
        catch (FileNotFoundException e) {
            return "[EE] File Not Found: " + srcFile;
        }
        catch (IOException e) {
            return "[EE] I/O Exception while reading from " + srcFile;
        }
        Vector<Object> v = new Vector<Object>();
        v.add(this.id);
        v.add(data.toByteArray());
        return this.server.execCommand("doInit", v);
    }

    public String readPCCode() {
        Vector<String> v = new Vector<String>();
        v.add(this.id);
        return (String)this.server.execCommand("readPCCode", v);
    }

    public String readMemoryValue(String addr, int length) {
        Vector<Object> v = new Vector<Object>();
        v.add(this.id);
        v.add(addr);
        v.add(new Integer(length));
        return (String)this.server.execCommand("readMemoryValue", v);
    }

    public String readRegister(String reg) {
        Vector<String> v = new Vector<String>();
        v.add(this.id);
        v.add(reg);
        return (String)this.server.execCommand("readRegister", v);
    }

    public boolean doQuit() {
        Vector<String> v = new Vector<String>();
        v.add(this.id);
        return (Boolean)this.server.execCommand("doQuit", v);
    }

    public static void main(String[] args) throws IOException {
        GDBXMLClient client = new GDBXMLClient("gdb");
        client.doQuit();
    }

    public boolean setValueToRegister(String addr, String value) {
        Vector<String> v = new Vector<String>();
        v.add(this.id);
        v.add(addr);
        v.add(value);
        return (Boolean)this.server.execCommand("setValueToRegister", v);
    }

    public String getSignal() {
        Vector<String> v = new Vector<String>();
        v.add(this.id);
        return (String)this.server.execCommand("getSignal", v);
    }

    public boolean isStopped() {
        Vector<String> v = new Vector<String>();
        v.add(this.id);
        return (Boolean)this.server.execCommand("isStopped", v);
    }

    public String stepInstruction() {
        Vector<String> v = new Vector<String>();
        v.add(this.id);
        return (String)this.server.execCommand("stepInstruction", v);
    }

    public boolean doInit(String path, String breakPoint) {
        return false;
    }

    public boolean doInit(File source, String breakPoint) {
        return false;
    }

    public boolean doRun() {
        return false;
    }

    public String getProcessName() {
        return null;
    }

    public String[] getRegNameList() {
        return null;
    }

    public String[] getRegValueList() {
        return null;
    }

    public String[] getTargetList() {
        return null;
    }

    public boolean setBreakPoint(String point) {
        return false;
    }

    public boolean setTargetType(String point) {
        return false;
    }
}

