/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.jgdb;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.wasamon.jgdb.GDBClient;
import net.wasamon.jgdb.GdbInfo;

public class GDBMIInterface
implements GDBClient {
    private String processName;
    private Process gdb;
    private BufferedReader pReader;
    private BufferedWriter pWriter;
    private String currentSource;
    public static String GDBPROMPT = "(gdb) ";
    String signal = null;
    boolean stopFlag;
    private static final Pattern patternTargetList = Pattern.compile("\"target (\\S+) --.*");

    public GDBMIInterface(String command) throws IOException {
        this.gdb = Runtime.getRuntime().exec(String.valueOf(command) + " --interpreter=mi");
        this.processName = command;
        this.pReader = new BufferedReader(new InputStreamReader(this.gdb.getInputStream()));
        this.pWriter = new BufferedWriter(new OutputStreamWriter(this.gdb.getOutputStream()));
        this.startup();
    }

    public GDBMIInterface() throws IOException {
        this("gdb");
    }

    public String getProcessName() {
        return this.processName;
    }

    private void startup() throws IOException {
        this.read();
        GdbInfo info = this.execCommand("-gdb-set height 0");
    }

    public Process getProcess() {
        return this.gdb;
    }

    public GdbInfo read() throws IOException {
        GdbInfo info = new GdbInfo();
        while (true) {
            String s = this.pReader.readLine();
            info.addMessage(s);
            if (s == null || s.equals(GDBPROMPT)) break;
            if (s.startsWith("^")) {
                info.setStatus(s.substring(1));
                continue;
            }
            if (s.startsWith("*")) {
                info.setStatus(s.substring(1));
                continue;
            }
            if (s.startsWith("~")) {
                info.addMessage(s.substring(1));
                continue;
            }
            if (s.startsWith("&")) {
                info.addDebugMessage(s.substring(1));
                continue;
            }
            if (!s.startsWith("@")) continue;
            info.addTargetMessage(s.substring(1));
        }
        return info;
    }

    public void writeln(String str) throws IOException {
        this.pWriter.write(String.valueOf(str) + "\n");
        this.pWriter.flush();
    }

    private synchronized GdbInfo execCommand(String cmd) {
        GdbInfo info = null;
        try {
            this.writeln(cmd);
            info = this.read();
        }
        catch (IOException e) {
            info = new GdbInfo();
            info.setStatus(2);
        }
        return info;
    }

    public boolean openFile(String file) {
        this.currentSource = file;
        GdbInfo info = this.execCommand("-file-exec-and-symbols " + file);
        return info.getStatus() == 1;
    }

    public boolean setTargetType(String type) {
        GdbInfo info = this.execCommand("-target-select " + type);
        return info.getStatus() == 1;
    }

    public String getCurrentSource() {
        return this.currentSource;
    }

    public String readPCCode() {
        GdbInfo info = this.execCommand("-data-disassemble -s $pc -e \"$pc+1\" -- 0");
        return info.getMessage();
    }

    public static Vector parseMemoryData(String str, int len) throws NumberFormatException {
        Vector<Byte> data = new Vector<Byte>();
        String[] values = str.split(":\\s+");
        if (values.length > 1 && values[1].length() > 2 && values[1].charAt(0) == '0' && values[1].charAt(1) == 'x') {
            long tmp = Long.parseLong(values[1].substring(2), 16);
            int i = 0;
            while (i < len) {
                data.add(new Byte((byte)((tmp & (long)(255 << (len - i - 1) * 8)) >> (len - i - 1) * 8)));
                ++i;
            }
        } else {
            throw new NumberFormatException(str);
        }
        return data;
    }

    public static int byteToInt(byte[] d) throws NumberFormatException {
        int tmp = 0;
        if (d.length > 4) {
            throw new NumberFormatException();
        }
        int i = 0;
        while (i < d.length) {
            tmp <<= 8;
            tmp += d[i] & 0xFF;
            ++i;
        }
        return tmp;
    }

    public static int byteToInt(Byte[] d) throws NumberFormatException {
        int tmp = 0;
        if (d.length > 4) {
            throw new NumberFormatException();
        }
        int i = 0;
        while (i < d.length) {
            tmp <<= 8;
            tmp += d[i].intValue() & 0xFF;
            ++i;
        }
        return tmp;
    }

    public static long byteToLong(byte[] d) throws NumberFormatException {
        long tmp = 0L;
        if (d.length > 8) {
            throw new NumberFormatException();
        }
        int i = 0;
        while (i < d.length) {
            tmp <<= 8;
            tmp += (long)(d[i] & 0xFF);
            ++i;
        }
        return tmp;
    }

    public String readMemoryValue(String addr, int length) {
        GdbInfo info = this.execCommand("-data-read-memory  " + addr + " x 1 1 " + length);
        return info.getMessage();
    }

    public String readRegister(String reg) {
        GdbInfo info = this.execCommand("-data-list-register-values x " + reg);
        return info.getMessage();
    }

    public boolean doQuit() {
        GdbInfo info = this.execCommand("-gdb-exit");
        return info.getStatus() == 1;
    }

    private boolean loadImage() {
        GdbInfo info = this.execCommand("-target-download");
        return info.getStatus() == 1;
    }

    public boolean doInit(String file, String breakPoint) {
        if (!this.openFile(file)) {
            return false;
        }
        if (!this.loadImage()) {
            return false;
        }
        if (breakPoint != null) {
            if (!this.setBreakPoint(breakPoint)) {
                return false;
            }
            if (!this.doRun()) {
                return false;
            }
        }
        return true;
    }

    public boolean doInit(File file, String breakPoint) {
        return this.doInit(file.getAbsolutePath(), breakPoint);
    }

    public boolean doRun() {
        GdbInfo info = this.execCommand("-exec-run");
        while (info.getStatus() == 3) {
            try {
                info = this.read();
            }
            catch (IOException e) {
                System.out.println(e);
                return false;
            }
        }
        if (info.getStatus() == 5) {
            this.stopFlag = true;
        } else if (info.getStatus() == 4) {
            this.signal = info.getSignal();
        }
        return true;
    }

    public boolean setBreakPoint(String point) {
        GdbInfo info = this.execCommand("-break-insert " + point);
        return info.getStatus() != 2;
    }

    public boolean setValueToRegister(String addr, String value) {
        GdbInfo info = this.execCommand("-gdb-set " + addr + "=" + value);
        return info.getStatus() != 2;
    }

    public String stepInstruction() {
        GdbInfo info = this.execCommand("-exec-step-instruction");
        while (info.getStatus() == 3) {
            try {
                info = this.read();
            }
            catch (IOException e) {
                System.out.println(e);
                return null;
            }
        }
        if (info.getStatus() == 5) {
            this.stopFlag = true;
        } else if (info.getStatus() == 4) {
            this.signal = info.getSignal();
        }
        return info.getMessage();
    }

    public static void main(String[] args) throws Exception {
        String cmd;
        GDBMIInterface gdb = args.length < 1 ? new GDBMIInterface() : new GDBMIInterface(args[0]);
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Hello gdb.");
        do {
            System.out.print("<gdb> ");
        } while (!(cmd = reader.readLine()).equals("quit"));
    }

    public String getSignal() {
        return this.signal;
    }

    public boolean isStopped() {
        return this.stopFlag;
    }

    public String[] getRegNameList() {
        return null;
    }

    public String[] getRegValueList() {
        return null;
    }

    public String[] getTargetList() {
        GdbInfo info = this.execCommand("help target");
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new StringReader(info.getMessage()));
        try {
            String s = null;
            while ((s = reader.readLine()) != null) {
                Matcher m = patternTargetList.matcher(s);
                if (!m.matches()) continue;
                list.add(m.group(1));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list.toArray(new String[list.size()]);
    }
}

