#ifndef MCURSES_H
#define MCURSES_H

#include <curses.h>
#include <stdarg.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <wchar.h>

void mcurses_init();
void mcurses_final();

void minitscr();
void mendwin();
void mmove(int y, int x);
void mmove_immediately(int y, int x);
int mmvprintw(int y, int x, char* str, ...);
int mprintw(char* str, ...);

#define kCAReverse 0x1
#define kCABold 0x2
#define kCAUnderline 0x4
#define kCABlack 0x8
#define kCARed 0x10
#define kCAGreen 0x20
#define kCAYellow 0x40
#define kCABlue 0x80
#define kCAMagenta 0x100
#define kCACyan 0x200
#define kCAWhite 0x400
#define kCABackBlack 0x800
#define kCABackRed 0x1000
#define kCABackGreen 0x2000
#define kCABackYellow 0x4000
#define kCABackBlue 0x8000
#define kCABackMagenta 0x10000
#define kCABackCyan 0x20000
#define kCABackWhite 0x40000

void mattron(int attrs);
void mattroff();

void mreset_terminal();

int mgetmaxx();
int mgetmaxy();
void mclear_immediately();
void mclear_buffer();
void mclear();
void mclear_online(int y);

#define kKeyMapKeysMax 10
void madd_keymap(int key, char keyes[kKeyMapKeysMax]);

void mbox(int y, int x, int width, int height);

void mrefresh();
int mkbuf_exist();
int mgetch(int* meta);

int mis_curses();    // 1: true 0:false

enum eKanjiCode { kEuc, kSjis, kUtf };
extern enum eKanjiCode gKanjiCode;

extern int is_kanji(unsigned char c);

int str_termlen(char* mbs);
int wcs_termlen(wchar_t* wcs);
void str_cut(char* mbs, int termsize, char* dest_mbs, int dest_byte);
void str_cut2(char* mbs, int termsize, char* dest_mbs, int dest_byte);
    // fill space
void str_cut3(char* mbs, int termsize, char* dest_mbs, int dest_byte);
    // fill space
    // remove from top
int str_utflen(char* mbs);
char* str_utfpos2pointer(char* mbs, int pos);
int str_pointer2utfpos(char* mbs, char* point);
int str_termpos(char* mbs, int utfpos);

#endif

