#include <stdio.h>
#include <time.h>
#include <unistd.h>
#include <termios.h>
#include "mlib/mcurses.h"

static struct termios gTtySave;

int main(int argc, char* argv[])
{
    int key;
    int meta;

    tcgetattr(STDIN_FILENO, &gTtySave);

    /// is terminal ///
    if(!isatty(0) || !isatty(1)) {
        fprintf(stderr, "standard input is not a tty\n");
        return 1;
    }

    printf("\nHIT ANY KEY\n");
    fflush(stdout);

    mcurses_init();

    minitscr();

    key = mgetch(&meta);

    mendwin();

    tcsetattr(STDIN_FILENO, TCSANOW, &gTtySave);

    mcurses_final();
 
    return 0;
}
