#include "common.h"

bool gViewHelp = false;

static int gScrollTop = 0;

const int kMaxMessage = 61;

void help_start()
{
    gViewHelp = true;
    gScrollTop = 0;
}

void help_view()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();
    
    mclear();

    mmove(0,0);

    char* buf[kMaxMessage] = {
        "UP, CTRL-P                        move cursor up",
        "DOWN, CTRL-N                      move cursor down",
        "LEFT, CTRL-B                      move cursor left",
        "RIGHT, CTRL-F                     move cursor right",
        "CTRL-A                            move cursor top",
        "CTRL-E                            move cursor bottom",
        "PAGEUP, CTRL-U                    move cursor 5 up",
        "PAGEDOWN, CTRL-D                  move cursor 5 down",
        "BACKSPACE, CTRL-H                 move to parent direcotry",
        "Meta + Left                       move to previous directory",
        "\\                                 move to root directory",
        "~                                 move to home directory" ,
        "ENTER                             run cursor file(insert directory)",
        "q                                 quit the Minnu's Filer",
        "CTRL+L                            redraw the screen",
        "c                                 copy file",
        "C                                 cp prgoram",
        "m                                 move file",
        "M                                 mv prgoram",
        "d                                 move file to $HOME/mtrashbox",
        "D                                 delete file",
        "e                                 edit file(run $EDITOR)",
        "E                                 edit new file",
        "l                                 make symbolic link",
        "v                                 view file(run $PAGER)",
        "r                                 rename",
        "a                                 open attribute menu",
        "n                                 make new file",
        "k                                 make new direcotry",
        "p                                 compression",
        "u                                 unpack",
        "b                                 backup",
        "i                                 info",
        "g                                 grep1",
        "G                                 grep2",
        "f,/                               incremental search",
        "F                                 find",
        "s                                 open sort and view menu",
        "o                                 copy direcotry path",
        "O                                 copy direcotry path2",
        "w                                 exchange two directories",
        "j                                 change directory with cmdline",
        "J                                 change dircetory with menu",
        "@                                 sudo menu",
        "_                                 extra menu",
        "CTRL-C                            copy a file under cursor or mark files",
        "CTRL-X                            cut a file under cursor or mark files",
        "CTRL-V                            past files",
        "CTRL-Z                            undo",
        "h                                 switch command line mode",
        "x                                 run a command with file under cursor",
        ":                                 run shell($SHELL)",
        "z                                 next command will be runned with xterminal",
        "*                                 glob mark" ,
        "SPACE                             mark file under cursor" ,
        "HOME                              mark all files without directory",
        "END                               mark all files",
        "CTRL + T, CTRL + N                clone new tab",
        "CTRL + W                          remove current tab",
        "CTRL + I (tab)                    change current tab",
        "0-9                               return pty"
    };

    for(int i=gScrollTop; i<gScrollTop+maxy; i++) {
        if(i < kMaxMessage) {
            mmvprintw(i-gScrollTop, 0, buf[i]);
        }   
    }

    mmove_immediately(maxy-1, maxx-1);
    mrefresh();
}

void help_input(int meta, int key)
{
    const int maxy = mgetmaxy();

    // 'q' CTRL-C CTRL-G Escape
    if(key == 'q' || key == 3 || key == 7||key == 27) { 
        gViewHelp = false;
    }
    // space f CTRL-D PAGE DOWN
    else if(key == ' '|| key == 'f' || key == 4||key == KEY_NPAGE) {
        if(kMaxMessage >= maxy) {
            gScrollTop += 10;
            if(gScrollTop+maxy > kMaxMessage) {
                gScrollTop -= gScrollTop+maxy-kMaxMessage;
            }
        }
    }
    // b CTRL-U PAGE UP
    else if(key == 'b' || key ==21 || key == KEY_PPAGE) {
        gScrollTop -= 10;

        if(gScrollTop < 0) {
            gScrollTop = 0;
        }
    }
    // CTRL-N DOWN CTRL-M CTRL-J
    else if(key == 14 || key == 10 || key == 13 || key == KEY_DOWN) {
        if(kMaxMessage >= maxy) {
            gScrollTop ++;
            if(gScrollTop+maxy > kMaxMessage) {
                gScrollTop -= gScrollTop+maxy-kMaxMessage;
            }
        }
    }
    else if(key == 16 || key == KEY_UP) {    /// CTRL-P UP
        gScrollTop--;

        if(gScrollTop < 0) {
            gScrollTop = 0;
        }
    }
}
