/*
 * $Id: mbcnvt.h 1.2 2005/08/31 16:07:50 Joe Exp Joe $
 */

#ifndef _MBCNVT_H_
#define _MBCNVT_H_

#define MAX_MBSTRBUF  1024

#define CP932    "CP932"   /* AKA MS SJIS */
#define EUC_JP   "EUC-JP"
#define UTF_8    "UTF-8"

#if !defined(DEF_TGT_CODE)
#define DEF_TGT_CODE  EUC_JP  /* default target code is euc-jp */
#endif

#if !defined(DEF_FRM_CODE)
#define DEF_FRM_CODE  CP932  /* default from code is cp932 */
#endif


/*
 * macros
 */

/* ASCII 7bit */
#define IS_ASCII(v) \
	((0x00 <= (unsigned char)(0xff & (v))) && ((unsigned char)(0xff & (v)) <= 0x7f))

/* CP932 1st byte */
#define IS_CP932_KANA(v) \
	((0xa0 <= (unsigned char)(0xff & (v))) && ((unsigned char)(0xff & (v)) <= 0xdf))

#define IS_CP932_JIS1(v) \
	((0x81 <= (unsigned char)(0xff & (v))) && ((unsigned char)(0xff & (v)) <= 0x9f))

#define IS_CP932_JIS2(v) \
	((0xe0 <= (unsigned char)(0xff & (v))) && ((unsigned char)(0xff & (v)) <= 0xef))

#define IS_CP932(v)  (IS_CP932_KANA(v) || IS_CP932_JIS1(v) || IS_CP932_JIS2(v))

/* EUC-JP 1st byte */
#define IS_EUCJP_2BYTES(v) \
	(((0xa1 <= (unsigned char)(0xff & (v))) && \
	  ((unsigned char)(0xff & (v)) <= 0xfe)) || \
	 ((unsigned char)(0xff & (v)) == 0x8e))

#define IS_EUCJP_3BYTES(v, w) \
	(((0x8f == (unsigned char)(0xff & (v))) && \
	  ( 0xa1 <= (unsigned char)(0xff & (w))) && \
	  ((unsigned char)(0xff & (w)) <= 0xfe)))

#define IS_EUCJP(v, w)  (IS_EUCJP_2BYTES(v) || IS_EUCJP_3BYTES(v, w))


/*
 * src and dst have to have enough buffer size, MAX_MBSTRBUF, at least
 * ret: pointer to dst[]
 */
extern char*
run_iconv(char dst[], const char src[], const char* tocode, const char* fromcode);


#endif  /* !_MBCNVT_H_ */
