/*
 * messasy
 *
 * Copyright (C) 2006,2007,2008,2009 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 * $RCSfile: $
 * $Revision: $
 * $Date: $
 */

#define _XOPEN_SOURCE
#define _GNU_SOURCE
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <stdbool.h>
#include <stdint.h>
#include <unistd.h>
#include <syslog.h>
#include <errno.h>
#include <time.h>
//#include <tcutil.h>
//#include <tcrdb.h>
#include <dlfcn.h>
#include <regex.h>
#include <libdgstr.h>
#include <libdgmail.h>
#include <libdgconfig.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <limits.h>
#include <libmilter/mfapi.h>
#include <sys/utsname.h>
#include <pthread.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

/* Messasy include file */
#include "messasy.h"
#include "msy_config.h"
#include "msy_readmodule.h"
#include "utils.h"
#include "log.h"
#include "../lib_lm.h"

/* Header for my library */
#include "libmaildrop.h"

/* ʸ */
#define CHAR_MAILDROP_MAILFOLDER "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.%,_&-+ "
#define CHAR_MAILDROP_DOT_DELIMITER "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789,-_ "
#define CHAR_MAILDROP_SLASH_DELIMITER "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789,-_ "

#define MYMODULE "maildrop"

#define HEADER_FUNC     "maildrop_exec_header"
#define BODY_FUNC       "maildrop_exec_body"
#define EOM_FUNC        "maildrop_exec_eom"
#define ABORT_FUNC      "maildrop_exec_abort"
#define MODCONF_FUNC    "maildrop_exec_modconf"

/* ץȥ */
static int maildrop_set_extra_config (char *, struct extra_config **, size_t);
static int maildrop_set_module_list (char *, char *, struct modulelist **);

static char * is_mailfolder(char *str);
static char * is_dotdelimiter(char *str);
static char * is_slashdelimiter(char *str);
static struct maildrop *md_struct_init(unsigned int, struct maildrop_config *,
                                        time_t, struct strset *,
                                        struct strlist *, struct strlist *);
static int md_makesavefilename(unsigned int, struct maildrop *, char *, int, char *);
static int md_makedirlist(unsigned int, struct maildrop *, struct strlist **);
static int md_makedirbylist(unsigned int, struct maildrop *, struct strlist *);
static int md_makemaildir_tree(unsigned int, char *, int);
static void md_makemaildir(unsigned int, char *);
static int md_mkdir(unsigned int, char *);
static void md_makesavefile(unsigned int, struct maildrop *,
                            char *, struct strlist *);
static void md_list2str(unsigned int, struct strset *, struct strlist *);
static void md_free(struct maildrop *);



/* extern struct modulehandle *mhandle_list; */
struct modulehandle *mhandle_list;
char msy_hostname[MAX_HOSTNAME_LEN + 1];

struct cfentry maildrop_cfe[] = {
    {
        "MailDir", CF_STRING, NULL,
        OFFSET(struct maildrop_config, cf_maildir), is_writable_directory
    },
    {
        "MailFolder", CF_STRING, NULL,
        OFFSET(struct maildrop_config, cf_mailfolder), is_mailfolder
    },
    {
        "DotDelimiter", CF_STRING, ",",
        OFFSET(struct maildrop_config, cf_dotdelimiter), is_dotdelimiter
    },
    {
        "SlashDelimiter", CF_STRING, "_",
        OFFSET(struct maildrop_config, cf_slashdelimiter), is_slashdelimiter
    }
};

/*
 * maildrop_init
 *
 * ǽ:
 *    maildrop⥸塼νؿ
 *
 * :
 *    struct cfentry **cfe      config entry ¤
 *    size_t cfesize            config entry ¤ΤΥ
 *    struct config  **cfg      config ¤
 *    size_t cfgsize            config ¤ΤΥ
 *
 * :
 *     0: 
 *    -1: ۾
 */
int
maildrop_init(struct cfentry **cfe, size_t *cfesize,
           struct config **cfg, size_t *cfgsize)
{
    struct config *new_cfg;
    struct cfentry *new_cfe;
    size_t new_cfesize, new_cfgsize;
    int ret, i;
    struct modulelist *tmp_list;

    /* ⥸塼ꥹȤؤɲ */
    ret = maildrop_set_module_list(MYMODULE, HEADER_FUNC, &(*cfg)->cf_exec_header);
    if (ret != 0) {
        return -1;
    }
    ret = maildrop_set_module_list(MYMODULE, BODY_FUNC, &(*cfg)->cf_exec_body);
    if (ret != 0) {
        /* إåΥ곫*/
        if (strcmp((*cfg)->cf_exec_header->mlist_modulename, MYMODULE) == 0) {
            tmp_list = (*cfg)->cf_exec_header;
            (*cfg)->cf_exec_header = (*cfg)->cf_exec_header->mlist_next;
            free(tmp_list);
        }
        return -1;
    }
    ret = maildrop_set_module_list(MYMODULE, EOM_FUNC, &(*cfg)->cf_exec_eom);
    if (ret != 0) {
        /* إåΥ곫*/
        if (strcmp((*cfg)->cf_exec_header->mlist_modulename, MYMODULE) == 0) {
            tmp_list = (*cfg)->cf_exec_header;
            (*cfg)->cf_exec_header = (*cfg)->cf_exec_header->mlist_next;
            free(tmp_list);
        }
        /* ܥǥΥ곫*/
        if (strcmp((*cfg)->cf_exec_body->mlist_modulename, MYMODULE) == 0) {
            tmp_list = (*cfg)->cf_exec_body;
            (*cfg)->cf_exec_body = (*cfg)->cf_exec_body->mlist_next;
            free(tmp_list);
        }
        return -1;
    }
    ret = maildrop_set_module_list(MYMODULE, ABORT_FUNC, &(*cfg)->cf_exec_abort);
    if (ret != 0) {
        /* إåΥ곫*/
        if (strcmp((*cfg)->cf_exec_header->mlist_modulename, MYMODULE) == 0) {
            tmp_list = (*cfg)->cf_exec_header;
            (*cfg)->cf_exec_header = (*cfg)->cf_exec_header->mlist_next;
            free(tmp_list);
        }
        /* ܥǥΥ곫*/
        if (strcmp((*cfg)->cf_exec_body->mlist_modulename, MYMODULE) == 0) {
            tmp_list = (*cfg)->cf_exec_body;
            (*cfg)->cf_exec_body = (*cfg)->cf_exec_body->mlist_next;
            free(tmp_list);
        }
        /* eomΥ곫*/
        if (strcmp((*cfg)->cf_exec_eom->mlist_modulename, MYMODULE) == 0) {
            tmp_list = (*cfg)->cf_exec_eom;
            (*cfg)->cf_exec_eom = (*cfg)->cf_exec_eom->mlist_next;
            free(tmp_list);
        }
        return -1;
    }

    /* cfgγĥ */
    new_cfgsize = *cfgsize + sizeof(struct maildrop_config);
    new_cfg = (struct config *)realloc(*cfg, new_cfgsize);
    if(new_cfg == NULL) {
        SYSLOGERROR(ERR_MALLOC, "maildrop_set_module_list", strerror(errno));
        /* إåΥ곫*/
        if (strcmp((*cfg)->cf_exec_header->mlist_modulename, MYMODULE) == 0) {
            tmp_list = (*cfg)->cf_exec_header;
            (*cfg)->cf_exec_header = (*cfg)->cf_exec_header->mlist_next;
            free(tmp_list);
        }
        /* ܥǥΥ곫*/
        if (strcmp((*cfg)->cf_exec_body->mlist_modulename, MYMODULE) == 0) {
            tmp_list = (*cfg)->cf_exec_body;
            (*cfg)->cf_exec_body = (*cfg)->cf_exec_body->mlist_next;
            free(tmp_list);
        }
        /* eomΥ곫*/
        if (strcmp((*cfg)->cf_exec_eom->mlist_modulename, MYMODULE) == 0) {
            tmp_list = (*cfg)->cf_exec_eom;
            (*cfg)->cf_exec_eom = (*cfg)->cf_exec_eom->mlist_next;
            free(tmp_list);
        }
        /* abortΥ곫*/
        if (strcmp((*cfg)->cf_exec_abort->mlist_modulename, MYMODULE) == 0) {
            tmp_list = (*cfg)->cf_exec_abort;
            (*cfg)->cf_exec_abort = (*cfg)->cf_exec_abort->mlist_next;
            free(tmp_list);
        }
        return -1;
    }
    *cfg = new_cfg;

    /* cfeγĥ */
    new_cfesize = *cfesize + sizeof(maildrop_cfe);
    new_cfe = (struct cfentry *)realloc(*cfe, new_cfesize);
    if(new_cfe == NULL) {
        SYSLOGERROR(ERR_MALLOC, "maildrop_set_module_list", strerror(errno));
        /* إåΥ곫*/
        if (strcmp((*cfg)->cf_exec_header->mlist_modulename, MYMODULE) == 0) {
            tmp_list = (*cfg)->cf_exec_header;
            (*cfg)->cf_exec_header = (*cfg)->cf_exec_header->mlist_next;
            free(tmp_list);
        }
        /* ܥǥΥ곫*/
        if (strcmp((*cfg)->cf_exec_body->mlist_modulename, MYMODULE) == 0) {
            tmp_list = (*cfg)->cf_exec_body;
            (*cfg)->cf_exec_body = (*cfg)->cf_exec_body->mlist_next;
            free(tmp_list);
        }
        /* eomΥ곫*/
        if (strcmp((*cfg)->cf_exec_eom->mlist_modulename, MYMODULE) == 0) {
            tmp_list = (*cfg)->cf_exec_eom;
            (*cfg)->cf_exec_eom = (*cfg)->cf_exec_eom->mlist_next;
            free(tmp_list);
        }
        /* abortΥ곫*/
        if (strcmp((*cfg)->cf_exec_abort->mlist_modulename, MYMODULE) == 0) {
            tmp_list = (*cfg)->cf_exec_abort;
            (*cfg)->cf_exec_abort = (*cfg)->cf_exec_abort->mlist_next;
            free(tmp_list);
        }
        return -1;
    }

    /* maildrop_cfeΥԡ */
    memcpy(new_cfe + *cfesize / sizeof(struct cfentry),
           &maildrop_cfe, sizeof(maildrop_cfe));

    /* dataoffsetι */
    for (i = 0; i < MAILDROP_CFECOUNT; i++) {
        new_cfe[(*cfesize / sizeof(struct cfentry)) + i].cf_dataoffset += *cfgsize;
    }
    *cfe = new_cfe;

    /* ⥸塼config¤offsetǼ */
    ret = maildrop_set_extra_config(MYMODULE, &(*cfg)->cf_extraconfig, *cfgsize);
    if (ret != 0) {
        /* إåΥ곫*/
        if (strcmp((*cfg)->cf_exec_header->mlist_modulename, MYMODULE) == 0) {
            tmp_list = (*cfg)->cf_exec_header;
            (*cfg)->cf_exec_header = (*cfg)->cf_exec_header->mlist_next;
            free(tmp_list);
        }
        /* ܥǥΥ곫*/
        if (strcmp((*cfg)->cf_exec_body->mlist_modulename, MYMODULE) == 0) {
            tmp_list = (*cfg)->cf_exec_body;
            (*cfg)->cf_exec_body = (*cfg)->cf_exec_body->mlist_next;
            free(tmp_list);
        }
        /* eomΥ곫*/
        if (strcmp((*cfg)->cf_exec_eom->mlist_modulename, MYMODULE) == 0) {
            tmp_list = (*cfg)->cf_exec_eom;
            (*cfg)->cf_exec_eom = (*cfg)->cf_exec_eom->mlist_next;
            free(tmp_list);
        }
        /* abortΥ곫*/
        if (strcmp((*cfg)->cf_exec_abort->mlist_modulename, MYMODULE) == 0) {
            tmp_list = (*cfg)->cf_exec_abort;
            (*cfg)->cf_exec_abort = (*cfg)->cf_exec_abort->mlist_next;
            free(tmp_list);
        }
        /* reallocեΰĤäơ¾ΥѤǤ*/

        return -1;
    }

    /* cfesize, cfgsizeι */
    *cfesize = new_cfesize;
    *cfgsize = new_cfgsize;

    return 0;
}

/*
 * maildrop_set_module_list
 *
 * ǽ:
 *    maildrop⥸塼ѤΥ⥸塼ꥹȺ
 *
 * :
 *    char *modname             ⥸塼̾
 *    char *funcname            ؿ̾
 *    struct modulelist **list  ⥸塼ꥹ
 *
 * :
 *     0: 
 *    -1: ۾
 */
int
maildrop_set_module_list(char *modname, char *funcname, struct modulelist **list)
{
    struct modulelist *new_list;

    /* module̾Υݥ󥿤Ǽΰγ */
    new_list = (struct modulelist *)malloc(sizeof(struct modulelist));
    if(new_list == NULL) {
        SYSLOGERROR(ERR_MALLOC, "maildrop_set_module_list", strerror(errno));
        return -1;
    }

    new_list->mlist_modulename = modname;
    new_list->mlist_funcname = funcname;
    new_list->mlist_next = *list;
    *list = new_list;

    return 0;
}

/*
 * maildrop_set_extra_config
 *
 * ǽ:
 *    maildrop⥸塼Ѥextra configκ
 *
 * :
 *    char *modname                     ⥸塼̾
 *    struct extra_config **ext_cfg     extra config ꥹ
 *    size_t cfgsize                    config ¤ΤΥ(extra config ޤǤoffset)
 *
 * :
 *     0: 
 *    -1: ۾
 */
int
maildrop_set_extra_config(char *modname, struct extra_config **ext_cfg,
                        size_t cfgsize)
{
    struct extra_config *new_cfg;

    /* ⥸塼config¤Υݥ󥿤Ǽΰγ */
    new_cfg = (struct extra_config *)malloc(sizeof(struct extra_config));
    if(new_cfg == NULL) {
        SYSLOGERROR(ERR_MALLOC, "maildrop_set_module_list", strerror(errno));
        return -1;
    }

    new_cfg->excf_modulename = modname;

    new_cfg->excf_config = (void *)cfgsize;
    new_cfg->excf_next = *ext_cfg;
    *ext_cfg = new_cfg;

    return 0;
}

/*
 * is_mailforder
 *
 * ǽ
 *    ᡼եΥå
 *
 * 
 *      char *str   åʸ
 *
 * ֤
 *      NULL                   
 *      ERR_CONF_MAILFOLDER    顼å
 */
char *
is_mailfolder(char *str)
{
    char string[] = CHAR_MAILDROP_MAILFOLDER;
    int  i, j;

    /* ʸƬ.פǤʤȤγǧ */
    if (str[0] != '.') {
        return ERR_MAILDROP_MAILFOLDER;
    }

    for (i = 0; str[i] != '\0'; i++) {
        /*.פϢ³ƤʤȤγǧ */
        if ((str[i] == '.') && (str[i+1] == '.')) {
            return ERR_MAILDROP_MAILFOLDER;
        }
        /* ᡼ե̾ȤŬڤʸȤƤ뤳Ȥγǧ */
        for (j = 0; string[j] != '\0'; j++) {
            if (str[i] == string[j]) {
                break;
            }
        }
        /* ʸפ뤳Ȥʤȴ硢顼 */
        if (string[j] == '\0') {
            return ERR_MAILDROP_MAILFOLDER;
        }
    }
    /* ʸκǸ夬ǤʤȤγǧ */
    if (str[i-1] == '.') {
        return ERR_MAILDROP_MAILFOLDER;
    }
    return NULL;
}

/*
 * is_dotdelimiter
 *
 * ǽ
 *    .֤ʸΥå
 *
 * 
 *      char *str   åʸ
 *
 * ֤
 *      NULL                     
 *      ERR_CONF_DOTDELIMITER    顼å
 */
char *
is_dotdelimiter(char *str)
{
    char string[] = CHAR_MAILDROP_DOT_DELIMITER;
    int i;

    /* ʸǤ뤫 */
    if (str[1] != '\0') {
        return ERR_MAILDROP_DOTDELIMITER;
    }

    /* ʸå */
    for (i = 0; string[i] != '\0'; i++ ) {
        if (str[0] == string[i]) {
            break;
        }
    }
    /* פ뤳ȤʤȴƤޤäϡȿʸ */
    if (string[i] == '\0' ) {
        return ERR_MAILDROP_DOTDELIMITER;
    }
    return NULL;
}

/*
 * is_slashdelimiter
 *
 * ǽ
 *    /֤ʸΥå
 *
 * 
 *      char *str   åʸ
 *
 * ֤
 *      NULL                       
 *      ERR_CONF_SLASHDELIMITER    顼å
 */
char *
is_slashdelimiter(char *str)
{
    char string[] = CHAR_MAILDROP_SLASH_DELIMITER;
    int i;

    /* ʸǤ뤫 */
    if (str[1] != '\0') {
        return ERR_MAILDROP_SLASHDELIMITER;
    }

    /* ʸå */
    for (i = 0; string[i] != '\0'; i++ ) {
        if (str[0] == string[i]) {
            break;
        }
    }
    /* פ뤳ȤʤȴƤޤäϡȿʸ */
    if (string[i] == '\0' ) {
        return ERR_MAILDROP_SLASHDELIMITER;
    }
    return NULL;
}

/*
 * maildrop_free_config
 *
 * ǽ:
 *    maildropconfigΰfreeؿ
 * :
 *    mP     : priv¤ΤĤʤ¤
 * :
 *     0: 
 *    -1: ۾
 */
int
maildrop_free_config(struct config *cfg)
{
    struct maildrop_config *p = NULL;
    struct extra_config *exp;

    if (cfg == NULL || cfg->cf_extraconfig == NULL) {
        return -1;
    }

    for (exp = cfg->cf_extraconfig; exp != NULL; exp = exp->excf_next) {
	if (strcmp(MYMODULE, exp->excf_modulename) == 0) {
	    p = (struct maildrop_config *)(exp->excf_config);
	    break;
	}
    }

    /* pĤä*/
    if (p != NULL) {
        if (p->cf_maildir != NULL) {
            free(p->cf_maildir);
        }
        if (p->cf_mailfolder != NULL) {
            free(p->cf_mailfolder);
        }
        if (p->cf_dotdelimiter != NULL) {
            free(p->cf_dotdelimiter);
        }
        if (p->cf_slashdelimiter != NULL) {
            free(p->cf_slashdelimiter);
        }
    } else {
        return -1;
    }

    return 0;
}

/***** ***** ***** ***** *****
 * ؿ
 ***** ***** ***** ***** *****/

/*
 * md_struct_init
 *
 * maildrop¤ΤγݤȽԤʤ
 *
 * 
 *      unsigned int            åID
 *      struct config *         config¤ΤΥݥ
 *      time_t                  ᡼
 *
 * ֤
 *      struct maildrop *       maildrop¤
 */
static struct maildrop *
md_struct_init(unsigned int s_id, struct maildrop_config *config, time_t time,
                struct strset *from, struct strlist *to_h,
                struct strlist *saveaddr_h)
{
    struct maildrop *md;
    int ret;

    /* ΰ */
    md = (struct maildrop *)malloc(sizeof(struct maildrop));
    if (md == NULL) {
        SYSLOGERROR(ERR_S_MALLOC, s_id, "md_struct_init", E_STR);
        exit(EXIT_MILTER);
    }
    memset(md, 0, sizeof(struct maildrop));

    /* ¸*/
    md->md_recvtime = time;

    /* MailDir, MailFolderͤ¸*/
    strset_set(&md->md_maildir, config->cf_maildir);
    strset_set(&md->md_mailfolder, config->cf_mailfolder);

    /* dotdelmiter, slashdelimiter¸*/
    md->md_dotdelimiter = *(config->cf_dotdelimiter);
    md->md_slashdelimiter = *(config->cf_slashdelimiter);

    /* إå*/
    /* FROMإåν*/
    strset_init(&md->md_header_from);
    /* ͳǼ*/
    ret = strset_catstrset(&md->md_header_from, from);
    if (ret == -1) {
        SYSLOGERROR(ERR_S_LIBFUNC, s_id, "strset_catstrset", E_STR);
        exit(EXIT_MILTER);
    }
    /* TOإåν*/
    strset_init(&md->md_header_to);
    /* ͳǼ*/
    md_list2str(s_id, &md->md_header_to, to_h);

    /* ¸ɥ쥹γǼ*/
    md->md_saveaddr_h = saveaddr_h;

    return md;
}


/*
 * maildrop_get_priv
 *
 * ǽ:
 *    extraprivΰ褬ʤк
 *    мʬѤΰextraprivΰݥ󥿤֤ؿ
 * :
 *    priv: mlfiPriv¤ΤΥݥ(Ϥ)
 * :
 *   ʬѤextrapriv¤ΤΥݥ
 */
struct extrapriv *
maildrop_get_priv(struct mlfiPriv **priv)
{
    struct extrapriv *p = NULL;      /*  */
    struct extrapriv *mp = NULL;     /*  */
    struct extrapriv *p_old = NULL;  /* 桢ҤȤΥݥ¸ */

    if (*priv != NULL) {
        /* ʬpriv¤Τ뤫 */
        for (p = (*priv)->mlfi_extrapriv; p != NULL; p = p->expv_next) {
            if (strcmp(MYMODULE, p->expv_modulename) == 0) {
                /* ä꥿ */
                return p;
            }
            /* ҤȤΥݥ󥿳Ǽ */
            p_old = p;
        }
    }
    /* ʬѤextraprivΰ迷 */
    mp = malloc(sizeof(struct extrapriv));
    if (mp == NULL) {
        SYSLOGERROR(ERR_MALLOC, "maildrop_get_priv", E_STR);
        return NULL;
    }
    /* ͤγǼ */
    /* MYMODULEͤ򤽤Τޤ޻ͤΤǡȤϤʤǤ*/
    mp->expv_modulename = MYMODULE;
    /* NEXT˽*/
    mp->expv_next = NULL;
    /* ץ饤١Ȥν*/
    mp->expv_modulepriv = NULL;

    /* ¸ߤƤʤäƬ˥ݥ󥿤դ */
    if (p_old == NULL) {
        (*priv)->mlfi_extrapriv = mp;

    /* ¸ߤƤ뤬ʬѤʤäˤĤ */
    } else if (p == NULL) {
        p_old->expv_next = mp;
    }
    return mp;
}

/*
 * maildrop_priv_free
 *
 * ǽ:
 *    ٤Ƥpriv¤Τfreeؿ
 * :
 *     extrapriv:   ι¤ΤΥݥ(Ϥ)
 * :
 *    ̵
 */
void
maildrop_priv_free(struct extrapriv *expv)
{
    /* NULLå */
    if (expv != NULL) {
        /* maildrop_privΰ褬 */
        if (expv->expv_modulepriv != NULL) {
            /* maildrop_priv¤Τfree */
            /* private ѿ*/
            free(expv->expv_modulepriv);
            expv->expv_modulepriv = NULL;
        }
        /* extraprivΰfree */
        free(expv);
        expv = NULL;
    }

    return;
}


/*
 * maildrop_abort
 *
 * ᡼¸ߤ
 *
 * 
 *      unsigned int            åID ()
 *      struct maildrop *       maildrop¤
 *
 * ֤
 *      ̵
 */
void
maildrop_abort(unsigned int s_id, struct maildrop *md)
{
    /* ץ饤١ȾNULLξ*/
    if (md == NULL) {
        return;
    }

    if (md->md_tempfile_fd > 0) {
        /* ե뤬ץ󤵤Ƥϥ */
        close(md->md_tempfile_fd);
        md->md_tempfile_fd = 0;
    }
    unlink(md->md_tempfilepath);
    return;
}

/*
 * maildrop_exec_header
 *
 * ǽ:
 *    mlfi_headerǸƤФؿ
 *    privΰγݡإåΥǼؿ
 * :
 *    priv   : priv¤ΤĤʤ¤
 *    headerf: إåι̾
 *    headerv: إåιܤФ
 * :
 *     0: 
 *    -1: ۾
 */
int
maildrop_exec_header(struct mlfiPriv *priv, char *headerf, char *headerv)
{
    /* ѿ*/
    struct extrapriv     *expv;
    struct extra_config  *p;
    struct maildrop_priv *mypv;
    struct maildrop      *mydat;
    struct maildrop      *mydatp;
    int                  ret;
    unsigned int         s_id;

    /* */
    expv = NULL;
    p = NULL;
    mypv = NULL;
    mydat = NULL;
    mydatp = NULL;
    ret = 0;
    s_id = priv->mlfi_sid;


    /* extraprivΰ̵ͭ */
    expv = maildrop_get_priv(&priv);

    /* maildrop_get_priv顼λ */
    if (expv == NULL) {
        SYSLOGERROR(ERR_EXEC_FUNC, "maildrop_exec_header", "maildrop_get_priv");
        return -1;
    }

    /* maildrop_privΰ褬ʤä */
    if (expv->expv_modulepriv == NULL) {
        /* maildropΰ */
        mypv = malloc(sizeof(struct maildrop_priv));
        if (mypv == NULL) {
            SYSLOGERROR(ERR_MALLOC, "maildrop_exec_header", E_STR);
            return -1;
        }

        /* 2ĤĤʤ */
        expv->expv_modulepriv = mypv;

        /* ʬconfig¤θ */ 
        if (priv->config->cf_extraconfig != NULL) { 
            for (p = priv->config->cf_extraconfig; p != NULL; p = p->excf_next) {
                if (!strcmp(MYMODULE, p->excf_modulename)) {
                    break;
                }
            }
        }

        
        /* ץ  ᡼¸򳫻 */
        mydat = maildrop_open(s_id, ((struct maildrop_config *)p->excf_config),
                           priv->mlfi_recvtime, &(priv->mlfi_envfrom),
                           priv->mlfi_rcptto_h, priv->mlfi_addrmatched_h,
                           priv->config->cf_msyhostname);
        if (mydat == NULL) {
            SYSLOGERROR(ERR_S_FOPEN, s_id, "maildrop_exec_header", "maildrop_open");
            free(mypv);
            return -1;
        }
        
        /* ¤ΤĤʤ */
        mypv->mypriv = mydat;
    }

    /* maildrop¤ΤΥݥ󥿤ѿ˳Ǽ */
    mydatp = ((struct maildrop_priv *)expv->expv_modulepriv)->mypriv;

    /* إå񤭹*/
    ret = maildrop_write_header(s_id, mydatp, headerf, headerv);
    if (ret != R_SUCCESS) {
        SYSLOGERROR(ERR_EXEC_FUNC, "maildrop_exec_header", "maildrop_write_header");
        return -1;
    }

    return 0;
}

/*
 * maildrop_exec_body
 *
 * ǽ:
 *    mlfi_bodyǸƤФؿ
 *    privΰγݡإåΥǼؿ
 * :
 *    *priv  : priv¤ΤĤʤ¤(Ϥ)
 *    *bodyp : mlfi_bodyܥǥ
 *    bodylen: bodypΥ
 * :
 *     0: 
 *    -1: ۾
 */
int
maildrop_exec_body(struct mlfiPriv *priv, u_char *bodyp, size_t bodylen)
{
    /* ѿ*/
    struct extrapriv     *expv;
    struct maildrop      *mydat;
    struct maildrop_priv *mypv;
    struct maildrop      *mydatp;
    int                   ret;
    unsigned int          s_id;
    struct extra_config  *p;

    /* */
    expv = NULL;
    p = NULL;
    mypv = NULL;
    mydat = NULL;
    mydatp = NULL;
    ret = 0;
    s_id = priv->mlfi_sid;


    /* extraprivΰ̵ͭ */
    expv = maildrop_get_priv(&priv);
    /* maildrop_get_priv顼λ */
    if (expv == NULL) {
        SYSLOGERROR(ERR_EXEC_FUNC, "maildrop_exec_body", "maildrop_get_priv");
        return -1;
    }

    /* maildrop_privΰ褬ʤä */
    if (expv->expv_modulepriv == NULL) {
        /* maildropΰ */
        mypv = malloc(sizeof(struct maildrop_priv));
        if (mypv == NULL) {
            SYSLOGERROR(ERR_MALLOC, "maildrop_exec_body", E_STR);
             return -1;
        }

        /* 2ĤĤʤ */
        expv->expv_modulepriv = mypv;

        /* ʬconfig¤θ */ 
        if (priv->config->cf_extraconfig != NULL) { 
            for (p = priv->config->cf_extraconfig; p != NULL; p = p->excf_next) {
                if (!strcmp(MYMODULE, p->excf_modulename)) {
                    break;
                }
            }
        }

       
        /* ץ  ᡼¸򳫻 */
        mydat = maildrop_open(s_id, ((struct maildrop_config *)p->excf_config),
                           priv->mlfi_recvtime, &(priv->mlfi_envfrom),
                           priv->mlfi_rcptto_h, priv->mlfi_addrmatched_h,
                           priv->config->cf_msyhostname);
        if (mydat == NULL) {
            SYSLOGERROR(ERR_S_FOPEN, s_id, "maildrop_exec_header", "maildrop_open");
            free(mypv);
            return -1;
        }
        
        /* ¤ΤĤʤ */
        mypv->mypriv = mydat;
    }

    /* ᡼ǡ*/
    mydat = ((struct maildrop_priv *)expv->expv_modulepriv)->mypriv;

    /* ܥǥ񤭹 */
    ret = maildrop_write_body(s_id, mydat, bodyp, bodylen);
    if (ret != R_SUCCESS) {
        SYSLOGERROR(ERR_EXEC_FUNC, "maildrop_exec_body", "maildrop_write_body");
        return -1;
    }

    return 0;
}

/*
 * maildrop_exec_eom
 *
 * ǽ:
 *    mlfi_eomǸƤФؿ
 *    mlfi_headerǳǼإå¤Τ˳Ǽ
 *    DBϿؿ
 * :
 *    priv: priv¤ΤĤʤ¤(Ϥ)
 * :
 *     0: 
 *    -1: ۾
 */
int
maildrop_exec_eom(struct mlfiPriv *priv)
{
    /* ѿ*/
    struct extrapriv    *p;
    struct extrapriv    *p_old;
    struct maildrop     *mydat;
    int                  ret;
    unsigned int         s_id;

    /* */
    p = NULL;
    p_old = NULL;
    mydat= NULL;
    ret = 0;
    s_id = priv->mlfi_sid;

    /* ʬΰ̵ͭå*/
    if (priv != NULL) {
        /* ʬpriv¤Τ뤫*/
        for (p = priv->mlfi_extrapriv; p != NULL; p = p->expv_next) {
            if (!strcmp(MYMODULE, p->expv_modulename)) {
                break;
            }
            p_old = p;
        }
 
        /* ΰ褬extrapriv¤*/
        if (p_old != NULL) {
            if (p != NULL) {
                mydat = ((struct maildrop_priv *)p->expv_modulepriv)->mypriv;
                /* */
                ret = maildrop_close(s_id, mydat, priv->config->cf_msyhostname);
                if (ret != R_SUCCESS) {
                    SYSLOGERROR(ERR_EXEC_FUNC, "maildrop_exec_eom", "maildrop_close");
                    return -1;
                }
                /* ι¤Τnextfree빽¤ΤnextĤʤ*/
                p_old->expv_next = p->expv_next;
                /* ץ饤١ȥǡ*/
                maildrop_priv_free(p);

            }
        /* PƬξ*/
        } else {
            if (p != NULL) {
                mydat = ((struct maildrop_priv *)p->expv_modulepriv)->mypriv;
                /* */
                ret = maildrop_close(s_id, mydat, priv->config->cf_msyhostname);
                if (ret != R_SUCCESS) {
                    SYSLOGERROR(ERR_EXEC_FUNC, "maildrop_exec_eom", "maildrop_close");
                    return -1;
                }
                /* mlfi¤Τfree빽¤ΤnextĤʤ*/
                priv->mlfi_extrapriv = p->expv_next;
                /* ץ饤١Ⱦ*/
                maildrop_priv_free(p);
            }
        }
    }
    return 0;
}

/*
 * maildrop_exec_abort
 *
 * ǽ:
 *    mlfi_abortexec_eomǸƤФؿ
 *    priv¤Τfreeؿ
 *
 * :
 *    priv: priv¤ΤĤʤ¤
 *
 * :
 *    0(R_SUCCESS): 
 */
int
maildrop_exec_abort(struct mlfiPriv *priv)
{
    /* ѿ*/
    struct extrapriv    *p;
    struct extrapriv    *p_old;
    struct maildrop     *md;
    unsigned int         s_id;

    /* */
    p = NULL;
    p_old = NULL;
    md = NULL;
    s_id = priv->mlfi_sid;

    /* ʬΰ̵ͭå */
    if (priv != NULL) {
        /* ʬpriv¤Τ뤫 */
        for (p = priv->mlfi_extrapriv; p != NULL; p = p->expv_next) {
            if (!strcmp(MYMODULE, p->expv_modulename)) {
                break;
            }
            p_old = p;
        }
        /* ΰ褬extrapriv¤ */
        if (p_old != NULL) {
            if (p != NULL) {
                md = ((struct maildrop_priv *)p->expv_modulepriv)->mypriv;
                /* ܡ */
                maildrop_abort(s_id, md);
                /* ҤȤι¤Τnextfree빽¤ΤnextĤʤ */
                p_old->expv_next = p->expv_next;
                maildrop_priv_free(p);
            }

        /* PƬξ*/
        } else {
            if (p != NULL) {
                md = ((struct maildrop_priv *)p->expv_modulepriv)->mypriv;
                /* ܡ */
                maildrop_abort(s_id, md);
                /* ҤȤι¤Τnextfree빽¤ΤnextĤʤ */
                priv->mlfi_extrapriv = p->expv_next;
                maildrop_priv_free(p);
            }
        }
    }
    return 0;
}

/*
 * maildrop_open
 *
 * ե񤭹ߤνԤʤ
 * - ɬפʥǥ쥯ȥκ
 * - եΥץ
 * - إåͺ
 *
 * 
 *      unsigned int            åID ()
 *      struct config *         config¤
 *      time_t                  
 *      struct strset *         From
 *      struct strlist *        ToƬݥ
 *      struct strlist *        ¸ɥ쥹Ƭݥ
 *
 * ֤
 *      struct maildrop *       
 *      NULL                    顼 (եΥץ˼)
 */
struct maildrop *
maildrop_open(unsigned int s_id, struct maildrop_config *config,
                time_t time, struct strset *from, struct strlist *to_h,
                struct strlist *saveaddr_h, char *msy_hostname)
{
    struct maildrop *md;
    mode_t old_umask;
    int temppathlen;

    /* maildrop¤Τ */
    md = md_struct_init(s_id, config, time, from, to_h, saveaddr_h);

    /* MailDir۲˥֥ǥ쥯ȥ */
    md_makemaildir(s_id, config->cf_maildir);

    /* եΥѥ */
    temppathlen = strlen(config->cf_maildir) +
                    strlen(msy_hostname) + TEMPFILEPATH_LEN;
    md->md_tempfilepath = (char *)malloc(temppathlen);
    if (md->md_tempfilepath == NULL) {
        SYSLOGERROR(ERR_S_MALLOC, s_id, "maildrop_open", E_STR);
        exit(EXIT_MILTER);
    }
    sprintf(md->md_tempfilepath, TEMPFILEPATH,
            config->cf_maildir, md->md_recvtime, msy_hostname);

    /* ե򥪡ץ */
    old_umask = umask(0077);
    md->md_tempfile_fd = mkstemp(md->md_tempfilepath);
    umask(old_umask);
    if (md->md_tempfile_fd < 0) {
        SYSLOGERROR(ERR_S_MKSTEMP, s_id, md->md_tempfilepath, E_STR);
        return NULL;
    }
    return md;
}

/*
 * maildrop_write_header
 *
 * إåե˽Ϥ
 * إå˽񤭹
 *
 * 
 *      unsigned int            åID ()
 *      struct maildrop *       maildrop¤
 *      char *                  إåե (ХåϤ줿ޤ)
 *      char *                  إå (ХåϤ줿ޤ)
 *
 * ֤
 *      R_SUCCESS               
 *      R_ERROR                 顼
 */
int
maildrop_write_header(unsigned int s_id, struct maildrop *md,
                        char *headerf, char *headerv)
{
    char *header, *p;
    int header_len;
    ssize_t written_len;
    int ret;

    if (!md->md_writing_header) {
        /* Ϥ˥إå񤭹 */
        md->md_writing_header = 1;
        ret = maildrop_write_header(s_id, md, CUSTOMHDR_FROM,
                                    md->md_header_from.ss_str);
        if (ret != R_SUCCESS) {
            return ret;
        }
        ret = maildrop_write_header(s_id, md, CUSTOMHDR_TO,
                                    md->md_header_to.ss_str);
        if (ret != R_SUCCESS) {
            return ret;
        }
    }

    /* إåν񤭹 */
    header_len = strlen(headerf) + ((headerv == NULL)?0:strlen(headerv)) + 3; /* ʸ + ': ' + '\n' */
    header = (char *)malloc(header_len + 1);    /* '\0' */
    if (header == NULL) {
        SYSLOGERROR(ERR_S_MALLOC, s_id, "maildrop_write_header", E_STR);
        exit(EXIT_MILTER);
    }
    sprintf(header, "%s: %s\n", headerf, (headerv == NULL)?"":headerv);

    p = header;
    written_len = 0;
    while (written_len < header_len) {
        written_len = write(md->md_tempfile_fd, p, header_len);
        if (written_len < 0) {
            SYSLOGERROR(ERR_S_FWRITE, s_id, md->md_tempfilepath, E_STR);
            free(header);
            return R_ERROR;
        }
        p += written_len;
        header_len -= written_len;
    }

    free(header);

    return R_SUCCESS;
}

/*
 * maildrop_write_body
 *
 * ᡼ܥǥե˽Ϥ
 * إåȥܥǥζڤ˽񤭹
 * ʸCRLFLF줹
 *
 * 
 *      unsigned int            åID ()
 *      struct maildrop *       maildrop¤
 *      unsigned char *         ܥǥ (ХåϤ줿ޤ)
 *      size_t                  Ĺ (ХåϤ줿ޤ)
 *
 * ֤
 *      R_SUCCESS               
 *      R_ERROR                 顼
 */
int
maildrop_write_body(unsigned int s_id, struct maildrop *md,
                    unsigned char *bodyp, size_t len)
{
    ssize_t written_len;
    int ret;
    int i;

    if (!md->md_writing_body) {
        /* Ϥ˥إåȥܥǥζڤʸ񤭹 */
        md->md_writing_body = 1;
        ret = maildrop_write_body(s_id, md, (unsigned char *) "\n", 1);
        if (ret != R_SUCCESS) {
            return ret;
        }
    }

    /* ʸLF줷ʤ顢ʸ񤭹 */
    for (i = 0; i < len; i++, bodyp++) {
        if (md->md_cr) {
            if (*bodyp != '\n') {
                written_len = write(md->md_tempfile_fd, "\r", 1);
                if (written_len < 0) {
                    SYSLOGERROR(ERR_S_FWRITE, s_id, md->md_tempfilepath, E_STR);
                    return R_ERROR;
                }
            }
            md->md_cr = 0;
        }
        if (*bodyp == '\r') {
            md->md_cr = 1;
            continue;
        }
        written_len = write(md->md_tempfile_fd, bodyp, 1);
        if (written_len < 0) {
            SYSLOGERROR(ERR_S_FWRITE, s_id, md->md_tempfilepath, E_STR);
            return R_ERROR;
        }
    }

    return R_SUCCESS;
}

/*
 * maildrop_close
 *
 * ե򥯥¸
 *
 * 
 *      unsigned int            åID ()
 *      struct maildrop *       maildrop¤
 *
 * ֤
 *      R_SUCCESS               
 *      R_ERROR                 顼
 */
int
maildrop_close(unsigned int s_id, struct maildrop *md, char *msy_hostname)
{
    struct strlist *list_h;
    char filename[NAME_MAX + 6];
    size_t ret_s;
    int ret;

    /* ե򥯥 */
    if (md->md_tempfile_fd > 0) {
        /* ʸǤʤCRĤäƤϽ񤭹 */
        if (md->md_cr) {
            ret_s = write(md->md_tempfile_fd, "\r", 1);
            if (ret_s < 0) {
                SYSLOGERROR(ERR_S_FWRITE, s_id, md->md_tempfilepath, E_STR);
            }
            md->md_cr = 0;
        }
        /*  */
        close(md->md_tempfile_fd);
        md->md_tempfile_fd = 0;
    }

    /* ¸Υե̾ */
    ret = md_makesavefilename(s_id, md, filename, sizeof(filename), msy_hostname);
    if (ret != R_SUCCESS) {
        return R_ERROR;
    }

    /* ɬפʥǥ쥯ȥ */
    ret = md_makedirlist(s_id, md, &list_h);
    if (ret != R_SUCCESS) {
        return R_ERROR;
    }

    /* ɬפʥǥ쥯ȥ */
    ret = md_makedirbylist(s_id, md, list_h);
    if (ret != R_SUCCESS) {
        free_strlist(list_h);
        return R_ERROR;
    }

    /* ե륳ԡ */
    md_makesavefile(s_id, md, filename, list_h);

    /* ե */
    unlink(md->md_tempfilepath);

    free_strlist(list_h);

    md_free(md);
    md = NULL;

    return R_SUCCESS;
}


/***** ***** ***** ***** *****
 * ؿ
 ***** ***** ***** ***** *****/

/*
 * md_makedirlist
 *
 * ɬפΤǥ쥯ȥ
 *
 * 
 *      unsigned int            åID
 *      struct maildrop *       maildrop¤
 *
 * ֤
 *      R_SUCCESS               
 *      R_ERROR                 顼
 */
static int
md_makedirlist(unsigned int s_id, struct maildrop *md, struct strlist **list_h)
{
    struct strlist *list_t, *p;
    char mailaddr[MAX_ADDRESS_LEN + 1];
    struct strformat sf[6];
    char year[5], month[3], day[3];
    char *addr_p, *domain_p, *tmp;
    struct strset path;
    struct tm lt, *ret_t;
    int ret;

    /* 狼ִʸ */
    ret_t = localtime_r(&md->md_recvtime, &lt);
    if (ret_t == NULL) {
        SYSLOGERROR(ERR_S_LTIME, s_id, E_STR);
        return R_ERROR;
    }
    strftime(year,  5, "%Y", &lt);
    strftime(month, 3, "%m", &lt);
    strftime(day,   3, "%d", &lt);

    sf[0].sf_formatchar = 'y';
    sf[0].sf_replacestr = year;
    sf[1].sf_formatchar = 'm';
    sf[1].sf_replacestr = month;
    sf[2].sf_formatchar = 'd';
    sf[2].sf_replacestr = day;

    /* ¸оݥɥ쥹˥ǥ쥯ȥ̾ */
    *list_h = list_t = NULL;
    p = md->md_saveaddr_h;
    while (p != NULL) {
        /* ɥ쥹ȥɥᥤ󤫤ִʸ */
        strncpy(mailaddr, p->ss_data.ss_str, MAX_ADDRESS_LEN + 1);
        ret = check_7bit(mailaddr);
        if (ret != 0) {
            /* 8bitʸޤޤ뤿UNKNOWN */
            addr_p = UNKNOWN;
            domain_p = UNKNOWN;
        } else {
            replace_delimiter(mailaddr, DOT, md->md_dotdelimiter);
            replace_delimiter(mailaddr, SLASH, md->md_slashdelimiter);

            domain_p = strchr(mailaddr, '@');
            if (domain_p == NULL) {
                /* ɥ쥹κ˥ɥᥤ䴰Τǡ
                 * ˤʤϤ */
                domain_p = UNKNOWN;
            } else {
                domain_p++;
            }
            addr_p = mailaddr;
        }

        sf[3].sf_formatchar = 'D';
        sf[3].sf_replacestr = domain_p;
        sf[4].sf_formatchar = 'M';
        sf[5].sf_formatchar = 'f';
        sf[4].sf_replacestr = sf[5].sf_replacestr = addr_p;

        /* MailFolderΥեޥåʸִ */
        tmp = str_replace_format(md->md_mailfolder.ss_str, sf, 6);

        /* MailDir, MailFolder (ִ) Ϣ뤹 */
        strset_init(&path);
        if (strset_catstrset(&path, &md->md_maildir) == -1 ||
            strset_catstr(&path, "/") == -1 ||
            strset_catstr(&path, tmp) == -1) {
            SYSLOGERROR(ERR_S_LIBFUNC, s_id, "strset_catstr", E_STR);
            exit(EXIT_MILTER);
        }
        free(tmp);

        /* ǥ쥯ȥɲä
         * ޤäƱΥѥ˰ˤ̵뤹 */
        uniq_push_strlist(list_h, &list_t, path.ss_str);


        strset_free(&path);
        p = p->next;
    }

    return R_SUCCESS;
}

/*
 * md_makedirbylist
 *
 * ǥ쥯ȥ򸵤ˡMaildirΥǥ쥯ȥ
 *
 * 
 *      unsigned int            åID
 *      struct maildrop *       maildrop¤
 *      struct strlist *        ǥ쥯ȥƬݥ
 *
 * ֤
 *      R_SUCCESS               
 *      R_ERROR                 顼
 */
static int
md_makedirbylist(unsigned int s_id, struct maildrop *md, struct strlist *list)
{
    struct strlist *p;
    int ret;

    p = list;
    while (p != NULL) {
        ret = md_makemaildir_tree(s_id, p->ss_data.ss_str,
                                    md->md_maildir.ss_len);

        if (ret != R_SUCCESS) {
            return R_ERROR;
        }

        p = p->next;
    }

    return R_SUCCESS;
}

/*
 * md_makemaildir_tree
 *
 * ꤵ줿ǥ쥯ȥ˻ǥ쥯ȥĥ꡼MaildirǺ
 *
 * /home/archive/Maildir/.2009.10.01
 *  /home/archive/Maildir/.2009/{new,cur,tmp}
 *    /home/archive/Maildir/.2009.10/{new,cur,tmp}
 *    /home/archive/Maildir/.2009.10.01/{new,cur,tmp}
 *
 * 
 *      unsigned int            åID
 *      char *                  ǥ쥯ȥ̾
 *                              (Ǥ⿼ǥ쥯ȥꤹ)
 *      int                     ١ǥ쥯ȥĹ
 *                              (MaildirΥĥ꡼εꤹ)
 *
 * ֤
 *      R_SUCCESS               
 *      R_ERROR                 顼 (顼)
 */
static int
md_makemaildir_tree(unsigned int s_id, char *targetdir, int basedir_len)
{
    char *subtop, *dot;

    /* ݥ󥿤եƬΥɥåȤ˰ư
     * /path/to/basedir/.folder
     *                  ^-subtop */
    subtop = targetdir + basedir_len + 1;
    if (strchr(subtop, SLASH) != NULL) {
        /* ե۲˥å夬ޤޤƤ
         * бƤʤΤǥ顼֤ */
        return R_ERROR;
    }

    /* ֥ǥ쥯ȥ */
    while ((dot = strchr(subtop, DOT)) != NULL) {
        /* ɥåȤ\0˰Ū֤ƥǥ쥯ȥ */
        *dot = '\0';
        md_makemaildir(s_id, targetdir);
        *dot = DOT;
        subtop = dot + 1;
    }

    /* ǽŪʥǥ쥯ȥ */
    md_makemaildir(s_id, targetdir);

    return R_SUCCESS;
}

/*
 * md_makemaildir
 *
 * ꤵ줿ǥ쥯ȥ۲
 *   /new, /cur, /tmp
 * 3ĤΥǥ쥯ȥ
 * ǥ쥯ȥκ˼Ԥ⥨顼Ȥʤ
 *
 * 
 *      unsigned int            åID
 *      char *                  ǥ쥯ȥ̾
 *
 * ֤
 *      ʤ
 */
static void
md_makemaildir(unsigned int s_id, char *dirname)
{
    /* 륵֥ǥ쥯ȥ */
    char *subdirs[] = {
                       "/new",
                       "/cur",
                       "/tmp",
                       NULL
                      };

    struct strset createpath;
    char *tmp;
    int ret, i;

    /* ١ǥ쥯ȥ */
    md_mkdir(s_id, dirname);

    strset_init(&createpath);
    for (i = 0; subdirs[i] != NULL; i++) {
        /* MailDir򥳥ԡ */
        tmp = strdup(dirname);
        if (tmp == NULL) {
            SYSLOGERROR(ERR_S_MALLOC, s_id, "md_makemaildir", E_STR);
            exit(EXIT_MILTER);
        }
        strset_set(&createpath, tmp);

        /* ֥ǥ쥯ȥ̾ (.../new, .../cur, .../tmp) ղ */
        ret = strset_catstr(&createpath, subdirs[i]);
        if (ret == -1) {
            SYSLOGERROR(ERR_S_LIBFUNC, s_id, "strset_catstr", E_STR);
            exit(EXIT_MILTER);
        }
         
        /* ֥ǥ쥯ȥ */
        md_mkdir(s_id, createpath.ss_str);

        strset_free(&createpath);
    }

    return;
}

/*
 * md_mkdir
 *
 * ꤵ줿ǥ쥯ȥ
 *
 * 
 *      unsigned int            åID
 *      char *                  ǥ쥯ȥ̾
 *
 * ֤
 *      R_SUCCESS                (˥ǥ쥯ȥ꤬¸ߤ)
 *      R_ERROR                 顼
 */
static int
md_mkdir(unsigned int s_id, char *dirname)
{
    struct stat stbuf;

    if (stat(dirname, &stbuf) < 0) {
        if (errno != ENOENT) {
            SYSLOGERROR(ERR_S_STAT, s_id, dirname, E_STR);
            return R_ERROR;
        }
        if (mkdir(dirname, 0700) < 0) {
            SYSLOGERROR(ERR_S_MKDIR, s_id, dirname, E_STR);
            return R_ERROR;
        }

        /*  */
        return R_SUCCESS;

    } else {
        if (!S_ISDIR(stbuf.st_mode)) {
            SYSLOGERROR(ERR_S_NDIR, s_id, dirname, E_STR);
            return R_ERROR;
        }

        /* ¸ߤ */
        return R_SUCCESS;
    }

    /* ǰΤ */
    return R_SUCCESS;
}

/*
 * md_makesavefilename
 *
 * ¸ե̾ ("/new/.....") 
 *
 * 
 *      unsigned int            åID
 *      struct maildrop *       maildrop¤
 *      char *                  ե̾γǼ
 *      int                     ǼĹ
 *
 * ֤
 *      R_SUCCESS               
 *      R_ERROR                 顼
 */
static int
md_makesavefilename(unsigned int s_id, struct maildrop *md,
                    char *filename, int filename_len, char *msy_hostname)
{
    struct stat stbuf;
    int ret;

    /* եiΡֹ */
    ret = stat(md->md_tempfilepath, &stbuf);
    if (ret < 0) {
        SYSLOGERROR(ERR_S_STAT, s_id, md->md_tempfilepath, E_STR);
        return R_ERROR;
    }

    /* եΥѥ (/new/....)  */
    snprintf(filename, filename_len, SAVEFILENAME,
                md->md_recvtime, stbuf.st_ino, msy_hostname);

    return R_SUCCESS;
}

/*
 * md_makesavefile
 *
 * ˴ޤޤǥ쥯ȥ۲ˡ¸ե󥯤
 * 󥯤˼Ԥϥ顼Ȥʤ
 *
 * 
 *      unsigned int            åID
 *      struct maildrop *       maildrop¤
 *      char *                  ¸ե̾
 *      struct strlist *        ǥ쥯ȥ
 *
 * ֤
 *      ʤ (󥯤˼Ԥ)
 */
static void
md_makesavefile(unsigned int s_id, struct maildrop *md,
                            char *filename, struct strlist *dirlist)
{
    struct strlist *p;
    struct strset path;
    int ret;

    p = dirlist;
    while (p != NULL) {
        /* ΥեΥեѥ */
        strset_init(&path);
        if (strset_catstr(&path, p->ss_data.ss_str) == -1 ||
            strset_catstr(&path, filename) == -1) {
            SYSLOGERROR(ERR_S_LIBFUNC, s_id, "strset_catstr", E_STR);
            exit(EXIT_MILTER);
        }

        /* ϡɥ󥯤 */
        ret = link(md->md_tempfilepath, path.ss_str);
        if (ret < 0) {
            /* ԤϥϤΤ */
            SYSLOGERROR(ERR_S_LINK, s_id, p->ss_data.ss_str, E_STR);
        }
        strset_free(&path);
        p = p->next;
    }

    return;
}

/*
 * md_list2str
 *
 * strlistΰ饫޶ڤʸ
 *
 * 
 *      unsigned int            åID ()
 *      struct strset *         Ǽstrset¤ΤΥݥ
 *      struct strlist *        Ƭݥ
 *
 * ֤
 *      ʤ
 */
static void
md_list2str(unsigned int s_id, struct strset *target, struct strlist *list_h)
{
    struct strset str;
    struct strlist *p;
    int ret;

    strset_init(&str);
    strset_init(target);

    p = list_h;
    while (p != NULL) {
        if (p != list_h) {
            /* 2ܰʹߤ ", " ǷҤ */
            ret = strset_catstr(&str, ", ");
            if (ret < 0) {
                SYSLOGERROR(ERR_S_LIBFUNC, s_id, "strset_catstr", E_STR);
                exit(EXIT_MILTER);
            }
        }
        ret = strset_catstrset(&str, &(p->ss_data));
        if (ret < 0) {
            SYSLOGERROR(ERR_S_LIBFUNC, s_id, "strset_catstrset", E_STR);
            exit(EXIT_MILTER);
        }
        p = p->next;
    }

    strset_set(target, str.ss_str);

    return;
}

/*
 * md_free
 *
 * maildrop¤Τ
 *
 * 
 *      struct maildrop *       maildrop¤ΤΥݥ
 *
 * ֤
 *      ʤ
 */
static void
md_free(struct maildrop *md)
{
    if (md == NULL) {
        return;
    }

    if (md->md_tempfilepath != NULL) {
        free(md->md_tempfilepath);
        md->md_tempfilepath = NULL;
    }
    strset_free(&md->md_header_from);
    strset_free(&md->md_header_to);

    free(md);

    return;
}

int
maildrop_mod_extra_config(struct config **cfg)
{
    return R_SUCCESS;
}
