/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.runtime.resource;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.Mnemonics;
import jp.sourceforge.mergedoc.pleiades.runtime.advice.RuntimeJointPoint;
import jp.sourceforge.mergedoc.pleiades.runtime.resource.IdentityTranslationCache;
import jp.sourceforge.mergedoc.pleiades.runtime.resource.RuntimeTranslationDictionary;

public class Translations {
    private static final Logger log = Logger.getLogger(Translations.class);
    private static final IdentityTranslationCache cache = new IdentityTranslationCache();
    private static final Map<String, String> backupMap = new ConcurrentHashMap<String, String>();

    private Translations() {
    }

    public static String translate(String en, RuntimeJointPoint jointPoint) {
        if (en == null) {
            return null;
        }
        return cache.translateMnemonic(en, jointPoint);
    }

    public static String[] translate(String[] ens, RuntimeJointPoint jointPoint) {
        if (ens == null) {
            return null;
        }
        for (int i = 0; i < ens.length; ++i) {
            ens[i] = Translations.translate(ens[i], jointPoint);
        }
        return ens;
    }

    public static Object translate(Object en, RuntimeJointPoint jointPoint) {
        if (en == null) {
            return null;
        }
        if (en instanceof String) {
            return Translations.translate((String)en, jointPoint);
        }
        if (en instanceof String[]) {
            return Translations.translate((String[])en, jointPoint);
        }
        if (en instanceof Object[]) {
            return Translations.translate((Object[])en, jointPoint);
        }
        return en;
    }

    public static Object[] translate(Object[] enObjs, RuntimeJointPoint jointPoint) {
        if (enObjs == null) {
            return null;
        }
        if (enObjs instanceof String[]) {
            return Translations.translate((String[])enObjs, jointPoint);
        }
        for (int i = 0; i < enObjs.length; ++i) {
            enObjs[i] = Translations.translate(enObjs[i], jointPoint);
        }
        return enObjs;
    }

    public static String translateMenu(String en, RuntimeJointPoint jointPoint) {
        if (en == null) {
            return null;
        }
        String[] splitsAccelerator = en.split("\t");
        String enMenuText = splitsAccelerator[0];
        if (splitsAccelerator.length == 1) {
            return cache.translateMnemonic(enMenuText, jointPoint);
        }
        return cache.translateMnemonic(enMenuText, jointPoint) + "\t" + splitsAccelerator[1];
    }

    public static String translateIgnoreMnemonic(Object en, RuntimeJointPoint jointPoint) {
        if (en == null) {
            return null;
        }
        if (!(en instanceof String)) {
            log.debug("\u5f15\u6570\u306e\u578b\u304c String \u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002en=%s type=%s", en, en.getClass().getName());
            return String.valueOf(en);
        }
        return cache.translateNoMnemonic((String)en, jointPoint);
    }

    public static String translateIgnoreMnemonic(Object en, RuntimeJointPoint jointPoint, String separator) {
        if (jointPoint != null) {
            jointPoint.separator = separator;
        }
        return Translations.translateIgnoreMnemonic(en, jointPoint);
    }

    public static String translateBefore(Object en, RuntimeJointPoint jointPoint, String separator) {
        String[] s;
        if (en != null && en instanceof String && (s = ((String)en).split(Pattern.quote(separator), 2)).length >= 2) {
            return cache.translateNoMnemonic(s[0], jointPoint) + separator + s[1];
        }
        return Translations.translateIgnoreMnemonic(en, jointPoint);
    }

    public static String translateBackup(String en, RuntimeJointPoint jointPoint) {
        if (en == null) {
            return null;
        }
        String ja = cache.translateMnemonic(en, jointPoint);
        backupMap.put(ja, en);
        return ja;
    }

    public static String translateBackupIgnoreMnemonic(String en, RuntimeJointPoint jointPoint) {
        if (en == null) {
            return null;
        }
        String ja = cache.translateNoMnemonic(en, jointPoint);
        backupMap.put(ja, en);
        return ja;
    }

    public static String[] translateBackupIgnoreMnemonic(String[] ens, RuntimeJointPoint jointPoint) {
        if (ens == null) {
            return null;
        }
        for (int i = 0; i < ens.length; ++i) {
            ens[i] = Translations.translateBackupIgnoreMnemonic(ens[i], jointPoint);
        }
        return ens;
    }

    public static String restoreBackup(String ja, RuntimeJointPoint jointPoint) {
        if (ja == null) {
            return null;
        }
        String en = backupMap.get(ja);
        if (en == null) {
            return ja;
        }
        return en;
    }

    public static String translateSentence(String en, RuntimeJointPoint jointPoint) {
        if (en != null && en.trim().contains(" ")) {
            return cache.translateMnemonic(en, jointPoint);
        }
        return en;
    }

    public static String translateWithoutJaMnemonic(String en, RuntimeJointPoint jointPoint) {
        if (en == null) {
            return null;
        }
        en = Mnemonics.removeJa(en);
        return cache.translateNoMnemonic(en, jointPoint);
    }

    public static String translateUnderscoreMnemonic(String en, RuntimeJointPoint jointPoint) {
        if (en == null) {
            return null;
        }
        return cache.translateUnderscoreMnemonic(en, jointPoint);
    }

    public static void invalidateCache() {
        RuntimeTranslationDictionary.getInstance().isInvalidateCache = true;
        log.info("\u30ad\u30e3\u30c3\u30b7\u30e5\u7834\u68c4\u3092\u6307\u793a\u3057\u307e\u3057\u305f\u3002\u6b21\u56de\u306f -clean \u3067\u8d77\u52d5\u3057\u307e\u3059\u3002", new Object[0]);
    }

    public static void debug(Object obj) {
        StringBuilder sb = new StringBuilder();
        sb.append("Translations#debug(Object) ");
        if (obj != null) {
            sb.append(obj.getClass().getName());
        }
        sb.append("[");
        sb.append(obj);
        sb.append("]");
        log.info(sb.toString(), new Object[0]);
    }

    public static void debug(Object en, RuntimeJointPoint jointPoint) {
        StringBuilder sb = new StringBuilder();
        sb.append("Translations#debug(Object,JointPoint) ");
        if (jointPoint != null) {
            sb.append("(");
            sb.append(jointPoint.getClassName());
            sb.append("#");
            sb.append(jointPoint.getMethodName());
            sb.append(") ");
        }
        if (en != null) {
            sb.append(en.getClass().getName());
        }
        sb.append("[");
        sb.append(en);
        sb.append("] -> [");
        sb.append(Translations.translate(en, jointPoint));
        sb.append("]");
        log.info(sb.toString(), new Object[0]);
    }

    public static void debug(Object en, RuntimeJointPoint jointPoint, String key) {
        StringBuilder sb = new StringBuilder();
        sb.append("Translations#debug(Object,JointPoint,String) ");
        if (jointPoint != null) {
            sb.append("(");
            sb.append(jointPoint.getClassName());
            sb.append("#");
            sb.append(jointPoint.getMethodName());
            sb.append(") ");
        }
        if (en != null) {
            sb.append(en.getClass().getName());
        }
        sb.append("[");
        sb.append(en);
        sb.append("] -> [");
        sb.append(Translations.translate(en, jointPoint));
        sb.append("]");
        sb.append(" key=");
        sb.append(key);
        log.info(sb.toString(), new Object[0]);
    }

    public static void debug(String[] ens, RuntimeJointPoint jointPoint) {
        StringBuilder sb = new StringBuilder();
        sb.append("Translations#debug(String[],JointPoint) ");
        if (jointPoint != null) {
            sb.append("(");
            sb.append(jointPoint.getClassName());
            sb.append("#");
            sb.append(jointPoint.getMethodName());
            sb.append(") ");
        }
        if (ens != null) {
            sb.append(ens.getClass().getName());
            sb.append(Arrays.asList(ens));
        }
        sb.append(" -> ");
        sb.append(Arrays.asList(Translations.translate(ens, jointPoint)));
        log.info(sb.toString(), new Object[0]);
    }

    public static void printStackTrace(Object obj, RuntimeJointPoint jointPoint) {
        log.info(new Throwable(), "Translator#printStackTrace " + (obj == null ? "" : obj.getClass().getName()) + "[" + obj + "] -> [" + Translations.translate(obj, jointPoint) + "]", new Object[0]);
    }
}

