/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.runtime.resource;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.mergedoc.org.apache.commons.lang.StringUtils;
import jp.sourceforge.mergedoc.pleiades.Pleiades;
import jp.sourceforge.mergedoc.pleiades.PleiadesOption;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.AbstractTranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.resource.Mnemonics;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationString;
import jp.sourceforge.mergedoc.pleiades.runtime.advice.PleiadesConfig;
import jp.sourceforge.mergedoc.pleiades.runtime.advice.RuntimeJointPoint;
import jp.sourceforge.mergedoc.pleiades.runtime.advice.TraceConfig;
import jp.sourceforge.mergedoc.pleiades.runtime.resource.CacheFiles;
import jp.sourceforge.mergedoc.pleiades.runtime.resource.CallHierarchyExplorer;
import jp.sourceforge.mergedoc.pleiades.runtime.util.CachePropertySet;
import jp.sourceforge.mergedoc.pleiades.runtime.util.ValueHashPropertySet;

public class RuntimeTranslationDictionary
extends AbstractTranslationDictionary {
    private static final Logger log = Logger.getLogger(RuntimeTranslationDictionary.class);
    private static final File transCacheFile = Pleiades.getResourceFile(CacheFiles.TRANS_CACHE_PROP);
    private static final File mnemonicCacheFile = Pleiades.getResourceFile(CacheFiles.MNEMONIC_CACHE_PROP);
    private static RuntimeTranslationDictionary instance;
    private static final String IF_KEY_PREFIX = "%IF%";
    private static final char[] GLOBAL_MULTIBYTES_CHARS;
    protected static PleiadesOption pleiadesOption;
    private ValueHashPropertySet transCacheProp;
    private CachePropertySet mnemonicCacheProp;
    private final Map<String, PropertySet> packageConditionMap = new HashMap<String, PropertySet>();
    private final CallHierarchyExplorer callHierarchy = CallHierarchyExplorer.getInstance();
    private final TraceConfig traceConfig;
    public boolean isInvalidateCache;

    static {
        GLOBAL_MULTIBYTES_CHARS = "\u2010\u2018\u2019\u201c\u201d\u00a4\u00b6\u00a0\u2026\u21e7\u2318\u2325\u2303\u23ce\u2192".toCharArray();
        pleiadesOption = Pleiades.getPleiadesOption();
    }

    public static RuntimeTranslationDictionary getInstance() {
        if (instance == null) {
            instance = new RuntimeTranslationDictionary();
        }
        return instance;
    }

    protected RuntimeTranslationDictionary() {
        this.traceConfig = PleiadesConfig.getInstance().traceConfig;
        this.isResolveFirstRegex = false;
    }

    @Override
    protected boolean load() {
        this.transCacheProp = new ValueHashPropertySet(100000, "\u7ffb\u8a33\u30ad\u30e3\u30c3\u30b7\u30e5\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc");
        this.mnemonicCacheProp = new CachePropertySet(5000, "\u30cb\u30fc\u30e2\u30cb\u30c3\u30af\u5909\u63db\u30ad\u30e3\u30c3\u30b7\u30e5\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc");
        if (!transCacheFile.exists()) {
            super.load();
            this.transCacheProp.putAll(this.transOverrideProp);
        } else {
            try {
                this.transCacheProp.load(transCacheFile);
                if (mnemonicCacheFile.exists()) {
                    this.mnemonicCacheProp.load(mnemonicCacheFile);
                }
            }
            catch (RuntimeException e) {
                log.warn("\u7ffb\u8a33\u30ad\u30e3\u30c3\u30b7\u30e5 %s \u306e\u7834\u640d\u3092\u691c\u51fa\u3002\u5fa9\u5143\u4e2d... - %s", transCacheFile, e.toString());
                transCacheFile.delete();
                this.transCacheProp.clear();
                this.transCacheProp.load(RuntimeTranslationDictionary.validateExists("translation-first.properties"));
                mnemonicCacheFile.delete();
                this.mnemonicCacheProp.clear();
            }
        }
        return true;
    }

    public void shutdown() {
        this.isLoadedDefault = true;
        this.mnemonicCacheProp.store(mnemonicCacheFile);
        if (this.transCacheProp.size() > 500000) {
            log.warn("\u7ffb\u8a33\u30ad\u30e3\u30c3\u30b7\u30e5\u304c\u5927\u304d\u304f\u306a\u308a\u3059\u304e\u3066\u3044\u308b\u305f\u3081\u30af\u30ea\u30a2\u3057\u307e\u3057\u305f\u3002" + this.transCacheProp.size(), new Object[0]);
            this.transCacheProp.clear();
        }
        this.transCacheProp.store(transCacheFile);
        if (Pleiades.getPleiadesOption().enabledNotFoundLog) {
            this.transCacheProp.store(new File(transCacheFile.getPath().replaceFirst("\\.zip$", "")));
        }
    }

    public String lookup(String enWithMnemonic, RuntimeJointPoint jointPoint) {
        return this.lookup(enWithMnemonic, jointPoint, true);
    }

    public String lookup(String enWithMnemonic, RuntimeJointPoint jointPoint, boolean mnemonics) {
        try {
            String en = enWithMnemonic;
            if (mnemonics) {
                if (Mnemonics.hasJa(enWithMnemonic)) {
                    if (enWithMnemonic.endsWith(")") || enWithMnemonic.contains(")...")) {
                        return enWithMnemonic;
                    }
                    en = Mnemonics.removeJa(enWithMnemonic);
                } else {
                    en = Mnemonics.removeEn(enWithMnemonic);
                }
            }
            if (this.transCacheProp.containsValue(en.trim())) {
                return enWithMnemonic;
            }
            String ja = this.lookupInternal(en, jointPoint);
            if (!en.equals(ja)) {
                if (this.callHierarchy.isExcludeTranslation(en, jointPoint)) {
                    if (en.equals("Debug")) {
                        return enWithMnemonic;
                    }
                    ja = en;
                } else if (ja.startsWith(IF_KEY_PREFIX)) {
                    PropertySet packageMap = this.packageConditionMap.get(en);
                    if (packageMap == null) {
                        packageMap = new PropertySet();
                        this.packageConditionMap.put(en, packageMap);
                        String pkgValues = ja.substring(IF_KEY_PREFIX.length());
                        String[] pv = pkgValues.split(",");
                        packageMap.put(null, pv[0]);
                        int i = 1;
                        while (i < pv.length) {
                            String[] kv = pv[i].split("=");
                            packageMap.put(kv[0], kv[1]);
                            ++i;
                        }
                    }
                    ja = this.callHierarchy.findTrace(packageMap);
                }
            }
            if (mnemonics) {
                ja = this.convertMnemonicEnToJa(enWithMnemonic, en, ja);
            }
            if (this.traceConfig != null && this.traceConfig.pattern != null) {
                String target;
                String string = target = this.traceConfig.isJa ? ja : en;
                if (target.matches(this.traceConfig.pattern)) {
                    String s = String.valueOf(System.currentTimeMillis()) + "\u300c" + enWithMnemonic + "\u300d\u2192\u300c" + ja + "\u300d";
                    log.debug(new Throwable(s), "\u30c7\u30d0\u30c3\u30b0\u7ffb\u8a33\u8ffd\u8de1\u30b9\u30bf\u30c3\u30af\u30c8\u30ec\u30fc\u30b9 jointPoint:" + jointPoint, new Object[0]);
                    return s;
                }
            }
            return ja;
        }
        catch (Exception e) {
            log.error(e, "\u7ffb\u8a33\u30a8\u30e9\u30fc enWithMnemonic=%s mnemonics=%s jointPoint=%s", enWithMnemonic, mnemonics, jointPoint);
            return enWithMnemonic;
        }
    }

    protected String lookupInternal(String en, RuntimeJointPoint jointPoint) {
        String ja = this.transCacheProp.get(en);
        if (ja != null) {
            if (ja.isEmpty()) {
                ja = en;
            }
        } else {
            ja = this.getValueByRegex(new TranslationString(en));
            if (ja != null) {
                this.transCacheProp.put(en, ja);
            } else {
                String e = en;
                if (e.startsWith("<html>") && e.contains("<style>")) {
                    e = e.replaceFirst("(?s)\\s*<style>.+</style>\\s*", "");
                }
                if (e.length() != e.getBytes().length && !StringUtils.containsAny(e, GLOBAL_MULTIBYTES_CHARS)) {
                    ja = en;
                } else {
                    if (super.load()) {
                        log.debug("\u30ad\u30e3\u30c3\u30b7\u30e5\u306b\u306a\u3044\u305f\u3081\u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u3092\u30ed\u30fc\u30c9: %s", Property.escapeKey(en));
                    }
                    String separator = jointPoint != null ? jointPoint.separator : null;
                    ja = this.getValue(en, separator);
                }
                this.transCacheProp.put(en, en.equals(ja) ? "" : ja);
            }
        }
        return ja;
    }

    protected String convertMnemonicEnToJa(String enWithMnemonic, String en, String ja) {
        if (RuntimeTranslationDictionary.pleiadesOption.isNoMnemonic) {
            return ja;
        }
        if (enWithMnemonic.length() == en.length()) {
            return ja;
        }
        String jaWithMnemonic = this.mnemonicCacheProp.get(enWithMnemonic);
        if (jaWithMnemonic == null) {
            jaWithMnemonic = Mnemonics.convertEnToJa(enWithMnemonic, en, ja);
            this.mnemonicCacheProp.put(enWithMnemonic, jaWithMnemonic);
        }
        return jaWithMnemonic;
    }
}

