/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.runtime.resource;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.mergedoc.org.apache.commons.lang.StringUtils;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.AbstractTranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;

public class RegexDictionary {
    private static final Logger log = Logger.getLogger(RegexDictionary.class);
    private static final int REGEX_LIST_CAPACITY = 1000;
    private static final int REGEX_THROUGH_LIST_CAPACITY = 100;
    private static final RegexDictionary singleton = new RegexDictionary();
    private final Map<String, List<RegexEntry>> firstCharMap = new HashMap<String, List<RegexEntry>>();
    private final Map<String, List<RegexEntry>> lastCharMap = new HashMap<String, List<RegexEntry>>();
    private final List<RegexEntry> otherList = new ArrayList<RegexEntry>();
    private Pattern throughPattern;

    public static RegexDictionary getInstance() {
        return singleton;
    }

    private RegexDictionary() {
        File file = AbstractTranslationDictionary.validateExists("translation-regex.properties");
        for (Property p : new PropertySet(1000).load(file)) {
            this.put(p.key, p.value);
        }
        file = AbstractTranslationDictionary.validateExists("translation-regex-through.properties");
        Set throughSet = new PropertySet(100).load(file).keySet();
        this.throughPattern = Pattern.compile("(?s)(" + StringUtils.join(throughSet, "|") + ")");
    }

    public void put(String enPattern, String jaReplacement) {
        RegexEntry regexEntry = new RegexEntry();
        regexEntry.pattern = Pattern.compile("(?s)" + enPattern);
        regexEntry.replacement = jaReplacement;
        String firstChar = this.getFirstChar(enPattern);
        if (firstChar != null) {
            this.put(this.firstCharMap, firstChar, regexEntry);
        } else {
            String lastChar = this.getLastChar(enPattern);
            if (lastChar != null) {
                this.put(this.lastCharMap, lastChar, regexEntry);
            } else {
                this.otherList.add(regexEntry);
            }
        }
    }

    private void put(Map<String, List<RegexEntry>> regexListMap, String key, RegexEntry regexEntry) {
        List<RegexEntry> regexList = regexListMap.get(key);
        if (regexList == null) {
            regexList = new ArrayList<RegexEntry>();
            regexListMap.put(key, regexList);
        }
        regexList.add(regexEntry);
    }

    private String getFirstChar(String enPattern) {
        char c = enPattern.charAt(0);
        if (c == '(') {
            return null;
        }
        if (enPattern.startsWith("\\[")) {
            return "[";
        }
        return String.valueOf(c);
    }

    private String getLastChar(String enPattern) {
        char c = enPattern.charAt(enPattern.length() - 1);
        if (c == ')') {
            return null;
        }
        if (!enPattern.endsWith("\\]") && enPattern.endsWith("]")) {
            return null;
        }
        return String.valueOf(c);
    }

    public String lookup(String en) {
        if (en == null || en.isEmpty()) {
            return null;
        }
        String ja = this.replaceToJa(en, this.firstCharMap.get(en.substring(0, 1)));
        if (ja == null && (ja = this.replaceToJa(en, this.lastCharMap.get(en.substring(en.length() - 1)))) == null) {
            ja = this.replaceToJa(en, this.otherList);
        }
        if (ja != null) {
            return ja;
        }
        if (this.throughPattern.matcher(en).matches()) {
            return en;
        }
        return null;
    }

    private String replaceToJa(String en, List<RegexEntry> regexList) {
        if (regexList != null) {
            for (RegexEntry entry : regexList) {
                Matcher matcher = entry.pattern.matcher(en);
                try {
                    if (!matcher.matches()) continue;
                    return matcher.replaceFirst(entry.replacement);
                }
                catch (RuntimeException e) {
                    log.error(e, "\u6b63\u898f\u8868\u73fe\u7ffb\u8a33\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002en:" + en + ", pattern:" + entry.pattern, new Object[0]);
                    break;
                }
            }
        }
        return null;
    }

    public static void main(String[] args) {
        RegexDictionary instance = RegexDictionary.getInstance();
        PropertySet prop = new PropertySet("translation.properties");
        long s = System.currentTimeMillis();
        for (Property p : prop) {
            instance.lookup(p.key);
        }
        log.info("%.3f ms", (double)(System.currentTimeMillis() - s) / 1000.0);
    }

    private static class RegexEntry {
        public Pattern pattern;
        public String replacement;

        private RegexEntry() {
        }
    }
}

