/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.runtime.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;
import jp.sourceforge.mergedoc.pleiades.runtime.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.runtime.advice.PleiadesConfig;
import jp.sourceforge.mergedoc.pleiades.runtime.advice.PointCut;
import jp.sourceforge.mergedoc.pleiades.runtime.advice.TraceConfig;
import jp.sourceforge.mergedoc.pleiades.runtime.advice.TraceJointPoint;
import jp.sourceforge.mergedoc.pleiades.runtime.resource.ExcludePackageProperties;

public class CallHierarchyExplorer {
    private static final Logger log = Logger.getLogger(CallHierarchyExplorer.class);
    public static final int TRACE_MAX = 20;
    private static final CallHierarchyExplorer singleton = new CallHierarchyExplorer();
    private final ExcludePackageProperties excludePackageProperties = ExcludePackageProperties.getInstance();
    private final TraceConfig traceConfig;
    private final Map<JointPoint, AtomicInteger> callCountMap;

    public CallHierarchyExplorer() {
        this.traceConfig = PleiadesConfig.getInstance().traceConfig;
        this.callCountMap = new HashMap<JointPoint, AtomicInteger>();
    }

    public static CallHierarchyExplorer getInstance() {
        return singleton;
    }

    public boolean isExcludeTranslation(String en, JointPoint whereJP) {
        PointCut pointCut;
        StackTraceElement[] stes = null;
        List<String> noTransPathEntries = this.excludePackageProperties.getPathEntries(en);
        if (noTransPathEntries != null) {
            this.debugCalls(whereJP, stes);
            stes = this.getStackTrace();
            for (int i = 0; i < 20 && i < stes.length; ++i) {
                StackTraceElement ste = stes[i];
                String className = ste.getClassName();
                for (String noTransPath : noTransPathEntries) {
                    if (!className.startsWith(noTransPath)) continue;
                    return true;
                }
            }
        }
        if (this.traceConfig != null && this.traceConfig.disabled) {
            return false;
        }
        if (whereJP != null && (pointCut = PleiadesConfig.getInstance().getPointCut(whereJP)) != null) {
            List<TraceJointPoint> excludeTrace = pointCut.getExcludeTrace();
            List<TraceJointPoint> includeTrace = pointCut.getIncludeTrace();
            if (includeTrace.size() > 0) {
                this.debugCalls(whereJP, stes);
                if (this.containsTrace(includeTrace, stes, en)) {
                    return false;
                }
                if (excludeTrace.size() == 0) {
                    return true;
                }
            }
            if (excludeTrace.size() > 0) {
                this.debugCalls(whereJP, stes);
                if (this.containsTrace(excludeTrace, stes, en)) {
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean containsTrace(List<TraceJointPoint> traceDefList, StackTraceElement[] stacks, String en) {
        if (stacks == null) {
            stacks = this.getStackTrace();
        }
        for (TraceJointPoint def : traceDefList) {
            int traceMax = def.getLimit();
            for (int i = 0; i < traceMax && i < stacks.length; ++i) {
                StackTraceElement stack = stacks[i];
                if (!stack.getClassName().startsWith(def.getClassName())) continue;
                String methodName = def.getMethodName();
                if (methodName == null) {
                    return true;
                }
                String steMethodName = stack.getMethodName();
                if (Character.isUpperCase(methodName.charAt(0)) && steMethodName.equals("<init>")) {
                    return true;
                }
                if (!steMethodName.equals(methodName)) continue;
                return true;
            }
        }
        return false;
    }

    protected StackTraceElement[] getStackTrace() {
        return new Throwable().getStackTrace();
    }

    public String findTrace(PropertySet packageMap) {
        StackTraceElement[] stes = this.getStackTrace();
        for (String pkg : packageMap.keySet()) {
            if (pkg == null) continue;
            for (int i = 0; i < 20 && i < stes.length; ++i) {
                StackTraceElement ste = stes[i];
                if (!ste.getClassName().startsWith(pkg)) continue;
                return (String)packageMap.get(pkg);
            }
        }
        return (String)packageMap.get(null);
    }

    private void debugCalls(JointPoint jointPoint, StackTraceElement[] stes) {
        if (stes == null && log.isDebugEnabled()) {
            AtomicInteger i = this.callCountMap.get(jointPoint);
            if (i == null) {
                i = new AtomicInteger();
                this.callCountMap.put(jointPoint, i);
            }
            i.incrementAndGet();
        }
    }

    public void flushStackTraceCount() {
        if (!log.isDebugEnabled()) {
            return;
        }
        ArrayList<Map.Entry<JointPoint, AtomicInteger>> list = new ArrayList<Map.Entry<JointPoint, AtomicInteger>>(this.callCountMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<JointPoint, AtomicInteger>>(){

            @Override
            public int compare(Map.Entry<JointPoint, AtomicInteger> e1, Map.Entry<JointPoint, AtomicInteger> e2) {
                return e2.getValue().get() - e1.getValue().get();
            }
        });
        for (int i = 0; i < list.size() && i < 5; ++i) {
            Map.Entry<JointPoint, AtomicInteger> entry = list.get(i);
            JointPoint p = entry.getKey();
            int count = entry.getValue().get();
            if (p == null) {
                log.debug("getStackTrace() %4d \u56de\u547c\u51fa %%EXCLUDE%% \u306b\u3088\u308b\u30d1\u30c3\u30b1\u30fc\u30b8\u9664\u5916", count);
                continue;
            }
            log.debug("getStackTrace() %4d \u56de\u547c\u51fa %s %s %s", count, p.getClassName(), p.getMethodName(), p.getDescriptor());
        }
    }
}

