/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.runtime.advice;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.mergedoc.org.apache.commons.lang.StringUtils;
import jp.sourceforge.mergedoc.org.apache.commons.lang.builder.ToStringBuilder;
import jp.sourceforge.mergedoc.org.apache.commons.lang.builder.ToStringStyle;
import jp.sourceforge.mergedoc.pleiades.runtime.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.runtime.advice.TraceJointPoint;

public class PointCut {
    private Timing timing;
    private String advice;
    private String level;
    private JointPoint jointPoint;
    private List<JointPoint> excludeWheres;
    private List<JointPoint> includeWheres;
    private List<TraceJointPoint> excludeTrace;
    private List<TraceJointPoint> includeTrace;

    public PointCut() {
    }

    public PointCut(PointCut pointCut) {
        this.timing = pointCut.timing;
        this.advice = pointCut.advice;
    }

    public String getAdvice() {
        return "{" + this.advice + "}";
    }

    public void setAdvice(String advice) {
        this.advice = advice;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public Timing getTiming() {
        return this.timing;
    }

    public void setTiming(String timing) {
        try {
            this.timing = Timing.valueOf(timing.toUpperCase());
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(timing + " is illegal timing. " + StringUtils.join((Object[])Timing.values(), " or "));
        }
    }

    public JointPoint getJointPoint() {
        return this.jointPoint;
    }

    public void setJointPoint(JointPoint jointPoint) {
        this.jointPoint = jointPoint;
    }

    public List<JointPoint> getExcludeWheres() {
        if (this.excludeWheres == null) {
            this.excludeWheres = new ArrayList<JointPoint>();
        }
        return this.excludeWheres;
    }

    public List<JointPoint> getIncludeWheres() {
        if (this.includeWheres == null) {
            this.includeWheres = new ArrayList<JointPoint>();
        }
        return this.includeWheres;
    }

    public List<TraceJointPoint> getExcludeTrace() {
        if (this.excludeTrace == null) {
            this.excludeTrace = new ArrayList<TraceJointPoint>();
        }
        return this.excludeTrace;
    }

    public List<TraceJointPoint> getIncludeTrace() {
        if (this.includeTrace == null) {
            this.includeTrace = new ArrayList<TraceJointPoint>();
        }
        return this.includeTrace;
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("timing", (Object)this.timing).append("advice", this.getAdvice()).append("level", this.getLevel()).append("excludeWheres", this.excludeWheres).append("includeWheres", this.includeWheres).append("excludeTrace", this.excludeTrace).append("includeTrace", this.includeTrace).toString();
    }

    public static enum Timing {
        AROUND,
        BEFORE,
        AFTER;

    }
}

