/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.runtime;

import java.io.IOException;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.runtime.AbstractTransformer;
import jp.sourceforge.mergedoc.pleiades.runtime.Analyses;
import jp.sourceforge.mergedoc.pleiades.runtime.TranslationEditor;
import jp.sourceforge.mergedoc.pleiades.runtime.advice.PleiadesConfig;
import jp.sourceforge.mergedoc.pleiades.runtime.resource.ExcludeClassNameCache;
import jp.sourceforge.mergedoc.pleiades.runtime.resource.TransformedClassCache;

public class TranslationTransformer
extends AbstractTransformer {
    private static final Logger log = Logger.getLogger(TranslationTransformer.class);

    @Override
    protected boolean isClassPathTarget(String fullPath, String jarFileName) throws IOException, NotFoundException {
        if (jarFileName.startsWith("org.eclipse.")) {
            if (jarFileName.startsWith("org.eclipse.core.resources_") || jarFileName.startsWith("org.eclipse.core.runtime_") || jarFileName.startsWith("org.eclipse.debug.core_") || jarFileName.startsWith("org.eclipse.dltk.core_") || jarFileName.startsWith("org.eclipse.equinox.common_") || jarFileName.startsWith("org.eclipse.jdt.core_") || jarFileName.startsWith("org.eclipse.jdt.ui_") || jarFileName.startsWith("org.eclipse.jface_") || jarFileName.startsWith("org.eclipse.osgi_") || jarFileName.startsWith("org.eclipse.swt.") || jarFileName.startsWith("org.eclipse.ui.workbench_")) {
                return true;
            }
        } else if (jarFileName.startsWith("mergedoc.jstyle.swt") || jarFileName.startsWith("com.android.ide.eclipse.adt_") || jarFileName.equals("assetstudio.jar") || jarFileName.equals("sdklib.jar")) {
            log.debug("\u30af\u30e9\u30b9\u30d1\u30b9\u8ffd\u52a0 %s", fullPath);
            return true;
        }
        return false;
    }

    @Override
    protected byte[] transformBytecode(String classId, String className, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        ExcludeClassNameCache excludeClassCache = ExcludeClassNameCache.getInstance();
        if (excludeClassCache.contains(classId)) {
            return null;
        }
        TransformedClassCache classCache = TransformedClassCache.getInstance();
        byte[] cachedBytecode = classCache.get(classId);
        if (cachedBytecode != null) {
            return cachedBytecode;
        }
        PleiadesConfig config = PleiadesConfig.getInstance();
        if (config.isExcludePackage(className)) {
            excludeClassCache.addNextLaunch(classId);
            return null;
        }
        CtClass ctClass = this.createCtClass(bytecode);
        try {
            byte[] transformedBytecode = this.transformClass(ctClass);
            if (classCache.isActive()) {
                if (transformedBytecode == null) {
                    if (!classCache.contains(classId)) {
                        excludeClassCache.addNextLaunch(classId);
                    }
                } else {
                    classCache.putNextLaunch(classId, transformedBytecode);
                }
            }
            return transformedBytecode;
        }
        catch (CannotCompileException e) {
            excludeClassCache.addNextLaunch(classId);
            throw e;
        }
    }

    protected byte[] transformClass(CtClass ctClass) throws CannotCompileException, NotFoundException, IOException {
        long start = System.nanoTime();
        TranslationEditor editor = new TranslationEditor(ctClass);
        for (CtBehavior ctBehavior : ctClass.getDeclaredBehaviors()) {
            ctBehavior.instrument((ExprEditor)editor);
            editor.editBehavior(ctBehavior);
        }
        CtConstructor ctInitializer = ctClass.getClassInitializer();
        if (ctInitializer != null) {
            ctInitializer.instrument((ExprEditor)editor);
        }
        Analyses.end(TranslationTransformer.class, "transformClass", start);
        return editor.toBytecode();
    }

    protected static class LoggingDescTranslationTransformer
    extends TranslationTransformer {
        private final String logDescClassName;

        public LoggingDescTranslationTransformer(String logDescClassName) {
            this.logDescClassName = logDescClassName;
        }

        @Override
        protected CtClass createCtClass(byte[] bytecode) throws IOException, NotFoundException {
            CtClass ctClass = super.createCtClass(bytecode);
            if (ctClass.getName().startsWith(this.logDescClassName)) {
                this.logDescriptor(ctClass);
            }
            return ctClass;
        }
    }
}

