/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.runtime;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import jp.sourceforge.mergedoc.pleiades.Pleiades;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.PatternCache;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;
import jp.sourceforge.mergedoc.pleiades.runtime.Analyses;

public class Applications {
    private static File home;
    private static File osgiHome;
    private static File pleiadesConfigurationPath;
    private static String version;

    public static void init() throws IOException {
        File packageDir;
        File configIniFile = Applications.getConfigIniFile("configuration");
        pleiadesConfigurationPath = configIniFile != null ? Applications.getPleiadesConfigPath(configIniFile) : (Applications.isWritable(packageDir = Files.getPackageDirectory()) ? new File(packageDir, "cache") : Applications.getUserConfigPath(packageDir.getParentFile().getParentFile()));
        pleiadesConfigurationPath.mkdirs();
    }

    private static File getConfigIniFile(String configurationDir) {
        File eclipseDir;
        String CONFIG_INI = "config.ini";
        String configDirIni = String.valueOf(configurationDir) + "/" + "config.ini";
        File configIniFile = new File(System.getProperty("user.dir"), configDirIni);
        if (configIniFile.exists()) {
            return configIniFile;
        }
        File dir = eclipseDir = Files.getPackageDirectory().getParentFile().getParentFile();
        while (dir != null) {
            configIniFile = new File(dir, configDirIni);
            if (configIniFile.exists()) {
                return configIniFile;
            }
            dir = dir.getParentFile();
        }
        dir = eclipseDir;
        while (dir != null) {
            File[] fileArray = dir.listFiles(Files.createDirectoryFilter());
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File d = fileArray[n2];
                configIniFile = new File(d, "config.ini");
                if (configIniFile.exists()) {
                    return configIniFile;
                }
                ++n2;
            }
            dir = dir.getParentFile();
        }
        return null;
    }

    private static File getPleiadesConfigPath(File configIniFile) {
        File baseDir;
        String base;
        Matcher mat;
        File jarFile;
        File defaultConfigPath = configIniFile.getParentFile();
        home = defaultConfigPath.getParentFile();
        PropertySet configIni = new PropertySet(configIniFile);
        String osgiJarPath = (String)configIni.get("osgi.framework");
        if (osgiJarPath != null && (jarFile = new File(osgiJarPath.replace("file:", ""))).exists()) {
            osgiHome = jarFile.getParentFile().getParentFile();
        }
        if (osgiHome == null) {
            osgiHome = home;
        }
        String CONFIG_AREA_KEY = "osgi.configuration.area";
        String configArea = (String)configIni.get("osgi.configuration.area");
        if (configArea == null) {
            configArea = System.getProperty("osgi.configuration.area");
        }
        File userConfigPath = null;
        if (configArea != null && (mat = PatternCache.get("^@([\\w\\.]+)(.+)$").matcher(configArea)).find() && (base = System.getProperty(mat.group(1))) != null && (baseDir = new File(base)).exists()) {
            String childPath = mat.group(2);
            userConfigPath = new File(baseDir, childPath);
        }
        if (userConfigPath != null) {
            return new File(userConfigPath, Pleiades.PACKAGE_NAME);
        }
        File storePath = new File(defaultConfigPath, Pleiades.PACKAGE_NAME);
        storePath.mkdirs();
        if (Applications.isWritable(storePath)) {
            return storePath;
        }
        return Applications.getUserConfigPath(home);
    }

    private static boolean isWritable(File storePath) {
        File checkWritable = new File(storePath, ".check-writable");
        try {
            checkWritable.createNewFile();
            if (checkWritable.delete()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static File getUserConfigPath(File appDir) {
        File base = new File(System.getProperty("user.home"), ".pleiades");
        String appPath = appDir.getPath().replaceAll("[/:\\\\]+", "-").replaceFirst("^-+", "");
        return new File(base, appPath);
    }

    public static File getHome() {
        return home;
    }

    public static File getOsgiHome() {
        return osgiHome;
    }

    public static File getPleiadesConfigurationPath() {
        return pleiadesConfigurationPath;
    }

    public static synchronized String getVersion() {
        if (version != null) {
            return version;
        }
        version = "";
        if (osgiHome == null) {
            return version;
        }
        File featuresFolder = new File(osgiHome, "features");
        if (!featuresFolder.exists()) {
            return version;
        }
        File[] fileArray = featuresFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File folder = fileArray[n2];
            String folderName = folder.getName();
            if (folderName.startsWith("org.eclipse.platform_")) {
                version = folderName.replaceFirst(".*?_(\\d+\\.\\d+).*", "$1");
                break;
            }
            ++n2;
        }
        return version;
    }

    public static boolean isUpdated(File ... targetDirs) throws IOException {
        long prevLastModified;
        if (targetDirs.length == 0) {
            throw new IllegalStateException("\u30bf\u30fc\u30b2\u30c3\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        long start = System.nanoTime();
        File pluginModifiedFile = new File(pleiadesConfigurationPath, ".plugin-modified");
        long lastModified = prevLastModified = pluginModifiedFile.lastModified();
        File[] fileArray = targetDirs;
        int n = targetDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            lastModified = Applications.getLastModified(dir, lastModified);
            ++n2;
        }
        lastModified = Applications.getLastModified(Files.conf(), lastModified);
        Logger log = Logger.getLogger(Applications.class);
        log.info("\u30d5\u30a1\u30a4\u30eb\u66f4\u65b0\u6700\u7d42\u6642\u523b (\u524d\u56de): %1$tF %1$tT", prevLastModified);
        log.info("\u30d5\u30a1\u30a4\u30eb\u66f4\u65b0\u6700\u7d42\u6642\u523b (\u4eca\u56de): %1$tF %1$tT", lastModified);
        boolean isUpdated = false;
        if (lastModified > prevLastModified) {
            pluginModifiedFile.createNewFile();
            pluginModifiedFile.setLastModified(lastModified);
            isUpdated = true;
        }
        Analyses.end(Applications.class, "isPluginUpdated", start);
        return isUpdated;
    }

    private static long getLastModified(File parentDir, long latest) {
        if (!parentDir.exists()) {
            return latest;
        }
        String parentName = parentDir.getName();
        if (parentName.equals("features")) {
            return latest;
        }
        File[] fileArray = parentDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                latest = Applications.max(file, latest);
            } else {
                File dir = file;
                latest = parentName.equals("plugins") || parentName.equals("lib") ? Applications.max(dir, latest) : Applications.getLastModified(dir, latest);
            }
            ++n2;
        }
        return latest;
    }

    private static long max(File file, long latest) {
        long modified = file.lastModified();
        if (modified > latest) {
            latest = modified;
            Logger log = Logger.getLogger(Applications.class);
            log.info("\u30d5\u30a1\u30a4\u30eb\u66f4\u65b0\u691c\u51fa: %1$tF %1$tT %2$s", latest, file.getPath());
        }
        return latest;
    }
}

