/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jp.sourceforge.mergedoc.pleiades.Pleiades;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

public class Analyses {
    private static final Logger log;
    private static final Map<String, CallsTime> callsTimeMap;

    static {
        if (System.getProperty("pleiades.logger.class.name") == null) {
            String m = "\u307e\u3060 Logger \u304c\u660e\u793a\u7684\u306b\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            System.err.println(m);
            throw new IllegalStateException(m);
        }
        log = Logger.getLogger(Analyses.class);
        callsTimeMap = new ConcurrentHashMap<String, CallsTime>();
    }

    private Analyses() {
    }

    public static void flashLog(String message, Object ... args) {
        log.info(message, args);
        if (!log.isDebugEnabled()) {
            return;
        }
        ArrayList<CallsTime> values = new ArrayList<CallsTime>(callsTimeMap.values());
        callsTimeMap.clear();
        Collections.sort(values);
        String format = "%8d \u56de\u547c\u51fa\u8a08 %6.3f \u79d2 %s";
        int MAX_OUT = 50;
        int i = 0;
        while (i < values.size() && i < 50) {
            String name;
            CallsTime ct = (CallsTime)values.get(i);
            if (ct.calls != 0L && !(name = ct.jointPoint).startsWith(Analyses.class.getName())) {
                name = name.replace(String.valueOf(Pleiades.PACKAGE_NAME) + ".", "");
                log.debug("%8d \u56de\u547c\u51fa\u8a08 %6.3f \u79d2 %s", ct.calls, (double)ct.cumulativeTime / 1.0E9, name);
            }
            ++i;
        }
    }

    public static void start(String classMethodName) {
        if (!log.isDebugEnabled()) {
            return;
        }
        CallsTime callsTime = callsTimeMap.get(classMethodName);
        if (callsTime == null) {
            callsTime = new CallsTime(classMethodName);
            callsTimeMap.put(classMethodName, callsTime);
        }
        callsTime.lastStartNanoTime = System.nanoTime();
    }

    public static void end(String classMethodName) {
        if (!log.isDebugEnabled()) {
            return;
        }
        CallsTime callsTime = callsTimeMap.get(classMethodName);
        if (callsTime == null) {
            return;
        }
        callsTime.cumulativeTime += System.nanoTime() - callsTime.lastStartNanoTime;
        ++callsTime.calls;
    }

    public static void end(Class<?> clazz, String methodName, long startNanoTime) {
        String manualName;
        CallsTime callsTime;
        if (!log.isDebugEnabled()) {
            return;
        }
        String classMethodName = String.valueOf(clazz.getName()) + "#" + methodName;
        if (callsTimeMap.keySet().contains(classMethodName)) {
            log.debug("AOP \u3067\u3059\u3067\u306b\u8a08\u6e2c\u51e6\u7406\u304c\u57cb\u3081\u8fbc\u307e\u308c\u3066\u3044\u307e\u3059\u3002\u660e\u793a\u7684\u306a\u30b3\u30fc\u30c9\u306f\u4e0d\u8981\u3067\u3059\u3002%s", classMethodName);
        }
        if ((callsTime = callsTimeMap.get(manualName = String.valueOf(classMethodName) + " [MANUAL]")) == null) {
            callsTime = new CallsTime(manualName);
            callsTimeMap.put(manualName, callsTime);
        }
        callsTime.cumulativeTime += System.nanoTime() - startNanoTime;
        ++callsTime.calls;
    }

    private static class CallsTime
    implements Comparable<CallsTime> {
        final String jointPoint;
        volatile long calls;
        volatile long cumulativeTime;
        volatile long lastStartNanoTime;

        CallsTime(String jointPoint) {
            this.jointPoint = jointPoint;
        }

        @Override
        public int compareTo(CallsTime o) {
            return o.cumulativeTime > this.cumulativeTime ? 1 : -1;
        }
    }
}

