/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import jp.sourceforge.mergedoc.org.apache.commons.io.IOUtils;
import jp.sourceforge.mergedoc.org.apache.commons.lang.StringUtils;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.Property;

public class PropertySet
extends HashMap<String, String>
implements Iterable<Property> {
    private final Logger log = Logger.getLogger(this.getClass());
    private static final String PROP_EXTENSION = ".properties";
    protected static final String ZIP_EXTENSION = ".zip";
    private int loadCount;

    public PropertySet() {
    }

    public PropertySet(int initialCapacity) {
        super(initialCapacity);
    }

    public PropertySet(String ... paths) {
        this.load(paths);
    }

    public PropertySet(File ... files) {
        this.load(files);
    }

    public PropertySet(Properties ... props) {
        for (Properties prop : props) {
            for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                this.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public PropertySet(PropertySet ... props) {
        for (PropertySet prop : props) {
            this.putAll(prop);
        }
    }

    public PropertySet load(String ... paths) {
        for (String path : paths) {
            File file = Files.conf(path);
            this.load(file);
        }
        return this;
    }

    public PropertySet load(File ... files) {
        for (File file : files) {
            if (file.isDirectory()) {
                for (File f : PropertySet.listPropertiesFiles(file)) {
                    this.loadFile(f);
                }
                continue;
            }
            this.loadFile(file);
        }
        return this;
    }

    public static File[] listPropertiesFiles(File dir) {
        Object[] fs = dir.listFiles(Files.createFileFilter());
        Arrays.sort(fs);
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object f : fs) {
            String name = ((File)f).getName();
            if (!name.endsWith(PROP_EXTENSION) && !name.endsWith(".properties.zip")) continue;
            list.add(f);
        }
        return list.toArray(new File[list.size()]);
    }

    public void load(InputStream is) {
        try {
            this.loadUTF8(is);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void loadRecursive(File ... dirs) {
        for (File dir : dirs) {
            Object[] fs = dir.listFiles();
            Arrays.sort(fs);
            for (Object f : fs) {
                if (((File)f).isDirectory()) {
                    this.loadRecursive(new File[]{f});
                    continue;
                }
                this.load(new File[]{f});
            }
        }
    }

    public String put(Property p) {
        return this.put(p.key, p.value);
    }

    public List<String> store(String path, String comment) {
        File resourceFile = Files.conf(path);
        return this.store(resourceFile, comment);
    }

    public List<String> store(File file, String comment) {
        List<String> list;
        long startTime = System.nanoTime();
        String fileName = file.getName();
        if (file.exists() && fileName.endsWith(PROP_EXTENSION)) {
            PropertySet old = new PropertySet();
            old.loadFileWithoutLog(file);
            if (old.equals(this)) {
                this.log.info("store \u66f4\u65b0\u306a\u3057   %6d \u30a8\u30f3\u30c8\u30ea\u30fc %-34s", this.size(), fileName);
                return null;
            }
        }
        ArrayList<String> headerList = new ArrayList<String>();
        headerList.add(this.saveConvertComment("\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u306f Pleiades \u306b\u3088\u308a\u751f\u6210\u3055\u308c\u307e\u3057\u305f\u3002" + this.size() + " \u30a8\u30f3\u30c8\u30ea\u30fc\u3002"));
        headerList.add("####################################################################################################");
        headerList.add("# ");
        for (String s : comment.split("\\n")) {
            headerList.add("# " + this.saveConvertComment(s));
        }
        headerList.add("# ");
        headerList.add("####################################################################################################");
        String header = StringUtils.join(headerList, "\n");
        FilterOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(file));
            if (fileName.endsWith(".properties.zip")) {
                ZipOutputStream zos = new ZipOutputStream(os);
                zos.setLevel(1);
                zos.putNextEntry(new ZipEntry(fileName.replace(ZIP_EXTENSION, "")));
                os = zos;
            }
            List<String> keyList = this.store(os, header);
            this.log.info("store %4.3f \u79d2 - %6d \u30a8\u30f3\u30c8\u30ea\u30fc %s", (double)(System.nanoTime() - startTime) / 1.0E9, this.size(), fileName);
            list = keyList;
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException(file.toString(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(os);
        return list;
    }

    @Override
    public Iterator<Property> iterator() {
        final Iterator it = this.entrySet().iterator();
        return new Iterator<Property>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Property next() {
                Map.Entry entry = (Map.Entry)it.next();
                return new Property((String)entry.getKey(), (String)entry.getValue());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        for (Map.Entry<? extends String, ? extends String> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    protected InputStream getInputStream(File file) throws IOException {
        FilterInputStream is = new BufferedInputStream(new FileInputStream(file));
        if (file.getName().endsWith(".properties.zip")) {
            ZipInputStream zis = new ZipInputStream(is);
            zis.getNextEntry();
            is = zis;
        }
        return is;
    }

    private void loadFile(File file) {
        long startTime = System.nanoTime();
        this.loadFileWithoutLog(file);
        this.log.info("load  %4.3f \u79d2 - %6d \u30a8\u30f3\u30c8\u30ea\u30fc %s", (double)(System.nanoTime() - startTime) / 1.0E9, this.loadCount, file.getName());
        this.loadCount = 0;
    }

    private void loadFileWithoutLog(File file) {
        InputStream is = null;
        try {
            is = this.getInputStream(file);
            if (is == null) {
                return;
            }
            this.loadUTF8(is);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    private void loadUTF8(InputStream is) throws IOException {
        this.load0(new LineReader(new InputStreamReader(is, "UTF-8")));
    }

    private void load0(LineReader lr) throws IOException {
        int limit;
        char[] convtBuf = new char[1024];
        while ((limit = lr.readLine()) >= 0) {
            int keyLen;
            char c = '\u0000';
            int valueStart = limit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            for (keyLen = 0; keyLen < limit; ++keyLen) {
                c = lr.lineBuf[keyLen];
                if (!(c != '=' && c != ':' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
            }
            while (valueStart < limit) {
                c = lr.lineBuf[valueStart];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (hasSep || c != '=' && c != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            String key = this.loadConvert(lr.lineBuf, 0, keyLen, convtBuf);
            String value = this.loadConvert(lr.lineBuf, valueStart, limit - valueStart, convtBuf);
            this.put(key, value);
            ++this.loadCount;
        }
    }

    private List<String> store(OutputStream out, String comments) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
        if (comments != null) {
            PropertySet.writeln(writer, "#" + comments);
        }
        PropertySet.writeln(writer, "#" + new Date().toString());
        HashMap c = null;
        try {
            c = (HashMap)this.clone();
        }
        catch (ConcurrentModificationException e) {
            this.log.info("\u975e\u540c\u671f\u5909\u66f4\u306b\u3088\u308a\u4fdd\u7ba1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u30ea\u30c8\u30e9\u30a4\u3057\u307e\u3059\u3002", new Object[0]);
            try {
                c = (HashMap)this.clone();
            }
            catch (ConcurrentModificationException e2) {
                this.log.warn("\u975e\u540c\u671f\u5909\u66f4\u306b\u3088\u308a\u4fdd\u7ba1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002", new Object[0]);
                return null;
            }
        }
        ArrayList<String> keyList = new ArrayList<String>(c.keySet());
        Collections.sort(keyList, String.CASE_INSENSITIVE_ORDER);
        for (String key : keyList) {
            String val = (String)this.get(key);
            key = this.saveConvert(key, true);
            val = this.saveConvert(val, false);
            PropertySet.writeln(writer, key + "=" + val);
        }
        writer.flush();
        return keyList;
    }

    private String loadConvert(char[] in, int off, int len, char[] convtBuf) {
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    private String saveConvertComment(String theString) {
        String space = theString.replaceFirst("(\\s*).*", "$1");
        return space + this.saveConvert(theString.trim(), false);
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    class LineReader {
        byte[] inByteBuf;
        char[] inCharBuf;
        char[] lineBuf = new char[1024];
        int inLimit = 0;
        int inOff = 0;
        Reader reader;

        public LineReader(Reader reader) {
            this.reader = reader;
            this.inCharBuf = new char[8192];
        }

        int readLine() throws IOException {
            int len = 0;
            char c = '\u0000';
            boolean skipWhiteSpace = true;
            boolean isCommentLine = false;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean skipLF = false;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.reader.read(this.inCharBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (len == 0 || isCommentLine) {
                            return -1;
                        }
                        return len;
                    }
                }
                c = this.inCharBuf[this.inOff++];
                if (skipLF) {
                    skipLF = false;
                    if (c == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (c == ' ' || c == '\t' || c == '\f' || !appendedLineBegin && (c == '\r' || c == '\n')) continue;
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (isNewLine) {
                    isNewLine = false;
                    if (c == '#' || c == '!') {
                        isCommentLine = true;
                        continue;
                    }
                }
                if (c != '\n' && c != '\r') {
                    this.lineBuf[len++] = c;
                    if (len == this.lineBuf.length) {
                        int newLength = this.lineBuf.length * 2;
                        if (newLength < 0) {
                            newLength = Integer.MAX_VALUE;
                        }
                        char[] buf = new char[newLength];
                        System.arraycopy(this.lineBuf, 0, buf, 0, this.lineBuf.length);
                        this.lineBuf = buf;
                    }
                    if (c == '\\') {
                        precedingBackslash = !precedingBackslash;
                        continue;
                    }
                    precedingBackslash = false;
                    continue;
                }
                if (isCommentLine || len == 0) {
                    isCommentLine = false;
                    isNewLine = true;
                    skipWhiteSpace = true;
                    len = 0;
                    continue;
                }
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.reader.read(this.inCharBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        return len;
                    }
                }
                if (!precedingBackslash) break;
                --len;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (c != '\r') continue;
                skipLF = true;
            }
            return len;
        }
    }
}

