/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

public class Mnemonics {
    public static final String MNEMONIC_CHARS = "[\\w\\.@]";

    private Mnemonics() {
    }

    public static String removeJa(String ja) {
        if (Mnemonics.hasJa(ja)) {
            ja = ja.replaceFirst("\\(\\&[\\w\\.@]\\)", "");
            ja = ja.replaceFirst("\\(\\&\\)", "");
        }
        return ja;
    }

    public static String removeEn(String en) {
        if (Mnemonics.hasEn(en)) {
            return en.replaceFirst("\\&([\\w\\.@])", "$1");
        }
        return en;
    }

    public static boolean hasJa(String value) {
        return value.contains("(&") && value.matches("(?s)^.*?\\(\\&[\\w\\.@]\\).*$");
    }

    public static boolean hasEn(String value) {
        boolean mayMnemo = false;
        char[] chars = value.toCharArray();
        for (int i = 1; i < chars.length; ++i) {
            char c = chars[i - 1];
            char next = chars[i];
            if (c != '&' || next == ' ' || next == '&' || Character.isDigit(next)) continue;
            mayMnemo = true;
        }
        if (!mayMnemo) {
            return false;
        }
        if (chars.length >= 3 && chars[0] == '&' && chars[2] == '.') {
            return false;
        }
        return !value.contains("K&R") && !Mnemonics.containsHtmlReference(value) && !Mnemonics.containsUrlParameters(value);
    }

    public static boolean containsHtmlReference(String value) {
        if (!value.contains(";")) {
            return false;
        }
        return value.matches("(?si).*&[a-z:$\\.]+;.*");
    }

    public static boolean containsUrlParameters(String value) {
        return !value.contains("? ") && !value.contains("?=") && value.contains("?") && value.contains("=") && value.contains("&");
    }

    public static String convertEnToJa(String enWithMnemonic, String en, String ja) {
        if (enWithMnemonic.length() == en.length()) {
            return ja;
        }
        if (ja.contains("&") && !ja.contains("&&")) {
            return ja;
        }
        String mnemonicChar = enWithMnemonic.replaceFirst("(?s)^.*?\\&([\\w\\.@]).*$", "$1");
        if (mnemonicChar.length() != 1) {
            StringBuilder sb = new StringBuilder();
            sb.append("Mnemonic invalid length:" + mnemonicChar.length());
            sb.append(", enValue:" + enWithMnemonic);
            sb.append(", enValueNonMnemonic:" + en);
            sb.append(", mnemonicChar:" + mnemonicChar);
            throw new IllegalArgumentException(sb.toString());
        }
        String mnemonicJa = "(&" + mnemonicChar.toUpperCase() + ")";
        String jaWithMnemonic = null;
        jaWithMnemonic = ja.contains("/@") ? ja + mnemonicJa : ja.replaceFirst("(?s)^('.+?|.+?)((\\s*\\.{3,4}|)@\\p{ASCII}+|\\s*'[^']+'\\s*|\\.{3,4}(</a>|)\\s*|\\s*|:\\s*|:\\s+\\{[0-9]\\}\\s*|(:|)\\s+\\(.+\\)\\s*|\\s+(-*|)>+\\s*)$", "$1" + mnemonicJa + "$2");
        return jaWithMnemonic;
    }
}

