/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.generator;

import jp.sourceforge.mergedoc.pleiades.generator.TranslationRule;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;
import junit.framework.TestCase;

public class TranslationRuleTest
extends TestCase {
    private TranslationRule rule = new TranslationRule(new PropertySet[0]);

    private PropertySet apply(PropertySet inProp) {
        for (Property p : inProp) {
            System.out.println(p);
        }
        PropertySet outProp = this.rule.apply(inProp);
        for (Property p : outProp) {
            System.out.println(p);
        }
        System.out.println();
        return outProp;
    }

    public void testApply() {
        PropertySet inProp = new PropertySet();
        inProp.put("abcde. xyz.  ", "\u3042\u3044\u3046\u3048\u304a\u3002\u3093\u3093\u3093\u3002 ");
        PropertySet outProp = this.apply(inProp);
        TranslationRuleTest.assertEquals((String)"\u3042\u3044\u3046\u3048\u304a\u3002", (String)((String)outProp.get("abcde.")));
        TranslationRuleTest.assertEquals((String)"\u3093\u3093\u3093\u3002", (String)((String)outProp.get("xyz.")));
        inProp = new PropertySet();
        inProp.put("Dynamic Languages Toolkit - Core Frameworks", "\u52d5\u7684\u8a00\u8a9e\u30c4\u30fc\u30eb\u30ad\u30c3\u30c8 - \u30b3\u30a2\u30fb\u30d5\u30ec\u30fc\u30e0\u30ef\u30fc\u30af");
        outProp = this.apply(inProp);
        TranslationRuleTest.assertEquals((String)"\u52d5\u7684\u8a00\u8a9e\u30c4\u30fc\u30eb\u30ad\u30c3\u30c8", (String)((String)outProp.get("Dynamic Languages Toolkit")));
        TranslationRuleTest.assertEquals((String)"\u30b3\u30a2\u30fb\u30d5\u30ec\u30fc\u30e0\u30ef\u30fc\u30af", (String)((String)outProp.get("Core Frameworks")));
        inProp = new PropertySet();
        inProp.put("{0} must be public. (EJB 1.1: 9.2.3).", "{0} \u306f public \u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002(EJB 1.1: 9.2.3)\u3002");
        outProp = this.apply(inProp);
        TranslationRuleTest.assertEquals((String)"{0} \u306f public \u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002", (String)((String)outProp.get("{0} must be public.")));
        inProp = new PropertySet();
        inProp.put("CHKJ2412I: The return type must be serializable at runtime.  (EJB 1.1: 6.10) (RMI 1.3: 2.6).", "CHKJ2412I: \u623b\u308a\u306e\u578b\u306f\u5b9f\u884c\u6642\u306b\u30b7\u30ea\u30a2\u30e9\u30a4\u30ba\u53ef\u80fd\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002 (EJB 1.1: 6.10) (RMI 1.3: 2.6)\u3002");
        outProp = this.apply(inProp);
        TranslationRuleTest.assertEquals((int)1, (int)outProp.size());
        TranslationRuleTest.assertEquals((String)"\u623b\u308a\u306e\u578b\u306f\u5b9f\u884c\u6642\u306b\u30b7\u30ea\u30a2\u30e9\u30a4\u30ba\u53ef\u80fd\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002", (String)((String)outProp.get("The return type must be serializable at runtime.")));
        inProp = new PropertySet();
        inProp.put("CHKJ2408E: {0} must be public. (EJB 1.1: 9.2.4, 9.2.5)", "CHKJ2408E: {0} \u306f public \u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002 (EJB 1.1: 9.2.4\u30019.2.5)");
        outProp = this.apply(inProp);
        TranslationRuleTest.assertEquals((int)2, (int)outProp.size());
        TranslationRuleTest.assertEquals((String)"{0} \u306f public \u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002", (String)((String)outProp.get("{0} must be public.")));
        TranslationRuleTest.assertEquals((String)"EJB 1.1: 9.2.4\u30019.2.5", (String)((String)outProp.get("EJB 1.1: 9.2.4, 9.2.5")));
        inProp = new PropertySet();
        inProp.put("CHKJ2408E: {0} must be public. (EJB 1.1: 9.2.4, 9.2.5).", "CHKJ2408E: {0} \u306f public \u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002 (EJB 1.1: 9.2.4\u30019.2.5)\u3002");
        outProp = this.apply(inProp);
        TranslationRuleTest.assertEquals((int)2, (int)outProp.size());
        TranslationRuleTest.assertEquals((String)"{0} \u306f public \u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002", (String)((String)outProp.get("{0} must be public.")));
        TranslationRuleTest.assertEquals((String)"EJB 1.1: 9.2.4\u30019.2.5", (String)((String)outProp.get("EJB 1.1: 9.2.4, 9.2.5")));
        inProp = new PropertySet();
        inProp.put("Full user name (first and last):", "\u5b8c\u5168\u30e6\u30fc\u30b6\u30fc\u540d (\u59d3\u540d):");
        outProp = this.apply(inProp);
        TranslationRuleTest.assertEquals((int)2, (int)outProp.size());
        TranslationRuleTest.assertEquals((String)"\u5b8c\u5168\u30e6\u30fc\u30b6\u30fc\u540d", (String)((String)outProp.get("Full user name")));
        TranslationRuleTest.assertEquals((String)"(\u59d3\u540d):", (String)((String)outProp.get("(first and last):")));
        inProp = new PropertySet();
        inProp.put("K&R [built-in]", "K&R [\u30d3\u30eb\u30c8\u30a4\u30f3]");
        outProp = this.apply(inProp);
        TranslationRuleTest.assertEquals(null, (String)((String)outProp.get("K&R")));
        TranslationRuleTest.assertEquals((String)"\u30d3\u30eb\u30c8\u30a4\u30f3", (String)((String)outProp.get("built-in")));
        inProp = new PropertySet();
        inProp.put("Returns the percentage rank of a value.Return value is in the range [0..1]", "\u5024\u306e\u5272\u5408 (%) \u306e\u9806\u5e8f\u3092\u8fd4\u3057\u307e\u3059\u3002\u623b\u308a\u5024\u306f\u7bc4\u56f2 [0..1] \u3067\u3059");
        outProp = this.apply(inProp);
        TranslationRuleTest.assertEquals((int)1, (int)outProp.size());
        inProp = new PropertySet();
        inProp.put("IWAE0005E IWAJ0131I Cannot add the feature to the key because the feature is null for the command:", "IWAE0005E IWAJ0131I \u306f\u30b3\u30de\u30f3\u30c9\u306e\u30d5\u30a3\u30fc\u30c1\u30e3\u30fc\u304c null \u3067\u3042\u308b\u305f\u3081\u3001\u30ad\u30fc\u306b\u30d5\u30a3\u30fc\u30c1\u30e3\u30fc\u3092\u8ffd\u52a0\u3067\u304d\u307e\u305b\u3093 :");
        outProp = this.apply(inProp);
        TranslationRuleTest.assertEquals((String)"IWAJ0131I \u306f\u30b3\u30de\u30f3\u30c9\u306e\u30d5\u30a3\u30fc\u30c1\u30e3\u30fc\u304c null \u3067\u3042\u308b\u305f\u3081\u3001\u30ad\u30fc\u306b\u30d5\u30a3\u30fc\u30c1\u30e3\u30fc\u3092\u8ffd\u52a0\u3067\u304d\u307e\u305b\u3093:", (String)((String)outProp.get("IWAJ0131I Cannot add the feature to the key because the feature is null for the command:")));
        inProp = new PropertySet();
        inProp.put("x.", "DOM AST Javadoc \u30ce\u30fc\u30c9\u306f\u3001\u69cb\u9020\u4f53\u30bf\u30b0\u30fb\u30a8\u30ec\u30e1\u30f3\u30c8\u3092\u6301\u305f\u305a\u306b\u3001\u5358\u306a\u308b\u30d5\u30e9\u30c3\u30c8\u30fb\u30c6\u30ad\u30b9\u30c8\u306b\u306a\u308a\u307e\u3059\u3002");
        outProp = this.apply(inProp);
        TranslationRuleTest.assertEquals((String)"DOM AST Javadoc \u30ce\u30fc\u30c9\u306f\u3001\u69cb\u9020\u4f53\u30bf\u30b0\u8981\u7d20\u3092\u6301\u305f\u305a\u306b\u3001\u5358\u306a\u308b\u30d5\u30e9\u30c3\u30c8\u30fb\u30c6\u30ad\u30b9\u30c8\u306b\u306a\u308a\u307e\u3059\u3002", (String)((String)outProp.get("x.")));
        inProp = new PropertySet();
        inProp.put("x.", "\u81ea\u52d5\u30bf\u30b9\u30af\u30fb\u30bf\u30b0\u3068\u5e73\u884c\u3057\u3066\u3001\n\u3053\u306e\u30ea\u30b9\u30c8\u306f\u3001 \u30b3\u30f3\u30d1\u30a4\u30e9\u30fc\u306b\u3088\u3063\u3066\u51fa\u3055\u308c\u308b\u30bf\u30b9\u30af\u30fb\u30de\u30fc\u30ab\u30fc\u306e\u512a\u5148\u9806\u4f4d (\u9ad8\u3001\u4e2d\u3001\u4f4e) \u3092\u5b9a\u7fa9\u3057\u307e\u3059\u3002 ");
        outProp = this.apply(inProp);
        TranslationRuleTest.assertEquals((String)"\u81ea\u52d5\u30bf\u30b9\u30af\u30fb\u30bf\u30b0\u3068\u5e73\u884c\u3057\u3066\u3001\n\u3053\u306e\u30ea\u30b9\u30c8\u306f\u3001 \u30b3\u30f3\u30d1\u30a4\u30e9\u30fc\u306b\u3088\u3063\u3066\u51fa\u3055\u308c\u308b\u30bf\u30b9\u30af\u30fb\u30de\u30fc\u30ab\u30fc\u306e\u512a\u5148\u5ea6 (\u9ad8\u3001\u4e2d\u3001\u4f4e) \u3092\u5b9a\u7fa9\u3057\u307e\u3059\u3002", (String)((String)outProp.get("x.")));
        inProp = new PropertySet();
        inProp.put("Create a project for an existing web application.\nSelect the directory that contains the project files, and enter the project name.", "\u65e2\u5b58\u306e web \u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306e\u305f\u3081\u306e\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002\n\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u30fb\u30d5\u30a1\u30a4\u30eb\u3092\u542b\u3080\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u9078\u629e\u3057\u3001\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u540d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        outProp = this.apply(inProp);
        TranslationRuleTest.assertEquals((String)"\u65e2\u5b58\u306e web \u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306e\u305f\u3081\u306e\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002\n\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u30fb\u30d5\u30a1\u30a4\u30eb\u3092\u542b\u3080\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u30fc\u3092\u9078\u629e\u3057\u3001\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u540d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002", (String)((String)outProp.get("Create a project for an existing web application.\nSelect the directory that contains the project files, and enter the project name.")));
        inProp = new PropertySet();
        inProp.put("<details unavailable - not supported by VM>", "<\u8a73\u7d30\u306f\u4f7f\u7528\u4e0d\u53ef - VM \u306b\u3088\u3063\u3066\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093>");
        outProp = this.apply(inProp);
        TranslationRuleTest.assertEquals((String)"\u8a73\u7d30\u306f\u4f7f\u7528\u4e0d\u53ef", (String)((String)outProp.get("details unavailable")));
        TranslationRuleTest.assertEquals((String)"VM \u306b\u3088\u3063\u3066\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093", (String)((String)outProp.get("not supported by VM")));
    }
}

