/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.mergedoc.pleiades.generator.AbstractValidator;
import jp.sourceforge.mergedoc.pleiades.generator.Validator;
import jp.sourceforge.mergedoc.pleiades.log.FileLogger;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.Mnemonics;
import jp.sourceforge.mergedoc.pleiades.resource.PatternCache;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationProperty;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationString;

public class TranslationRule
extends AbstractValidator {
    protected final Logger splitLog;

    public TranslationRule(PropertySet ... existsProps) {
        super(existsProps);
        this.splitLog = this.validationLog;
    }

    public TranslationRule(String logFileName, PropertySet ... existsProps) {
        super(logFileName, existsProps);
        String splitLogName = this.validationLogFileName.replace(".log", "_split.log");
        this.splitLog = Logger.getLogger("Split", FileLogger.class, Logger.Level.INFO, Files.conf(splitLogName));
    }

    @Override
    protected Logger.Level getLogFileLogLevel() {
        return Logger.Level.INFO;
    }

    public PropertySet apply(PropertySet inProp) {
        List<TranslationProperty> splitTpList = this.split(inProp);
        this.log.info("\u7ffb\u8a33\u30eb\u30fc\u30eb\u9069\u7528\u4e2d...", new Object[0]);
        PropertySet outProp = new PropertySet();
        for (TranslationProperty tp : splitTpList) {
            this.applyEntry(tp, outProp);
        }
        this.log.info("%6d \u30a8\u30f3\u30c8\u30ea\u30fc (\u9069\u7528\u5f8c), %6d \u30a8\u30f3\u30c8\u30ea\u30fc\u9664\u53bb", outProp.size(), splitTpList.size() - outProp.size());
        return outProp;
    }

    protected List<TranslationProperty> split(PropertySet inProp) {
        this.log.info("\u53e5\u70b9\u89e3\u6790\u5206\u5272\u4e2d...", new Object[0]);
        this.log.info("%6d \u30a8\u30f3\u30c8\u30ea\u30fc (\u5206\u5272\u524d)", inProp.size());
        ArrayList<TranslationProperty> splitTpList = new ArrayList<TranslationProperty>();
        ArrayList<TranslationProperty> noSplitTpList = new ArrayList<TranslationProperty>();
        for (Property p : inProp) {
            AbstractValidator.ValidationContext vc = new AbstractValidator.ValidationContext(p.key, p.value, null);
            TranslationProperty tp = new TranslationProperty(p);
            List<TranslationString> enList = tp.en.split();
            List<TranslationString> jaList = tp.ja.split();
            if (enList == null || jaList == null || enList.size() != jaList.size()) {
                noSplitTpList.add(tp);
                continue;
            }
            ArrayList<TranslationProperty> splitTempTpList = new ArrayList<TranslationProperty>();
            for (int i = 0; i < enList.size(); ++i) {
                String j;
                TranslationString eTs = enList.get(i);
                TranslationString jTs = jaList.get(i);
                String e = eTs.toString();
                Property iProp = this.getIllegalTranslationProperty(e, j = jTs.toString());
                if (iProp != null) {
                    vc.warn("\u53e5\u70b9\u89e3\u6790\u5206\u5272\u4e0d\u53ef\u3002\u300c" + iProp.key + "\u300d\u306f\u300c" + iProp.value + "\u300d\u3068\u5bfe\u5fdc\u3057\u3066\u3044\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002\n" + Property.toString(e, j));
                    break;
                }
                String iParam = this.getIllegalBindParameter(e, j);
                if (iParam != null) {
                    vc.warn("\u53e5\u70b9\u89e3\u6790\u5206\u5272\u4e0d\u53ef\u3002\u8a33\u6587\u306b\u542b\u307e\u308c\u308b " + iParam + " \u304c\u539f\u6587\u306b\u3042\u308a\u307e\u305b\u3093\u3002\n" + Property.toString(e, j));
                    break;
                }
                if (e.contains("<") || j.contains("<")) {
                    boolean jTag;
                    String eTrim = eTs.trim();
                    String jTrim = jTs.trim();
                    String BLOCK_TAGS = "(?is).*<(div|p|ul|ol|dl|li|dd|h[1-5]|table|t[rdh]|html|body).*";
                    boolean eTag = eTrim.matches(BLOCK_TAGS);
                    if (eTag != (jTag = jTrim.matches(BLOCK_TAGS))) {
                        vc.warn("\u5206\u5272\u5f8c\u306e\u30bf\u30b0\u5bfe\u5fdc\u4e0d\u6b63 " + Property.toString(eTrim, jTrim));
                        break;
                    }
                }
                splitTempTpList.add(new TranslationProperty(eTs, jTs));
            }
            if (vc.isSuccess()) {
                splitTpList.addAll(splitTempTpList);
                StringBuilder sb = new StringBuilder();
                sb.append("\u53e5\u70b9\u89e3\u6790\u5206\u5272: ");
                sb.append(enList.size());
                if (enList.size() != splitTempTpList.size()) {
                    sb.append(" (");
                    sb.append(enList.size() - splitTempTpList.size());
                    sb.append(" \u500b\u306e\u7ffb\u8a33\u4e0d\u8981\u30a8\u30f3\u30c8\u30ea\u30fc\u524a\u9664)");
                }
                for (TranslationProperty sp : splitTempTpList) {
                    sb.append("\n" + sp);
                }
                this.splitLog.info(vc.formatMessage(sb.toString()), new Object[0]);
                continue;
            }
            noSplitTpList.add(tp);
        }
        noSplitTpList.addAll(splitTpList);
        splitTpList = noSplitTpList;
        this.log.info("%6d \u30a8\u30f3\u30c8\u30ea\u30fc (\u5206\u5272\u5f8c), %6d \u30a8\u30f3\u30c8\u30ea\u30fc\u5897\u52a0", splitTpList.size(), splitTpList.size() - inProp.size());
        return splitTpList;
    }

    protected void applyEntry(TranslationProperty tp, PropertySet outProp) {
        String en = Mnemonics.removeEn(tp.en.trim());
        String ja = Mnemonics.removeJa(tp.ja.trim());
        AbstractValidator.ValidationContext vc = new AbstractValidator.ValidationContext(en, ja, null);
        if (en.isEmpty() || ja.isEmpty()) {
            vc.warn("\u30a8\u30f3\u30c8\u30ea\u30fc\u304c\u7a7a\u306e\u305f\u3081\u9664\u5916\u3057\u307e\u3059\u3002");
            return;
        }
        if (this.isForbidden(en)) {
            vc.warn("\u7ffb\u8a33\u7981\u6b62\u306e\u305f\u3081\u9664\u5916\u3057\u307e\u3059\u3002");
            return;
        }
        if (vIgnoreSet.contains(en)) {
            outProp.put(en, ja);
            return;
        }
        for (Property rep : vTermProp) {
            String ng = rep.key;
            String ok = rep.value;
            if (ok.length() <= 0 || !ja.matches("(?s).*?" + ng + ".*")) continue;
            Pattern pat = PatternCache.get(ng);
            Matcher mat = pat.matcher(ja);
            StringBuffer sb = new StringBuffer();
            while (mat.find()) {
                mat.appendReplacement(sb, ok);
            }
            mat.appendTail(sb);
            ja = sb.toString();
        }
        ja = this.optimizeSuffix(en, ja);
        for (Pattern pat : Validator.ADJACENT_WORD_SPACE_PATTERN_LIST) {
            ja = pat.matcher(ja).replaceAll("$1 $2");
        }
        if (!ja.contains("\u79d2")) {
            en = TranslationString.removeS(en);
        }
        if (ja.equals(en)) {
            vc.info("\u30eb\u30fc\u30eb\u9069\u7528\u5f8c\u3001\u672a\u7ffb\u8a33\u306e\u305f\u3081\u9664\u5916\u3057\u307e\u3059\u3002");
            return;
        }
        String jaExists = (String)this.existsProp.get(en);
        if (jaExists != null && !jaExists.equals(ja)) {
            vc.error("\u65e2: " + jaExists + "\n" + "\u65e2\u5b58\u8f9e\u66f8\u306b\u7570\u306a\u308b\u8a33\u304c\u5b58\u5728\u3057\u307e\u3059\u3002");
            return;
        }
        jaExists = (String)outProp.get(en);
        if (jaExists != null && !jaExists.equals(ja)) {
            vc.error("\u65e2: " + jaExists + "\n" + "\u540c\u3058\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u30fb\u30d5\u30a1\u30a4\u30eb\u5185\u306b\u7570\u306a\u308b\u8a33\u304c\u5b58\u5728\u3057\u307e\u3059\u3002");
            return;
        }
        if (!tp.ja.toString().equals(ja)) {
            this.validationLog.info("\u7ffb\u8a33\u30eb\u30fc\u30eb\u306b\u3088\u308a\u6700\u9069\u5316\u3055\u308c\u307e\u3057\u305f\u3002\n      \u6700\u9069\u5316\u524d: %s\n      \u6700\u9069\u5316\u5f8c: %s\n", tp.getProperty(), Property.toString(en, ja));
        }
        outProp.put(en, ja);
    }

    protected String optimizeSuffix(String en, String ja) {
        if (ja.endsWith("\uff1a")) {
            ja = ja.replaceFirst("\uff1a$", ":");
        }
        if (!en.endsWith(" :") && ja.endsWith(" :")) {
            ja = ja.replaceFirst(" :$", ":");
        }
        if (!(en.endsWith(".") || en.endsWith(":") || en.endsWith(";") || en.endsWith(",") || !ja.endsWith("\u3002"))) {
            ja = ja.replaceFirst("\u3002$", "");
        } else if (!en.endsWith("..") && en.endsWith(".") && !ja.endsWith("\u3002")) {
            if (en.contains(" ") && !en.contains(":") && !TranslationString.endsWithAbbrev(en)) {
                ja = ja + "\u3002";
            }
        } else if (en.endsWith(":") && !ja.endsWith(":") && !ja.endsWith("\u3002")) {
            ja = ja + ":";
        }
        return ja;
    }

    public static void main(String ... args) {
        String propPath = "props/_a.properties";
        PropertySet inProp = new PropertySet(propPath);
        PropertySet outProp = new TranslationRule(propPath + ".log", new PropertySet[0]).apply(inProp);
        PropertySet existsProp = new PropertySet("translation.properties");
        new Validator("props/_a.properties.log", existsProp).validate(outProp);
        outProp.store("props/_a_out.properties", "");
    }
}

