/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.jstyle;

import jp.sourceforge.mergedoc.jstyle.JStyleConstants;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class JStylePlugin
extends AbstractUIPlugin
implements IStartup {
    public static final String PLUGIN_ID = JStylePlugin.class.getPackage().getName();
    private static JStylePlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static JStylePlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void earlyStartup() {
        this.applySWT();
    }

    public void applySWT() {
        GC.JStyleSWTBridge.lineBreakRGB = this.getRGBPreference("LineBreakPreference");
        GC.JStyleSWTBridge.tabRGB = this.getRGBPreference("TabPreference");
        GC.JStyleSWTBridge.fullWidthSpaceRGB = this.getRGBPreference("FullWidthSpacePreference");
        GC.JStyleSWTBridge.halfWidthSpaceRGB = this.getRGBPreference("HalfWidthSpacePreference");
        GC.JStyleSWTBridge.tabGlyph = this.getComboPreference("TabPreference_COMBO");
        GC.JStyleSWTBridge.forceMonospace = this.getBooleanPreference("ForceMonospacePreference");
        StyledText.redrawJStyle();
    }

    private RGB getRGBPreference(String key) {
        try {
            String value;
            IPreferenceStore store = JStylePlugin.getDefault().getPreferenceStore();
            if (store.getBoolean(key + "_SHOW") && (value = store.getString(key + "_COLOR")) != null) {
                return StringConverter.asRGB((String)value);
            }
        }
        catch (Exception e) {
            Status status = new Status(4, this.getBundle().getSymbolicName(), 0, "Unable to get RGB preference. key:" + key, (Throwable)e);
            plugin.getLog().log((IStatus)status);
            return StringConverter.asRGB((String)JStyleConstants.DEFAULT_RGB_STRING);
        }
        return null;
    }

    private boolean getBooleanPreference(String key) {
        IPreferenceStore store = JStylePlugin.getDefault().getPreferenceStore();
        return store.getBoolean(key);
    }

    private String getComboPreference(String key) {
        IPreferenceStore store = JStylePlugin.getDefault().getPreferenceStore();
        return store.getString(key);
    }

    public static void log(String msg) {
        ILog log = plugin.getLog();
        log.log((IStatus)new Status(1, PLUGIN_ID, 0, msg, null));
    }
}

