/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.AuthenticationListener;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

abstract class WebBrowser {
    Browser browser;
    Hashtable functions = new Hashtable();
    AuthenticationListener[] authenticationListeners = new AuthenticationListener[0];
    CloseWindowListener[] closeWindowListeners = new CloseWindowListener[0];
    LocationListener[] locationListeners = new LocationListener[0];
    OpenWindowListener[] openWindowListeners = new OpenWindowListener[0];
    ProgressListener[] progressListeners = new ProgressListener[0];
    StatusTextListener[] statusTextListeners = new StatusTextListener[0];
    TitleListener[] titleListeners = new TitleListener[0];
    VisibilityWindowListener[] visibilityWindowListeners = new VisibilityWindowListener[0];
    boolean jsEnabledOnNextPage = true;
    boolean jsEnabled = true;
    int nextFunctionIndex = 1;
    Object evaluateResult;
    static final String ERROR_ID = "org.eclipse.swt.browser.error";
    static final String EXECUTE_ID = "SWTExecuteTemporaryFunction";
    static Vector NativePendingCookies = new Vector();
    static Vector MozillaPendingCookies = new Vector();
    static String CookieName;
    static String CookieValue;
    static String CookieUrl;
    static boolean CookieResult;
    static Runnable MozillaClearSessions;
    static Runnable NativeClearSessions;
    static Runnable MozillaGetCookie;
    static Runnable NativeGetCookie;
    static Runnable MozillaSetCookie;
    static Runnable NativeSetCookie;
    static final int[][] KeyTable;

    WebBrowser() {
    }

    public void addAuthenticationListener(AuthenticationListener listener) {
        AuthenticationListener[] newAuthenticationListeners = new AuthenticationListener[this.authenticationListeners.length + 1];
        System.arraycopy(this.authenticationListeners, 0, newAuthenticationListeners, 0, this.authenticationListeners.length);
        this.authenticationListeners = newAuthenticationListeners;
        this.authenticationListeners[this.authenticationListeners.length - 1] = listener;
    }

    public void addCloseWindowListener(CloseWindowListener listener) {
        CloseWindowListener[] newCloseWindowListeners = new CloseWindowListener[this.closeWindowListeners.length + 1];
        System.arraycopy(this.closeWindowListeners, 0, newCloseWindowListeners, 0, this.closeWindowListeners.length);
        this.closeWindowListeners = newCloseWindowListeners;
        this.closeWindowListeners[this.closeWindowListeners.length - 1] = listener;
    }

    public void addLocationListener(LocationListener listener) {
        LocationListener[] newLocationListeners = new LocationListener[this.locationListeners.length + 1];
        System.arraycopy(this.locationListeners, 0, newLocationListeners, 0, this.locationListeners.length);
        this.locationListeners = newLocationListeners;
        this.locationListeners[this.locationListeners.length - 1] = listener;
    }

    public void addOpenWindowListener(OpenWindowListener listener) {
        OpenWindowListener[] newOpenWindowListeners = new OpenWindowListener[this.openWindowListeners.length + 1];
        System.arraycopy(this.openWindowListeners, 0, newOpenWindowListeners, 0, this.openWindowListeners.length);
        this.openWindowListeners = newOpenWindowListeners;
        this.openWindowListeners[this.openWindowListeners.length - 1] = listener;
    }

    public void addProgressListener(ProgressListener listener) {
        ProgressListener[] newProgressListeners = new ProgressListener[this.progressListeners.length + 1];
        System.arraycopy(this.progressListeners, 0, newProgressListeners, 0, this.progressListeners.length);
        this.progressListeners = newProgressListeners;
        this.progressListeners[this.progressListeners.length - 1] = listener;
    }

    public void addStatusTextListener(StatusTextListener listener) {
        StatusTextListener[] newStatusTextListeners = new StatusTextListener[this.statusTextListeners.length + 1];
        System.arraycopy(this.statusTextListeners, 0, newStatusTextListeners, 0, this.statusTextListeners.length);
        this.statusTextListeners = newStatusTextListeners;
        this.statusTextListeners[this.statusTextListeners.length - 1] = listener;
    }

    public void addTitleListener(TitleListener listener) {
        TitleListener[] newTitleListeners = new TitleListener[this.titleListeners.length + 1];
        System.arraycopy(this.titleListeners, 0, newTitleListeners, 0, this.titleListeners.length);
        this.titleListeners = newTitleListeners;
        this.titleListeners[this.titleListeners.length - 1] = listener;
    }

    public void addVisibilityWindowListener(VisibilityWindowListener listener) {
        VisibilityWindowListener[] newVisibilityWindowListeners = new VisibilityWindowListener[this.visibilityWindowListeners.length + 1];
        System.arraycopy(this.visibilityWindowListeners, 0, newVisibilityWindowListeners, 0, this.visibilityWindowListeners.length);
        this.visibilityWindowListeners = newVisibilityWindowListeners;
        this.visibilityWindowListeners[this.visibilityWindowListeners.length - 1] = listener;
    }

    public abstract boolean back();

    public static void clearSessions() {
        if (NativeClearSessions != null) {
            NativeClearSessions.run();
        }
        if (MozillaClearSessions != null) {
            MozillaClearSessions.run();
        }
    }

    public static String GetCookie(String name, String url) {
        CookieName = name;
        CookieUrl = url;
        CookieValue = null;
        if (NativeGetCookie != null) {
            NativeGetCookie.run();
        }
        if (CookieValue == null && MozillaGetCookie != null) {
            MozillaGetCookie.run();
        }
        String result = CookieValue;
        CookieUrl = null;
        CookieValue = null;
        CookieName = null;
        return result;
    }

    public static boolean SetCookie(String value, String url, boolean addToPending) {
        CookieValue = value;
        CookieUrl = url;
        CookieResult = false;
        if (NativeSetCookie != null) {
            NativeSetCookie.run();
        } else if (addToPending && NativePendingCookies != null) {
            NativePendingCookies.add(new String[]{value, url});
        }
        if (MozillaSetCookie != null) {
            MozillaSetCookie.run();
        } else if (addToPending && MozillaPendingCookies != null) {
            MozillaPendingCookies.add(new String[]{value, url});
        }
        CookieUrl = null;
        CookieValue = null;
        return CookieResult;
    }

    static void SetPendingCookies(Vector pendingCookies) {
        Enumeration elements = pendingCookies.elements();
        while (elements.hasMoreElements()) {
            String[] current = (String[])elements.nextElement();
            WebBrowser.SetCookie(current[0], current[1], false);
        }
    }

    public abstract void create(Composite var1, int var2);

    static String CreateErrorString(String error) {
        return ERROR_ID + error;
    }

    static String ExtractError(String error) {
        return error.substring(ERROR_ID.length());
    }

    public boolean close() {
        return true;
    }

    public void createFunction(BrowserFunction function) {
        Enumeration keys = this.functions.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            BrowserFunction current = (BrowserFunction)this.functions.get(key);
            if (!current.name.equals(function.name)) continue;
            this.deregisterFunction(current);
            break;
        }
        function.index = this.getNextFunctionIndex();
        this.registerFunction(function);
        StringBuffer functionBuffer = new StringBuffer(function.name);
        functionBuffer.append(" = function ");
        functionBuffer.append(function.name);
        functionBuffer.append("() {var result = callJava(");
        functionBuffer.append(function.index);
        functionBuffer.append(",'");
        functionBuffer.append(function.token);
        functionBuffer.append("',Array.prototype.slice.call(arguments)); if (typeof result == 'string' && result.indexOf('");
        functionBuffer.append(ERROR_ID);
        functionBuffer.append("') == 0) {var error = new Error(result.substring(");
        functionBuffer.append(ERROR_ID.length());
        functionBuffer.append(")); throw error;} return result;};");
        StringBuffer buffer = new StringBuffer("if (!window.callJava) {window.callJava = function callJava(index, token, args) {");
        buffer.append("return external.callJava(index,token,args);}};");
        if (function.top) {
            buffer.append(functionBuffer.toString());
        }
        buffer.append("var frameIds = null;");
        if (function.frameNames != null) {
            buffer.append("frameIds = {");
            for (int i = 0; i < function.frameNames.length; ++i) {
                buffer.append('\'');
                buffer.append(function.frameNames[i]);
                buffer.append("':1,");
            }
            if (function.frameNames.length > 0) {
                buffer.deleteCharAt(buffer.length() - 1);
            }
            buffer.append("};");
        }
        buffer.append("for (var i = 0; i < frames.length; i++) {try {if (!frameIds || (frames[i].name && frameIds[frames[i].name])) {");
        buffer.append("if (!frames[i].callJava) {frames[i].callJava = window.callJava;} frames[i].");
        buffer.append(functionBuffer.toString());
        buffer.append("}} catch(e) {}};");
        function.functionString = buffer.toString();
        this.execute(function.functionString);
    }

    void deregisterFunction(BrowserFunction function) {
        this.functions.remove(new Integer(function.index));
    }

    public void destroyFunction(BrowserFunction function) {
        String deleteString = this.getDeleteFunctionString(function.name);
        StringBuffer buffer = new StringBuffer("for (var i = 0; i < frames.length; i++) {try {frames[i].eval(\"");
        buffer.append(deleteString);
        buffer.append("\");} catch (e) {}}");
        this.execute(buffer.toString());
        this.execute(deleteString);
        this.deregisterFunction(function);
    }

    public abstract boolean execute(String var1);

    public Object evaluate(String script) throws SWTException {
        int index;
        EvaluateFunction function = new EvaluateFunction(this.browser, "");
        function.index = index = this.getNextFunctionIndex();
        function.isEvaluate = true;
        this.registerFunction(function);
        String functionName = EXECUTE_ID + index;
        StringBuffer buffer = new StringBuffer("window.");
        buffer.append(functionName);
        buffer.append(" = function ");
        buffer.append(functionName);
        buffer.append("() {\n");
        buffer.append(script);
        buffer.append("\n};");
        this.execute(buffer.toString());
        buffer = new StringBuffer("if (window.");
        buffer.append(functionName);
        buffer.append(" == undefined) {window.external.callJava(");
        buffer.append(index);
        buffer.append(",'");
        buffer.append(function.token);
        buffer.append("', ['");
        buffer.append(ERROR_ID);
        buffer.append("']);} else {try {var result = ");
        buffer.append(functionName);
        buffer.append("(); window.external.callJava(");
        buffer.append(index);
        buffer.append(",'");
        buffer.append(function.token);
        buffer.append("', [result]);} catch (e) {window.external.callJava(");
        buffer.append(index);
        buffer.append(",'");
        buffer.append(function.token);
        buffer.append("', ['");
        buffer.append(ERROR_ID);
        buffer.append("' + e.message]);}}");
        this.execute(buffer.toString());
        this.execute(this.getDeleteFunctionString(functionName));
        this.deregisterFunction(function);
        Object result = this.evaluateResult;
        this.evaluateResult = null;
        if (result instanceof SWTException) {
            throw (SWTException)result;
        }
        return result;
    }

    public abstract boolean forward();

    public abstract String getBrowserType();

    String getDeleteFunctionString(String functionName) {
        return "delete window." + functionName;
    }

    int getNextFunctionIndex() {
        return this.nextFunctionIndex++;
    }

    public abstract String getText();

    public abstract String getUrl();

    public Object getWebBrowser() {
        return null;
    }

    public abstract boolean isBackEnabled();

    public boolean isFocusControl() {
        return false;
    }

    public abstract boolean isForwardEnabled();

    public abstract void refresh();

    void registerFunction(BrowserFunction function) {
        this.functions.put(new Integer(function.index), function);
    }

    public void removeAuthenticationListener(AuthenticationListener listener) {
        if (this.authenticationListeners.length == 0) {
            return;
        }
        int index = -1;
        for (int i = 0; i < this.authenticationListeners.length; ++i) {
            if (listener != this.authenticationListeners[i]) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return;
        }
        if (this.authenticationListeners.length == 1) {
            this.authenticationListeners = new AuthenticationListener[0];
            return;
        }
        AuthenticationListener[] newAuthenticationListeners = new AuthenticationListener[this.authenticationListeners.length - 1];
        System.arraycopy(this.authenticationListeners, 0, newAuthenticationListeners, 0, index);
        System.arraycopy(this.authenticationListeners, index + 1, newAuthenticationListeners, index, this.authenticationListeners.length - index - 1);
        this.authenticationListeners = newAuthenticationListeners;
    }

    public void removeCloseWindowListener(CloseWindowListener listener) {
        if (this.closeWindowListeners.length == 0) {
            return;
        }
        int index = -1;
        for (int i = 0; i < this.closeWindowListeners.length; ++i) {
            if (listener != this.closeWindowListeners[i]) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return;
        }
        if (this.closeWindowListeners.length == 1) {
            this.closeWindowListeners = new CloseWindowListener[0];
            return;
        }
        CloseWindowListener[] newCloseWindowListeners = new CloseWindowListener[this.closeWindowListeners.length - 1];
        System.arraycopy(this.closeWindowListeners, 0, newCloseWindowListeners, 0, index);
        System.arraycopy(this.closeWindowListeners, index + 1, newCloseWindowListeners, index, this.closeWindowListeners.length - index - 1);
        this.closeWindowListeners = newCloseWindowListeners;
    }

    public void removeLocationListener(LocationListener listener) {
        if (this.locationListeners.length == 0) {
            return;
        }
        int index = -1;
        for (int i = 0; i < this.locationListeners.length; ++i) {
            if (listener != this.locationListeners[i]) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return;
        }
        if (this.locationListeners.length == 1) {
            this.locationListeners = new LocationListener[0];
            return;
        }
        LocationListener[] newLocationListeners = new LocationListener[this.locationListeners.length - 1];
        System.arraycopy(this.locationListeners, 0, newLocationListeners, 0, index);
        System.arraycopy(this.locationListeners, index + 1, newLocationListeners, index, this.locationListeners.length - index - 1);
        this.locationListeners = newLocationListeners;
    }

    public void removeOpenWindowListener(OpenWindowListener listener) {
        if (this.openWindowListeners.length == 0) {
            return;
        }
        int index = -1;
        for (int i = 0; i < this.openWindowListeners.length; ++i) {
            if (listener != this.openWindowListeners[i]) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return;
        }
        if (this.openWindowListeners.length == 1) {
            this.openWindowListeners = new OpenWindowListener[0];
            return;
        }
        OpenWindowListener[] newOpenWindowListeners = new OpenWindowListener[this.openWindowListeners.length - 1];
        System.arraycopy(this.openWindowListeners, 0, newOpenWindowListeners, 0, index);
        System.arraycopy(this.openWindowListeners, index + 1, newOpenWindowListeners, index, this.openWindowListeners.length - index - 1);
        this.openWindowListeners = newOpenWindowListeners;
    }

    public void removeProgressListener(ProgressListener listener) {
        if (this.progressListeners.length == 0) {
            return;
        }
        int index = -1;
        for (int i = 0; i < this.progressListeners.length; ++i) {
            if (listener != this.progressListeners[i]) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return;
        }
        if (this.progressListeners.length == 1) {
            this.progressListeners = new ProgressListener[0];
            return;
        }
        ProgressListener[] newProgressListeners = new ProgressListener[this.progressListeners.length - 1];
        System.arraycopy(this.progressListeners, 0, newProgressListeners, 0, index);
        System.arraycopy(this.progressListeners, index + 1, newProgressListeners, index, this.progressListeners.length - index - 1);
        this.progressListeners = newProgressListeners;
    }

    public void removeStatusTextListener(StatusTextListener listener) {
        if (this.statusTextListeners.length == 0) {
            return;
        }
        int index = -1;
        for (int i = 0; i < this.statusTextListeners.length; ++i) {
            if (listener != this.statusTextListeners[i]) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return;
        }
        if (this.statusTextListeners.length == 1) {
            this.statusTextListeners = new StatusTextListener[0];
            return;
        }
        StatusTextListener[] newStatusTextListeners = new StatusTextListener[this.statusTextListeners.length - 1];
        System.arraycopy(this.statusTextListeners, 0, newStatusTextListeners, 0, index);
        System.arraycopy(this.statusTextListeners, index + 1, newStatusTextListeners, index, this.statusTextListeners.length - index - 1);
        this.statusTextListeners = newStatusTextListeners;
    }

    public void removeTitleListener(TitleListener listener) {
        if (this.titleListeners.length == 0) {
            return;
        }
        int index = -1;
        for (int i = 0; i < this.titleListeners.length; ++i) {
            if (listener != this.titleListeners[i]) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return;
        }
        if (this.titleListeners.length == 1) {
            this.titleListeners = new TitleListener[0];
            return;
        }
        TitleListener[] newTitleListeners = new TitleListener[this.titleListeners.length - 1];
        System.arraycopy(this.titleListeners, 0, newTitleListeners, 0, index);
        System.arraycopy(this.titleListeners, index + 1, newTitleListeners, index, this.titleListeners.length - index - 1);
        this.titleListeners = newTitleListeners;
    }

    public void removeVisibilityWindowListener(VisibilityWindowListener listener) {
        if (this.visibilityWindowListeners.length == 0) {
            return;
        }
        int index = -1;
        for (int i = 0; i < this.visibilityWindowListeners.length; ++i) {
            if (listener != this.visibilityWindowListeners[i]) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return;
        }
        if (this.visibilityWindowListeners.length == 1) {
            this.visibilityWindowListeners = new VisibilityWindowListener[0];
            return;
        }
        VisibilityWindowListener[] newVisibilityWindowListeners = new VisibilityWindowListener[this.visibilityWindowListeners.length - 1];
        System.arraycopy(this.visibilityWindowListeners, 0, newVisibilityWindowListeners, 0, index);
        System.arraycopy(this.visibilityWindowListeners, index + 1, newVisibilityWindowListeners, index, this.visibilityWindowListeners.length - index - 1);
        this.visibilityWindowListeners = newVisibilityWindowListeners;
    }

    boolean sendKeyEvent(Event event) {
        int traversal = 0;
        boolean traverseDoit = true;
        switch (event.keyCode) {
            case 27: {
                traversal = 2;
                traverseDoit = true;
                break;
            }
            case 13: {
                traversal = 4;
                traverseDoit = false;
                break;
            }
            case 0x1000002: 
            case 0x1000004: {
                traversal = 64;
                traverseDoit = false;
                break;
            }
            case 0x1000001: 
            case 0x1000003: {
                traversal = 32;
                traverseDoit = false;
                break;
            }
            case 9: {
                traversal = (event.stateMask & 0x20000) != 0 ? 8 : 16;
                traverseDoit = (event.stateMask & 0x40000) != 0;
                break;
            }
            case 0x1000006: {
                if ((event.stateMask & 0x40000) == 0) break;
                traversal = 512;
                traverseDoit = true;
                break;
            }
            case 0x1000005: {
                if ((event.stateMask & 0x40000) == 0) break;
                traversal = 256;
                traverseDoit = true;
                break;
            }
            default: {
                if (!this.translateMnemonics() || event.character == '\u0000' || (event.stateMask & 0x50000) != 65536) break;
                traversal = 128;
                traverseDoit = true;
            }
        }
        boolean doit = true;
        if (traversal != 0) {
            boolean oldEventDoit = event.doit;
            event.doit = traverseDoit;
            doit = !this.browser.traverse(traversal, event);
            event.doit = oldEventDoit;
        }
        if (doit) {
            this.browser.notifyListeners(event.type, event);
            doit = event.doit;
        }
        return doit;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    public abstract boolean setText(String var1, boolean var2);

    public abstract boolean setUrl(String var1, String var2, String[] var3);

    public abstract void stop();

    int translateKey(int key) {
        for (int i = 0; i < KeyTable.length; ++i) {
            if (KeyTable[i][0] != key) continue;
            return KeyTable[i][1];
        }
        return 0;
    }

    boolean translateMnemonics() {
        return true;
    }

    static {
        KeyTable = new int[][]{{18, 65536}, {16, 131072}, {17, 262144}, {224, 0x400000}, {65, 97}, {66, 98}, {67, 99}, {68, 100}, {69, 101}, {70, 102}, {71, 103}, {72, 104}, {73, 105}, {74, 106}, {75, 107}, {76, 108}, {77, 109}, {78, 110}, {79, 111}, {80, 112}, {81, 113}, {82, 114}, {83, 115}, {84, 116}, {85, 117}, {86, 118}, {87, 119}, {88, 120}, {89, 121}, {90, 122}, {48, 48}, {49, 49}, {50, 50}, {51, 51}, {52, 52}, {53, 53}, {54, 54}, {55, 55}, {56, 56}, {57, 57}, {32, 32}, {59, 59}, {61, 61}, {188, 44}, {190, 46}, {191, 47}, {219, 91}, {221, 93}, {222, 39}, {192, 96}, {220, 92}, {108, 124}, {37, 0x1000003}, {39, 0x1000004}, {38, 0x1000001}, {40, 0x1000002}, {45, 0x1000009}, {36, 0x1000007}, {35, 0x1000008}, {46, 127}, {33, 0x1000005}, {34, 0x1000006}, {8, 8}, {13, 13}, {9, 9}, {27, 27}, {12, 127}, {112, 0x100000A}, {113, 0x100000B}, {114, 0x100000C}, {115, 0x100000D}, {116, 0x100000E}, {117, 0x100000F}, {118, 0x1000010}, {119, 0x1000011}, {120, 0x1000012}, {121, 0x1000013}, {122, 0x1000014}, {123, 0x1000015}, {124, 0x1000016}, {125, 0x1000017}, {126, 0x1000018}, {127, 0}, {128, 0}, {129, 0}, {130, 0}, {131, 0}, {132, 0}, {133, 0}, {134, 0}, {135, 0}, {96, 0x1000030}, {97, 0x1000031}, {98, 16777266}, {99, 0x1000033}, {100, 16777268}, {101, 16777269}, {102, 16777270}, {103, 16777271}, {104, 16777272}, {105, 16777273}, {14, 0x1000050}, {107, 16777259}, {109, 16777261}, {106, 16777258}, {111, 16777263}, {110, 16777262}, {20, 16777298}, {144, 16777299}, {145, 16777300}, {44, 16777303}, {6, 0x1000051}, {19, 0x1000055}, {3, 16777302}, {186, 59}, {187, 61}, {189, 45}};
    }

    public class EvaluateFunction
    extends BrowserFunction {
        public EvaluateFunction(Browser browser, String name) {
            super(browser, name, true, new String[0], false);
        }

        public Object function(Object[] arguments) {
            String string;
            if (arguments[0] instanceof String && (string = (String)arguments[0]).startsWith(WebBrowser.ERROR_ID)) {
                String errorString = WebBrowser.ExtractError(string);
                WebBrowser.this.evaluateResult = errorString.length() > 0 ? new SWTException(50, errorString) : new SWTException(50);
                return null;
            }
            WebBrowser.this.evaluateResult = arguments[0];
            return null;
        }
    }
}

