/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCRIPT_ANALYSIS;
import org.eclipse.swt.internal.win32.SCRIPT_CONTROL;
import org.eclipse.swt.internal.win32.SCRIPT_FONTPROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_ITEM;
import org.eclipse.swt.internal.win32.SCRIPT_LOGATTR;
import org.eclipse.swt.internal.win32.SCRIPT_PROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_STATE;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    String segmentsText;
    int lineSpacing;
    int ascent;
    int descent;
    int alignment;
    int wrapWidth;
    int orientation;
    int[] tabs;
    int[] segments;
    StyleItem[] styles;
    StyleItem[] allRuns;
    StyleItem[][] runs;
    int[] lineOffset;
    int[] lineY;
    int[] lineWidth;
    int mLangFontLink2;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final int SCRIPT_VISATTR_SIZEOF = 2;
    static final int GOFFSET_SIZEOF = 8;
    static final byte[] CLSID_CMultiLanguage = new byte[16];
    static final byte[] IID_IMLangFontLink2 = new byte[16];

    public TextLayout(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error((int)4);
        }
        this.device = device;
        this.descent = -1;
        this.ascent = -1;
        this.wrapWidth = -1;
        this.lineSpacing = 0;
        this.orientation = 0x2000000;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.text = "";
        int[] ppv = new int[1];
        OS.OleInitialize((int)0);
        if (OS.CoCreateInstance((byte[])CLSID_CMultiLanguage, (int)0, (int)1, (byte[])IID_IMLangFontLink2, (int[])ppv) == 0) {
            this.mLangFontLink2 = ppv[0];
        }
        if (device.tracking) {
            device.new_Object((Object)this);
        }
    }

    void breakRun(StyleItem run) {
        if (run.psla != 0) {
            return;
        }
        char[] chars = new char[run.length];
        this.segmentsText.getChars(run.start, run.start + run.length, chars, 0);
        int hHeap = OS.GetProcessHeap();
        run.psla = OS.HeapAlloc((int)hHeap, (int)8, (int)(1 * chars.length));
        OS.ScriptBreak((char[])chars, (int)chars.length, (SCRIPT_ANALYSIS)run.analysis, (int)run.psla);
    }

    void checkItem(int hDC, StyleItem item) {
        if (item.fallbackFont != 0) {
            LOGFONTW logFont;
            Object object = logFont = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            if (OS.GetObject((int)item.fallbackFont, (int)LOGFONT.sizeof, (LOGFONT)logFont) == 0) {
                item.free();
                OS.SelectObject((int)hDC, (int)this.getItemFont(item));
                this.shape(hDC, item);
            }
        }
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error((int)44);
        }
    }

    void computeRuns(GC gc) {
        if (this.runs != null) {
            return;
        }
        int hDC = gc != null ? gc.handle : this.device.internal_new_GC(null);
        int srcHdc = OS.CreateCompatibleDC((int)hDC);
        this.allRuns = this.itemize();
        for (int i = 0; i < this.allRuns.length - 1; ++i) {
            StyleItem run = this.allRuns[i];
            int hFont = this.getItemFont(run);
            OS.SelectObject((int)srcHdc, (int)hFont);
            this.shape(srcHdc, run);
            if (!JStyleSWTBridge.forceMonospace || this.font == null || hFont == this.font.handle) continue;
            this.forceMonospace(srcHdc, run);
        }
        SCRIPT_LOGATTR logAttr = new SCRIPT_LOGATTR();
        SCRIPT_PROPERTIES properties = new SCRIPT_PROPERTIES();
        int lineWidth = 0;
        int lineStart = 0;
        int lineCount = 1;
        for (int i = 0; i < this.allRuns.length - 1; ++i) {
            StyleItem run = this.allRuns[i];
            if (run.length == 1) {
                char ch = this.segmentsText.charAt(run.start);
                switch (ch) {
                    case '\t': {
                        int tabX;
                        int lastTabWidth;
                        int j;
                        run.tab = true;
                        if (this.tabs == null) break;
                        int tabsLength = this.tabs.length;
                        for (j = 0; j < tabsLength; ++j) {
                            if (this.tabs[j] <= lineWidth) continue;
                            run.width = this.tabs[j] - lineWidth;
                            break;
                        }
                        if (j != tabsLength) break;
                        int n = lastTabWidth = tabsLength > 1 ? this.tabs[tabsLength - 1] - this.tabs[tabsLength - 2] : this.tabs[0];
                        if (lastTabWidth <= 0) break;
                        for (tabX = this.tabs[tabsLength - 1]; tabX <= lineWidth; tabX += lastTabWidth) {
                        }
                        run.width = tabX - lineWidth;
                        break;
                    }
                    case '\n': {
                        run.lineBreak = true;
                        break;
                    }
                    case '\r': {
                        run.lineBreak = true;
                        StyleItem next = this.allRuns[i + 1];
                        if (next.length == 0 || this.segmentsText.charAt(next.start) != '\n') break;
                        ++run.length;
                        next.free();
                        ++i;
                        break;
                    }
                }
            }
            if (this.wrapWidth != -1 && lineWidth + run.width > this.wrapWidth && !run.tab) {
                int start = 0;
                int[] piDx = new int[run.length];
                OS.ScriptGetLogicalWidths((SCRIPT_ANALYSIS)run.analysis, (int)run.length, (int)run.glyphCount, (int)run.advances, (int)run.clusters, (int)run.visAttrs, (int[])piDx);
                int width = 0;
                int maxWidth = this.wrapWidth - lineWidth;
                while (width + piDx[start] < maxWidth) {
                    width += piDx[start++];
                }
                int firstStart = start;
                int firstIndice = i;
                while (i >= lineStart) {
                    this.breakRun(run);
                    while (start >= 0) {
                        OS.MoveMemory((SCRIPT_LOGATTR)logAttr, (int)(run.psla + start * 1), (int)1);
                        if (logAttr.fSoftBreak || logAttr.fWhiteSpace) break;
                        --start;
                    }
                    if (start == 0 && i != lineStart && !run.tab && logAttr.fSoftBreak && !logAttr.fWhiteSpace) {
                        OS.MoveMemory((SCRIPT_PROPERTIES)properties, (int)this.device.scripts[run.analysis.eScript], (int)8);
                        short langID = properties.langid;
                        StyleItem pRun = this.allRuns[i - 1];
                        OS.MoveMemory((SCRIPT_PROPERTIES)properties, (int)this.device.scripts[pRun.analysis.eScript], (int)8);
                        if (properties.langid == langID || langID == 0 || properties.langid == 0) {
                            this.breakRun(pRun);
                            OS.MoveMemory((SCRIPT_LOGATTR)logAttr, (int)(pRun.psla + (pRun.length - 1) * 1), (int)1);
                            if (!logAttr.fWhiteSpace) {
                                start = -1;
                            }
                        }
                    }
                    if (start >= 0 || i == lineStart) break;
                    run = this.allRuns[--i];
                    start = run.length - 1;
                }
                if (start == 0 && i != lineStart && !run.tab) {
                    run = this.allRuns[--i];
                } else if (start <= 0 && i == lineStart) {
                    i = firstIndice;
                    run = this.allRuns[i];
                    start = Math.max(1, firstStart);
                }
                this.breakRun(run);
                while (start < run.length) {
                    OS.MoveMemory((SCRIPT_LOGATTR)logAttr, (int)(run.psla + start * 1), (int)1);
                    if (!logAttr.fWhiteSpace) break;
                    ++start;
                }
                if (0 < start && start < run.length) {
                    StyleItem newRun = new StyleItem();
                    newRun.start = run.start + start;
                    newRun.length = run.length - start;
                    newRun.style = run.style;
                    newRun.analysis = run.analysis;
                    run.free();
                    run.length = start;
                    OS.SelectObject((int)srcHdc, (int)this.getItemFont(run));
                    this.shape(srcHdc, run);
                    OS.SelectObject((int)srcHdc, (int)this.getItemFont(newRun));
                    this.shape(srcHdc, newRun);
                    if (JStyleSWTBridge.forceMonospace && this.font != null) {
                        this.forceMonospace(srcHdc, run);
                        this.forceMonospace(srcHdc, newRun);
                    }
                    StyleItem[] newAllRuns = new StyleItem[this.allRuns.length + 1];
                    System.arraycopy(this.allRuns, 0, newAllRuns, 0, i + 1);
                    System.arraycopy(this.allRuns, i + 1, newAllRuns, i + 2, this.allRuns.length - i - 1);
                    this.allRuns = newAllRuns;
                    this.allRuns[i + 1] = newRun;
                }
                if (i != this.allRuns.length - 2) {
                    run.lineBreak = true;
                    run.softBreak = true;
                }
            }
            lineWidth += run.width;
            if (!run.lineBreak) continue;
            lineStart = i + 1;
            lineWidth = 0;
            ++lineCount;
        }
        lineWidth = 0;
        this.runs = new StyleItem[lineCount][];
        this.lineOffset = new int[lineCount + 1];
        this.lineY = new int[lineCount + 1];
        this.lineWidth = new int[lineCount];
        int lineRunCount = 0;
        int line = 0;
        int ascent = Math.max(0, this.ascent);
        int descent = Math.max(0, this.descent);
        StyleItem[] lineRuns = new StyleItem[this.allRuns.length];
        for (int i = 0; i < this.allRuns.length; ++i) {
            StyleItem run = this.allRuns[i];
            lineRuns[lineRunCount++] = run;
            lineWidth += run.width;
            ascent = Math.max(ascent, run.ascent);
            descent = Math.max(descent, run.descent);
            if (!run.lineBreak && i != this.allRuns.length - 1) continue;
            if (lineRunCount == 1 && i == this.allRuns.length - 1) {
                TEXTMETRICW lptm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                OS.SelectObject((int)srcHdc, (int)this.getItemFont(run));
                OS.GetTextMetrics((int)srcHdc, (TEXTMETRIC)lptm);
                run.ascent = lptm.tmAscent;
                run.descent = lptm.tmDescent;
                ascent = Math.max(ascent, run.ascent);
                descent = Math.max(descent, run.descent);
            }
            this.runs[line] = new StyleItem[lineRunCount];
            System.arraycopy(lineRuns, 0, this.runs[line], 0, lineRunCount);
            StyleItem lastRun = this.runs[line][lineRunCount - 1];
            this.runs[line] = this.reorder(this.runs[line]);
            this.lineWidth[line] = lineWidth;
            lineWidth = 0;
            if (this.wrapWidth != -1) {
                switch (this.alignment) {
                    case 0x1000000: {
                        lineWidth = (this.wrapWidth - this.lineWidth[line]) / 2;
                        break;
                    }
                    case 131072: {
                        lineWidth = this.wrapWidth - this.lineWidth[line];
                    }
                }
            }
            for (int j = 0; j < this.runs[line].length; ++j) {
                this.runs[line][j].x = lineWidth;
                lineWidth += this.runs[line][j].width;
            }
            this.lineY[++line] = this.lineY[line - 1] + ascent + descent + this.lineSpacing;
            this.lineOffset[line] = lastRun.start + lastRun.length;
            lineWidth = 0;
            lineRunCount = 0;
            ascent = Math.max(0, this.ascent);
            descent = Math.max(0, this.descent);
        }
        if (srcHdc != 0) {
            OS.DeleteDC((int)srcHdc);
        }
        if (gc == null) {
            this.device.internal_dispose_GC(hDC, null);
        }
    }

    public void dispose() {
        if (this.device == null) {
            return;
        }
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.segmentsText = null;
        this.tabs = null;
        this.styles = null;
        this.runs = null;
        this.lineOffset = null;
        this.lineY = null;
        this.lineWidth = null;
        if (this.mLangFontLink2 != 0) {
            OS.VtblCall((int)2, (int)this.mLangFontLink2);
            this.mLangFontLink2 = 0;
        }
        OS.OleUninitialize();
        if (this.device.tracking) {
            this.device.dispose_Object((Object)this);
        }
        this.device = null;
    }

    public void draw(GC gc, int x, int y, ControlCharRenderer ccRender) {
        this.draw(gc, x, y, ccRender, -1, -1, null, null);
    }

    public void draw(GC gc, int x, int y) {
        ControlCharRenderer nullRender = NullControlCharRenderer.getInstance();
        this.draw(gc, x, y, nullRender);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        ControlCharRenderer nullRender = NullControlCharRenderer.getInstance();
        this.draw(gc, x, y, nullRender, selectionStart, selectionEnd, selectionForeground, selectionBackground);
    }

    public void draw(GC gc, int x, int y, ControlCharRenderer ccRender, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        boolean hasSelection;
        this.checkLayout();
        this.computeRuns(gc);
        if (gc == null) {
            SWT.error((int)4);
        }
        if (gc.isDisposed()) {
            SWT.error((int)5);
        }
        if (selectionForeground != null && selectionForeground.isDisposed()) {
            SWT.error((int)5);
        }
        if (selectionBackground != null && selectionBackground.isDisposed()) {
            SWT.error((int)5);
        }
        int length = this.text.length();
        ccRender.init(gc, this.device);
        if (ccRender.isDrawLineBreak() && this.runs.length > 0 && this.lineY.length > 1) {
            int drawX = x;
            StyleItem[] lineRuns = this.runs[0];
            for (int i = 0; i < lineRuns.length; ++i) {
                StyleItem run = lineRuns[i];
                if (run.length == 0) continue;
                drawX += run.width;
            }
            int lineHeight = this.lineY[1] - this.lineY[0];
            ccRender.drawLineBreak(drawX, y, lineHeight);
        }
        if (length == 0) {
            return;
        }
        int hdc = gc.handle;
        boolean bl = hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
        if (hasSelection) {
            selectionStart = Math.min(Math.max(0, selectionStart), length - 1);
            selectionEnd = Math.min(Math.max(0, selectionEnd), length - 1);
            if (selectionForeground == null) {
                selectionForeground = this.device.getSystemColor(27);
            }
            if (selectionBackground == null) {
                selectionBackground = this.device.getSystemColor(26);
            }
            selectionStart = this.translateOffset(selectionStart);
            selectionEnd = this.translateOffset(selectionEnd);
        }
        int foreground = OS.GetTextColor((int)hdc);
        int state = OS.SaveDC((int)hdc);
        RECT rect = new RECT();
        int selBrush = 0;
        int selPen = 0;
        if (hasSelection) {
            selBrush = OS.CreateSolidBrush((int)selectionBackground.handle);
            selPen = OS.CreatePen((int)0, (int)1, (int)selectionForeground.handle);
        }
        int rop2 = 0;
        if (OS.IsWinCE) {
            rop2 = OS.SetROP2((int)hdc, (int)13);
            OS.SetROP2((int)hdc, (int)rop2);
        } else {
            rop2 = OS.GetROP2((int)hdc);
        }
        int dwRop = rop2 == 7 ? 5898313 : 15728673;
        OS.SetBkMode((int)hdc, (int)1);
        Rectangle clip = gc.getClipping();
        block5: for (int line = 0; line < this.runs.length; ++line) {
            int drawX = x;
            int drawY = y + this.lineY[line];
            if (this.wrapWidth != -1) {
                switch (this.alignment) {
                    case 0x1000000: {
                        drawX += (this.wrapWidth - this.lineWidth[line]) / 2;
                        break;
                    }
                    case 131072: {
                        drawX += this.wrapWidth - this.lineWidth[line];
                    }
                }
            }
            if (drawX > clip.x + clip.width || drawX + this.lineWidth[line] < clip.x) continue;
            StyleItem[] lineRuns = this.runs[line];
            int baseline = Math.max(0, this.ascent);
            for (int i = 0; i < lineRuns.length; ++i) {
                baseline = Math.max(baseline, lineRuns[i].ascent);
            }
            int lineHeight = this.lineY[line + 1] - this.lineY[line];
            int alignmentX = drawX;
            for (int i = 0; i < lineRuns.length; ++i) {
                StyleItem run = lineRuns[i];
                if (run.length == 0) continue;
                if (drawX > clip.x + clip.width) break;
                if (drawX + run.width >= clip.x && (!run.lineBreak || run.softBreak)) {
                    boolean fullSelection;
                    int end = run.start + run.length - 1;
                    boolean bl2 = fullSelection = hasSelection && selectionStart <= run.start && selectionEnd >= end;
                    if (fullSelection) {
                        OS.SelectObject((int)hdc, (int)selBrush);
                        OS.PatBlt((int)hdc, (int)drawX, (int)drawY, (int)run.width, (int)lineHeight, (int)dwRop);
                    } else {
                        boolean partialSelection;
                        if (run.style != null && run.style.background != null) {
                            int bg = run.style.background.handle;
                            int drawRunY = drawY + (baseline - run.ascent);
                            int hBrush = OS.CreateSolidBrush((int)bg);
                            int oldBrush = OS.SelectObject((int)hdc, (int)hBrush);
                            OS.PatBlt((int)hdc, (int)drawX, (int)drawRunY, (int)run.width, (int)(run.ascent + run.descent), (int)dwRop);
                            OS.SelectObject((int)hdc, (int)oldBrush);
                            OS.DeleteObject((int)hBrush);
                        }
                        boolean bl3 = partialSelection = hasSelection && selectionStart <= end && run.start <= selectionEnd;
                        if (partialSelection) {
                            OS.SelectObject((int)hdc, (int)selBrush);
                            int selStart = Math.max(selectionStart, run.start) - run.start;
                            int selEnd = Math.min(selectionEnd, end) - run.start;
                            int cChars = run.length;
                            int gGlyphs = run.glyphCount;
                            int[] piX = new int[1];
                            OS.ScriptCPtoX((int)selStart, (boolean)false, (int)cChars, (int)gGlyphs, (int)run.clusters, (int)run.visAttrs, (int)run.advances, (SCRIPT_ANALYSIS)run.analysis, (int[])piX);
                            int runX = (this.orientation & 0x4000000) != 0 ? run.width - piX[0] : piX[0];
                            rect.left = drawX + runX;
                            rect.top = drawY;
                            OS.ScriptCPtoX((int)selEnd, (boolean)true, (int)cChars, (int)gGlyphs, (int)run.clusters, (int)run.visAttrs, (int)run.advances, (SCRIPT_ANALYSIS)run.analysis, (int[])piX);
                            runX = (this.orientation & 0x4000000) != 0 ? run.width - piX[0] : piX[0];
                            rect.right = drawX + runX;
                            rect.bottom = drawY + lineHeight;
                            OS.PatBlt((int)hdc, (int)rect.left, (int)rect.top, (int)(rect.right - rect.left), (int)(rect.bottom - rect.top), (int)dwRop);
                        }
                    }
                }
                drawX += run.width;
            }
            drawX = alignmentX;
            boolean endsWithLineBreak = false;
            for (int i = 0; i < lineRuns.length; ++i) {
                StyleItem run = lineRuns[i];
                if (run.length == 0) continue;
                if (drawX > clip.x + clip.width) continue block5;
                if (drawX + run.width >= clip.x) {
                    boolean fullSelection;
                    int end = run.start + run.length - 1;
                    boolean bl4 = fullSelection = hasSelection && selectionStart <= run.start && selectionEnd >= end;
                    if (!(run.tab || run.lineBreak && !run.softBreak)) {
                        int spaceWidth;
                        int k;
                        int leftX;
                        char c;
                        boolean partialSelection;
                        int fg = foreground;
                        if (fullSelection) {
                            fg = selectionForeground.handle;
                        } else if (run.style != null && run.style.foreground != null) {
                            fg = run.style.foreground.handle;
                        }
                        OS.SetTextColor((int)hdc, (int)fg);
                        this.checkItem(hdc, run);
                        OS.SelectObject((int)hdc, (int)this.getItemFont(run));
                        int drawRunY = drawY + (baseline - run.ascent);
                        OS.ScriptTextOut((int)hdc, (int)run.psc, (int)drawX, (int)drawRunY, (int)0, null, (SCRIPT_ANALYSIS)run.analysis, (int)0, (int)0, (int)run.glyphs, (int)run.glyphCount, (int)run.advances, null, (int)run.goffsets);
                        if (run.style != null && (run.style.underline || run.style.strikeout)) {
                            int newPen = hasSelection && fg == selectionForeground.handle ? selPen : OS.CreatePen((int)0, (int)1, (int)fg);
                            int oldPen = OS.SelectObject((int)hdc, (int)newPen);
                            if (run.style.underline) {
                                int underlineY = drawY + baseline + 1;
                                OS.MoveToEx((int)hdc, (int)drawX, (int)underlineY, (int)0);
                                OS.LineTo((int)hdc, (int)(drawX + run.width), (int)underlineY);
                            }
                            if (run.style.strikeout) {
                                int strikeoutY = drawRunY + run.leading + run.ascent / 2;
                                OS.MoveToEx((int)hdc, (int)drawX, (int)strikeoutY, (int)0);
                                OS.LineTo((int)hdc, (int)(drawX + run.width), (int)strikeoutY);
                            }
                            OS.SelectObject((int)hdc, (int)oldPen);
                            if (!hasSelection || fg != selectionForeground.handle) {
                                OS.DeleteObject((int)newPen);
                            }
                        }
                        boolean bl5 = partialSelection = hasSelection && selectionStart <= end && run.start <= selectionEnd;
                        if (!fullSelection && partialSelection && fg != selectionForeground.handle) {
                            OS.SetTextColor((int)hdc, (int)selectionForeground.handle);
                            int selStart = Math.max(selectionStart, run.start) - run.start;
                            int selEnd = Math.min(selectionEnd, end) - run.start;
                            int cChars = run.length;
                            int gGlyphs = run.glyphCount;
                            int[] piX = new int[1];
                            OS.ScriptCPtoX((int)selStart, (boolean)false, (int)cChars, (int)gGlyphs, (int)run.clusters, (int)run.visAttrs, (int)run.advances, (SCRIPT_ANALYSIS)run.analysis, (int[])piX);
                            int runX = (this.orientation & 0x4000000) != 0 ? run.width - piX[0] : piX[0];
                            rect.left = drawX + runX;
                            rect.top = drawY;
                            OS.ScriptCPtoX((int)selEnd, (boolean)true, (int)cChars, (int)gGlyphs, (int)run.clusters, (int)run.visAttrs, (int)run.advances, (SCRIPT_ANALYSIS)run.analysis, (int[])piX);
                            runX = (this.orientation & 0x4000000) != 0 ? run.width - piX[0] : piX[0];
                            rect.right = drawX + runX;
                            rect.bottom = drawY + lineHeight;
                            OS.ScriptTextOut((int)hdc, (int)run.psc, (int)drawX, (int)drawRunY, (int)4, (RECT)rect, (SCRIPT_ANALYSIS)run.analysis, (int)0, (int)0, (int)run.glyphs, (int)run.glyphCount, (int)run.advances, null, (int)run.goffsets);
                            if (run.style != null && (run.style.underline || run.style.strikeout)) {
                                int oldPen = OS.SelectObject((int)hdc, (int)selPen);
                                if (run.style.underline) {
                                    int underlineY = drawY + baseline + 1;
                                    OS.MoveToEx((int)hdc, (int)rect.left, (int)underlineY, (int)0);
                                    OS.LineTo((int)hdc, (int)rect.right, (int)underlineY);
                                }
                                if (run.style.strikeout) {
                                    int strikeoutY = drawRunY + run.leading + run.ascent / 2;
                                    OS.MoveToEx((int)hdc, (int)rect.left, (int)strikeoutY, (int)0);
                                    OS.LineTo((int)hdc, (int)rect.right, (int)strikeoutY);
                                }
                                OS.SelectObject((int)hdc, (int)oldPen);
                            }
                        }
                        if (ccRender.isDrawFullWidthSpace()) {
                            String runText = this.segmentsText.substring(run.start, run.start + run.length);
                            int fullSpace = 12288;
                            if (runText.indexOf(12288) != -1) {
                                int[] charWidths = new int[run.length];
                                OS.ScriptGetLogicalWidths((SCRIPT_ANALYSIS)run.analysis, (int)run.length, (int)run.glyphCount, (int)run.advances, (int)run.clusters, (int)run.visAttrs, (int[])charWidths);
                                char[] chars = runText.toCharArray();
                                for (int j = 0; j < chars.length; ++j) {
                                    c = chars[j];
                                    if (c != '\u3000') continue;
                                    leftX = drawX;
                                    for (k = 0; k < j; ++k) {
                                        leftX += charWidths[k];
                                    }
                                    spaceWidth = charWidths[j];
                                    ccRender.drawFullWidthSpace(leftX, drawY, lineHeight, spaceWidth);
                                }
                            }
                        }
                        if (ccRender.isDrawHalfWidthSpace()) {
                            String runText = this.segmentsText.substring(run.start, run.start + run.length);
                            int halfSpace = 32;
                            if (runText.indexOf(32) != -1) {
                                int[] charWidths = new int[run.length];
                                OS.ScriptGetLogicalWidths((SCRIPT_ANALYSIS)run.analysis, (int)run.length, (int)run.glyphCount, (int)run.advances, (int)run.clusters, (int)run.visAttrs, (int[])charWidths);
                                char[] chars = runText.toCharArray();
                                for (int j = 0; j < chars.length; ++j) {
                                    c = chars[j];
                                    if (c != ' ') continue;
                                    leftX = drawX;
                                    for (k = 0; k < j; ++k) {
                                        leftX += charWidths[k];
                                    }
                                    spaceWidth = charWidths[j];
                                    ccRender.drawHalfWidthSpace(leftX, drawY, lineHeight, spaceWidth);
                                }
                            }
                        }
                    } else if (run.tab && ccRender.isDrawTab()) {
                        ccRender.drawTab(drawX, drawY, lineHeight);
                    }
                }
                endsWithLineBreak = run.lineBreak && !run.softBreak;
                drawX += run.width;
            }
        }
        OS.RestoreDC((int)hdc, (int)state);
        if (selBrush != 0) {
            OS.DeleteObject((int)selBrush);
        }
        if (selPen != 0) {
            OS.DeleteObject((int)selPen);
        }
    }

    void freeRuns() {
        if (this.allRuns == null) {
            return;
        }
        for (int i = 0; i < this.allRuns.length; ++i) {
            StyleItem run = this.allRuns[i];
            run.free();
        }
        this.allRuns = null;
        this.runs = null;
        this.segmentsText = null;
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns(null);
        int width = 0;
        if (this.wrapWidth != -1) {
            width = this.wrapWidth;
        } else {
            for (int line = 0; line < this.runs.length; ++line) {
                width = Math.max(width, this.lineWidth[line]);
            }
        }
        return new Rectangle(0, 0, width, this.lineY[this.lineY.length - 1]);
    }

    public Rectangle getBounds(int start, int end) {
        this.checkLayout();
        this.computeRuns(null);
        int length = this.text.length();
        if (length == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (start > end) {
            return new Rectangle(0, 0, 0, 0);
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        start = this.translateOffset(start);
        end = this.translateOffset(end);
        int left = Integer.MAX_VALUE;
        int right = 0;
        int top = Integer.MAX_VALUE;
        int bottom = 0;
        int lineIndex = 0;
        boolean isRTL = (this.orientation & 0x4000000) != 0;
        for (int i = 0; i < this.allRuns.length - 1; ++i) {
            int[] piX;
            int cx;
            StyleItem run = this.allRuns[i];
            int runEnd = run.start + run.length;
            if (run.lineBreak) {
                ++lineIndex;
            }
            if (runEnd <= start) continue;
            if (run.start > end) break;
            int runLead = run.x;
            int runTrail = run.x + run.width;
            if (run.start <= start && start < runEnd) {
                cx = 0;
                if (!run.tab) {
                    piX = new int[1];
                    OS.ScriptCPtoX((int)(start - run.start), (boolean)false, (int)run.length, (int)run.glyphCount, (int)run.clusters, (int)run.visAttrs, (int)run.advances, (SCRIPT_ANALYSIS)run.analysis, (int[])piX);
                    int n = cx = isRTL ? run.width - piX[0] : piX[0];
                }
                if (run.analysis.fRTL ^ isRTL) {
                    runTrail = run.x + cx;
                } else {
                    runLead = run.x + cx;
                }
            }
            if (run.start <= end && end < runEnd) {
                cx = run.width;
                if (!run.tab) {
                    piX = new int[1];
                    OS.ScriptCPtoX((int)(end - run.start), (boolean)true, (int)run.length, (int)run.glyphCount, (int)run.clusters, (int)run.visAttrs, (int)run.advances, (SCRIPT_ANALYSIS)run.analysis, (int[])piX);
                    int n = cx = isRTL ? run.width - piX[0] : piX[0];
                }
                if (run.analysis.fRTL ^ isRTL) {
                    runLead = run.x + cx;
                } else {
                    runTrail = run.x + cx;
                }
            }
            left = Math.min(left, runLead);
            right = Math.max(right, runTrail);
            top = Math.min(top, this.lineY[run.lineBreak ? lineIndex - 1 : lineIndex]);
            bottom = Math.max(bottom, this.lineY[run.lineBreak ? lineIndex : lineIndex + 1]);
        }
        return new Rectangle(left, top, right - left, bottom - top);
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    int getItemFont(StyleItem item) {
        if (item.fallbackFont != 0) {
            return item.fallbackFont;
        }
        if (item.style != null && item.style.font != null) {
            return item.style.font.handle;
        }
        if (this.font != null) {
            return this.font.handle;
        }
        return this.device.systemFont;
    }

    public int getLevel(int offset) {
        this.checkLayout();
        this.computeRuns(null);
        int length = this.text.length();
        if (0 > offset || offset > length) {
            SWT.error((int)6);
        }
        offset = this.translateOffset(offset);
        for (int i = 1; i < this.allRuns.length; ++i) {
            if (this.allRuns[i].start <= offset) continue;
            return this.allRuns[i - 1].analysis.s.uBidiLevel;
        }
        return (this.orientation & 0x4000000) != 0 ? 1 : 0;
    }

    public Rectangle getLineBounds(int lineIndex) {
        this.checkLayout();
        this.computeRuns(null);
        if (0 > lineIndex || lineIndex >= this.runs.length) {
            SWT.error((int)6);
        }
        int x = 0;
        int y = this.lineY[lineIndex];
        int width = this.lineWidth[lineIndex];
        int height = this.lineY[lineIndex + 1] - y;
        if (this.wrapWidth != -1) {
            switch (this.alignment) {
                case 0x1000000: {
                    x = (this.wrapWidth - width) / 2;
                    break;
                }
                case 131072: {
                    x = this.wrapWidth - width;
                }
            }
        }
        return new Rectangle(x, y, width, height);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns(null);
        return this.runs.length;
    }

    public int getLineIndex(int offset) {
        this.checkLayout();
        this.computeRuns(null);
        int length = this.text.length();
        if (0 > offset || offset > length) {
            SWT.error((int)6);
        }
        offset = this.translateOffset(offset);
        for (int line = 0; line < this.runs.length; ++line) {
            if (this.lineOffset[line + 1] <= offset) continue;
            return line;
        }
        return this.runs.length - 1;
    }

    public FontMetrics getLineMetrics(int lineIndex) {
        TEXTMETRICW lptm;
        this.checkLayout();
        this.computeRuns(null);
        if (0 > lineIndex || lineIndex >= this.runs.length) {
            SWT.error((int)6);
        }
        int hDC = this.device.internal_new_GC(null);
        int srcHdc = OS.CreateCompatibleDC((int)hDC);
        Object object = lptm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        if (this.text.length() == 0) {
            OS.SelectObject((int)srcHdc, (int)(this.font != null ? this.font.handle : this.device.systemFont));
            OS.GetTextMetrics((int)srcHdc, (TEXTMETRIC)lptm);
            lptm.tmAscent = Math.max(lptm.tmAscent, this.ascent);
            lptm.tmDescent = Math.max(lptm.tmDescent, this.descent);
        } else {
            int ascent = this.ascent;
            int descent = this.descent;
            int leading = 0;
            int aveCharWidth = 0;
            int height = 0;
            StyleItem[] lineRuns = this.runs[lineIndex];
            for (int i = 0; i < lineRuns.length; ++i) {
                StyleItem run = lineRuns[i];
                this.checkItem(srcHdc, run);
                OS.SelectObject((int)srcHdc, (int)this.getItemFont(run));
                OS.GetTextMetrics((int)srcHdc, (TEXTMETRIC)lptm);
                ascent = Math.max(ascent, lptm.tmAscent);
                descent = Math.max(descent, lptm.tmDescent);
                height = Math.max(height, lptm.tmHeight);
                leading = Math.max(leading, lptm.tmInternalLeading);
                aveCharWidth += lptm.tmAveCharWidth;
            }
            lptm.tmAscent = ascent;
            lptm.tmDescent = descent;
            lptm.tmHeight = height;
            lptm.tmInternalLeading = leading;
            lptm.tmAveCharWidth = aveCharWidth / lineRuns.length;
        }
        if (srcHdc != 0) {
            OS.DeleteDC((int)srcHdc);
        }
        this.device.internal_dispose_GC(hDC, null);
        return FontMetrics.win32_new((TEXTMETRIC)lptm);
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns(null);
        int[] offsets = new int[this.lineOffset.length];
        for (int i = 0; i < offsets.length; ++i) {
            offsets[i] = this.untranslateOffset(this.lineOffset[i]);
        }
        return offsets;
    }

    public Point getLocation(int offset, boolean trailing) {
        int line;
        this.checkLayout();
        this.computeRuns(null);
        int length = this.text.length();
        if (0 > offset || offset > length) {
            SWT.error((int)6);
        }
        length = this.segmentsText.length();
        offset = this.translateOffset(offset);
        for (line = 0; line < this.runs.length && this.lineOffset[line + 1] <= offset; ++line) {
        }
        line = Math.min(line, this.runs.length - 1);
        StyleItem[] lineRuns = this.runs[line];
        Point result = null;
        if (offset == length) {
            result = new Point(this.lineWidth[line], this.lineY[line]);
        } else {
            int width = 0;
            for (int i = 0; i < lineRuns.length; ++i) {
                StyleItem run = lineRuns[i];
                int end = run.start + run.length;
                if (run.start <= offset && offset < end) {
                    if (run.tab) {
                        if (trailing || offset == length) {
                            width += run.width;
                        }
                        result = new Point(width, this.lineY[line]);
                        break;
                    }
                    int runOffset = offset - run.start;
                    int cChars = run.length;
                    int gGlyphs = run.glyphCount;
                    int[] piX = new int[1];
                    OS.ScriptCPtoX((int)runOffset, (boolean)trailing, (int)cChars, (int)gGlyphs, (int)run.clusters, (int)run.visAttrs, (int)run.advances, (SCRIPT_ANALYSIS)run.analysis, (int[])piX);
                    if ((this.orientation & 0x4000000) != 0) {
                        result = new Point(width + (run.width - piX[0]), this.lineY[line]);
                        break;
                    }
                    result = new Point(width + piX[0], this.lineY[line]);
                    break;
                }
                width += run.width;
            }
        }
        if (result == null) {
            result = new Point(0, 0);
        }
        if (this.wrapWidth != -1) {
            switch (this.alignment) {
                case 0x1000000: {
                    result.x += (this.wrapWidth - this.lineWidth[line]) / 2;
                    break;
                }
                case 131072: {
                    result.x += this.wrapWidth - this.lineWidth[line];
                }
            }
        }
        return result;
    }

    public int getNextOffset(int offset, int movement) {
        this.checkLayout();
        return this._getOffset(offset, movement, true);
    }

    int _getOffset(int offset, int movement, boolean forward) {
        int step;
        this.computeRuns(null);
        int length = this.text.length();
        if (0 > offset || offset > length) {
            SWT.error((int)6);
        }
        if (forward && offset == length) {
            return length;
        }
        if (!forward && offset == 0) {
            return 0;
        }
        int n = step = forward ? 1 : -1;
        if ((movement & 1) != 0) {
            return offset + step;
        }
        length = this.segmentsText.length();
        offset = this.translateOffset(offset);
        SCRIPT_LOGATTR logAttr = new SCRIPT_LOGATTR();
        SCRIPT_PROPERTIES properties = new SCRIPT_PROPERTIES();
        int i = forward ? 0 : this.allRuns.length - 1;
        offset = this.validadeOffset(offset, step);
        do {
            boolean isComplex;
            StyleItem run = this.allRuns[i];
            if (run.start > offset || offset >= run.start + run.length) continue;
            if (run.lineBreak && !run.softBreak) {
                return this.untranslateOffset(run.start);
            }
            if (run.tab) {
                return this.untranslateOffset(run.start);
            }
            OS.MoveMemory((SCRIPT_PROPERTIES)properties, (int)this.device.scripts[run.analysis.eScript], (int)8);
            boolean bl = isComplex = properties.fNeedsCaretInfo || properties.fNeedsWordBreaking;
            if (isComplex) {
                this.breakRun(run);
            }
            while (run.start <= offset && offset < run.start + run.length) {
                if (isComplex) {
                    OS.MoveMemory((SCRIPT_LOGATTR)logAttr, (int)(run.psla + (offset - run.start) * 1), (int)1);
                }
                switch (movement) {
                    case 2: {
                        if (properties.fNeedsCaretInfo) {
                            if (logAttr.fInvalid || !logAttr.fCharStop) break;
                            return this.untranslateOffset(offset);
                        }
                        return this.untranslateOffset(offset);
                    }
                    case 4: {
                        boolean previousLetterOrDigit;
                        boolean letterOrDigit;
                        if (!(properties.fNeedsWordBreaking ? !logAttr.fInvalid && logAttr.fWordStop : offset > 0 && ((letterOrDigit = Compatibility.isLetterOrDigit((char)this.segmentsText.charAt(offset))) != (previousLetterOrDigit = Compatibility.isLetterOrDigit((char)this.segmentsText.charAt(offset - 1))) || !letterOrDigit) && !Compatibility.isWhitespace((char)this.segmentsText.charAt(offset)))) break;
                        return this.untranslateOffset(offset);
                    }
                }
                offset = this.validadeOffset(offset, step);
            }
        } while (0 <= (i += step) && i < this.allRuns.length - 1 && 0 <= offset && offset < length);
        return forward ? this.text.length() : 0;
    }

    public int getOffset(Point point, int[] trailing) {
        this.checkLayout();
        if (point == null) {
            SWT.error((int)4);
        }
        return this.getOffset(point.x, point.y, trailing);
    }

    public int getOffset(int x, int y, int[] trailing) {
        int line;
        this.checkLayout();
        this.computeRuns(null);
        if (trailing != null && trailing.length < 1) {
            SWT.error((int)5);
        }
        int lineCount = this.runs.length;
        for (line = 0; line < lineCount && this.lineY[line + 1] <= y; ++line) {
        }
        line = Math.min(line, this.runs.length - 1);
        if (this.wrapWidth != -1) {
            switch (this.alignment) {
                case 0x1000000: {
                    x -= (this.wrapWidth - this.lineWidth[line]) / 2;
                    break;
                }
                case 131072: {
                    x -= this.wrapWidth - this.lineWidth[line];
                }
            }
        }
        StyleItem[] lineRuns = this.runs[line];
        if (x >= this.lineWidth[line]) {
            x = this.lineWidth[line] - 1;
        }
        if (x < 0) {
            x = 0;
        }
        int width = 0;
        for (int i = 0; i < lineRuns.length; ++i) {
            StyleItem run = lineRuns[i];
            if (run.lineBreak && !run.softBreak) {
                return this.untranslateOffset(run.start);
            }
            if (width + run.width > x) {
                if (run.tab) {
                    if (trailing != null) {
                        trailing[0] = x < width + run.width / 2 ? 0 : 1;
                    }
                    return this.untranslateOffset(run.start);
                }
                int cChars = run.length;
                int cGlyphs = run.glyphCount;
                int xRun = x - width;
                int[] piCP = new int[1];
                int[] piTrailing = new int[1];
                if ((this.orientation & 0x4000000) != 0) {
                    xRun = run.width - xRun;
                }
                OS.ScriptXtoCP((int)xRun, (int)cChars, (int)cGlyphs, (int)run.clusters, (int)run.visAttrs, (int)run.advances, (SCRIPT_ANALYSIS)run.analysis, (int[])piCP, (int[])piTrailing);
                if (trailing != null) {
                    trailing[0] = piTrailing[0];
                }
                return this.untranslateOffset(run.start + piCP[0]);
            }
            width += run.width;
        }
        if (trailing != null) {
            trailing[0] = 0;
        }
        return this.untranslateOffset(this.lineOffset[line + 1]);
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    public int getPreviousOffset(int offset, int movement) {
        this.checkLayout();
        return this._getOffset(offset, movement, false);
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    String getSegmentsText() {
        int separator;
        if (this.segments == null) {
            return this.text;
        }
        int nSegments = this.segments.length;
        if (nSegments <= 1) {
            return this.text;
        }
        int length = this.text.length();
        if (length == 0) {
            return this.text;
        }
        if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
            return this.text;
        }
        char[] oldChars = new char[length];
        this.text.getChars(0, length, oldChars, 0);
        char[] newChars = new char[length + nSegments];
        int charCount = 0;
        int segmentCount = 0;
        int n = separator = this.orientation == 0x4000000 ? 8207 : 8206;
        while (charCount < length) {
            if (segmentCount < nSegments && charCount == this.segments[segmentCount]) {
                newChars[charCount + segmentCount++] = separator;
                continue;
            }
            newChars[charCount + segmentCount] = oldChars[charCount++];
        }
        if (segmentCount < nSegments) {
            this.segments[segmentCount] = charCount;
            newChars[charCount + segmentCount++] = separator;
        }
        return new String(newChars, 0, Math.min(charCount + segmentCount, newChars.length));
    }

    public int getSpacing() {
        this.checkLayout();
        return this.lineSpacing;
    }

    public TextStyle getStyle(int offset) {
        this.checkLayout();
        int length = this.text.length();
        if (0 > offset || offset >= length) {
            SWT.error((int)6);
        }
        for (int i = 1; i < this.styles.length; ++i) {
            if (this.styles[i].start <= offset) continue;
            return this.styles[i - 1].style;
        }
        return null;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    StyleItem[] itemize() {
        this.segmentsText = this.getSegmentsText();
        int length = this.segmentsText.length();
        SCRIPT_CONTROL scriptControl = new SCRIPT_CONTROL();
        SCRIPT_STATE scriptState = new SCRIPT_STATE();
        int MAX_ITEM = length + 1;
        if ((this.orientation & 0x4000000) != 0) {
            scriptState.uBidiLevel = 1;
            scriptState.fArabicNumContext = true;
        }
        int hHeap = OS.GetProcessHeap();
        int pItems = OS.HeapAlloc((int)hHeap, (int)8, (int)(MAX_ITEM * 8));
        int[] pcItems = new int[1];
        char[] chars = new char[length];
        this.segmentsText.getChars(0, length, chars, 0);
        OS.ScriptItemize((char[])chars, (int)length, (int)MAX_ITEM, (SCRIPT_CONTROL)scriptControl, (SCRIPT_STATE)scriptState, (int)pItems, (int[])pcItems);
        StyleItem[] runs = this.merge(pItems, pcItems[0]);
        OS.HeapFree((int)hHeap, (int)0, (int)pItems);
        return runs;
    }

    StyleItem[] merge(int items, int itemCount) {
        StyleItem item;
        int count = 0;
        int start = 0;
        int end = this.segmentsText.length();
        int itemIndex = 0;
        int styleIndex = 0;
        StyleItem[] runs = new StyleItem[itemCount + this.styles.length];
        SCRIPT_ITEM scriptItem = new SCRIPT_ITEM();
        while (start < end) {
            item = new StyleItem();
            item.start = start;
            item.style = this.styles[styleIndex].style;
            runs[count++] = item;
            OS.MoveMemory((SCRIPT_ITEM)scriptItem, (int)(items + itemIndex * 8), (int)8);
            item.analysis = scriptItem.a;
            scriptItem.a = new SCRIPT_ANALYSIS();
            OS.MoveMemory((SCRIPT_ITEM)scriptItem, (int)(items + (itemIndex + 1) * 8), (int)8);
            int itemLimit = scriptItem.iCharPos;
            int styleLimit = this.translateOffset(this.styles[styleIndex + 1].start);
            if (styleLimit <= itemLimit) {
                ++styleIndex;
                start = styleLimit;
            }
            if (itemLimit <= styleLimit) {
                ++itemIndex;
                start = itemLimit;
            }
            item.length = start - item.start;
        }
        item = new StyleItem();
        item.start = end;
        OS.MoveMemory((SCRIPT_ITEM)scriptItem, (int)(items + itemCount * 8), (int)8);
        item.analysis = scriptItem.a;
        runs[count++] = item;
        if (runs.length != count) {
            StyleItem[] result = new StyleItem[count];
            System.arraycopy(runs, 0, result, 0, count);
            return result;
        }
        return runs;
    }

    StyleItem[] reorder(StyleItem[] runs) {
        int i;
        int length = runs.length;
        if (length <= 1) {
            return runs;
        }
        byte[] bidiLevels = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            bidiLevels[i2] = (byte)(runs[i2].analysis.s.uBidiLevel & 0x1F);
        }
        StyleItem lastRun = runs[length - 1];
        if (lastRun.lineBreak && !lastRun.softBreak) {
            bidiLevels[length - 1] = 0;
        }
        int[] log2vis = new int[length];
        OS.ScriptLayout((int)length, (byte[])bidiLevels, null, (int[])log2vis);
        StyleItem[] result = new StyleItem[length];
        for (i = 0; i < length; ++i) {
            result[log2vis[i]] = runs[i];
        }
        if ((this.orientation & 0x4000000) != 0) {
            for (i = 0; i < (length - 1) / 2; ++i) {
                StyleItem tmp = result[i];
                result[i] = result[length - i - 2];
                result[length - i - 2] = tmp;
            }
        }
        return result;
    }

    public void setAlignment(int alignment) {
        this.checkLayout();
        int mask = 16924672;
        if ((alignment &= mask) == 0) {
            return;
        }
        if ((alignment & 0x4000) != 0) {
            alignment = 16384;
        }
        if ((alignment & 0x20000) != 0) {
            alignment = 131072;
        }
        this.alignment = alignment;
    }

    public void setAscent(int ascent) {
        this.checkLayout();
        if (ascent < -1) {
            SWT.error((int)5);
        }
        if (this.ascent == ascent) {
            return;
        }
        this.freeRuns();
        this.ascent = ascent;
    }

    public void setDescent(int descent) {
        this.checkLayout();
        if (descent < -1) {
            SWT.error((int)5);
        }
        if (this.descent == descent) {
            return;
        }
        this.freeRuns();
        this.descent = descent;
    }

    public void setFont(Font font) {
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error((int)5);
        }
        if (this.font == font) {
            return;
        }
        if (font != null && font.equals((Object)this.font)) {
            return;
        }
        this.freeRuns();
        this.font = font;
    }

    public void setOrientation(int orientation) {
        this.checkLayout();
        int mask = 0x6000000;
        if ((orientation &= mask) == 0) {
            return;
        }
        if ((orientation & 0x2000000) != 0) {
            orientation = 0x2000000;
        }
        if (this.orientation == orientation) {
            return;
        }
        this.orientation = orientation;
        this.freeRuns();
    }

    public void setSegments(int[] segments) {
        this.checkLayout();
        if (this.segments == null && segments == null) {
            return;
        }
        if (this.segments != null && segments != null && this.segments.length == segments.length) {
            int i;
            for (i = 0; i < segments.length && this.segments[i] == segments[i]; ++i) {
            }
            if (i == segments.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = segments;
    }

    public void setSpacing(int spacing) {
        this.checkLayout();
        if (spacing < 0) {
            SWT.error((int)5);
        }
        if (this.lineSpacing == spacing) {
            return;
        }
        this.freeRuns();
        this.lineSpacing = spacing;
    }

    public void setStyle(TextStyle style, int start, int end) {
        StyleItem item;
        int i;
        this.checkLayout();
        int length = this.text.length();
        if (length == 0) {
            return;
        }
        if (start > end) {
            return;
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        int low = -1;
        int high = this.styles.length;
        while (high - low > 1) {
            int index = (high + low) / 2;
            if (start <= this.styles[index].start) {
                high = index;
                continue;
            }
            low = index;
        }
        if (0 <= high && high < this.styles.length) {
            StyleItem item2 = this.styles[high];
            if (item2.start == start && this.styles[high + 1].start - 1 == end && (style == null ? item2.style == null : style.equals((Object)item2.style))) {
                return;
            }
        }
        this.freeRuns();
        int count = 0;
        StyleItem[] newStyles = new StyleItem[this.styles.length + 2];
        for (i = 0; i < this.styles.length; ++i) {
            StyleItem item3 = this.styles[i];
            if (item3.start >= start) break;
            newStyles[count++] = item3;
        }
        StyleItem newItem = new StyleItem();
        newItem.start = start;
        newItem.style = style;
        newStyles[count++] = newItem;
        if (this.styles[i].start > end) {
            newItem = new StyleItem();
            newItem.start = end + 1;
            newItem.style = this.styles[i - 1].style;
            newStyles[count++] = newItem;
        } else {
            while (i < this.styles.length) {
                item = this.styles[i];
                if (item.start > end) break;
                ++i;
            }
            if (end != this.styles[i].start - 1) {
                this.styles[--i].start = end + 1;
            }
        }
        while (i < this.styles.length) {
            item = this.styles[i];
            if (item.start > end) {
                newStyles[count++] = item;
            }
            ++i;
        }
        if (newStyles.length != count) {
            this.styles = new StyleItem[count];
            System.arraycopy(newStyles, 0, this.styles, 0, count);
        } else {
            this.styles = newStyles;
        }
    }

    public void setTabs(int[] tabs) {
        this.checkLayout();
        if (this.tabs == null && tabs == null) {
            return;
        }
        if (this.tabs != null && tabs != null && this.tabs.length == tabs.length) {
            int i;
            for (i = 0; i < tabs.length && this.tabs[i] == tabs[i]; ++i) {
            }
            if (i == tabs.length) {
                return;
            }
        }
        this.freeRuns();
        this.tabs = tabs;
    }

    public void setText(String text) {
        this.checkLayout();
        if (text == null) {
            SWT.error((int)4);
        }
        if (text.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = text;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = text.length();
    }

    public void setWidth(int width) {
        this.checkLayout();
        if (width < -1 || width == 0) {
            SWT.error((int)5);
        }
        if (this.wrapWidth == width) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = width;
    }

    boolean shape(int hdc, StyleItem run, char[] chars, int[] glyphCount, int maxGlyphs) {
        int hr = OS.ScriptShape((int)hdc, (int)run.psc, (char[])chars, (int)chars.length, (int)maxGlyphs, (SCRIPT_ANALYSIS)run.analysis, (int)run.glyphs, (int)run.clusters, (int)run.visAttrs, (int[])glyphCount);
        run.glyphCount = glyphCount[0];
        if (hr != -2147220992) {
            int i;
            SCRIPT_FONTPROPERTIES fp = new SCRIPT_FONTPROPERTIES();
            fp.cBytes = 16;
            OS.ScriptGetFontProperties((int)hdc, (int)run.psc, (SCRIPT_FONTPROPERTIES)fp);
            short[] glyphs = new short[glyphCount[0]];
            OS.MoveMemory((short[])glyphs, (int)run.glyphs, (int)(glyphs.length * 2));
            for (i = 0; i < glyphs.length && glyphs[i] != fp.wgDefault; ++i) {
            }
            if (i == glyphs.length) {
                return true;
            }
        }
        if (run.psc != 0) {
            OS.ScriptFreeCache((int)run.psc);
            glyphCount[0] = 0;
            OS.MoveMemory((int)run.psc, (int[])glyphCount, (int)4);
        }
        run.glyphCount = 0;
        return false;
    }

    void shape(int hdc, StyleItem run) {
        int[] buffer = new int[1];
        char[] chars = new char[run.length];
        this.segmentsText.getChars(run.start, run.start + run.length, chars, 0);
        int maxGlyphs = chars.length * 3 / 2 + 16;
        int hHeap = OS.GetProcessHeap();
        run.glyphs = OS.HeapAlloc((int)hHeap, (int)8, (int)(maxGlyphs * 2));
        run.clusters = OS.HeapAlloc((int)hHeap, (int)8, (int)(maxGlyphs * 2));
        run.visAttrs = OS.HeapAlloc((int)hHeap, (int)8, (int)(maxGlyphs * 2));
        run.psc = OS.HeapAlloc((int)hHeap, (int)8, (int)4);
        if (!this.shape(hdc, run, chars, buffer, maxGlyphs) && this.mLangFontLink2 != 0) {
            int[] dwCodePages = new int[1];
            int[] cchCodePages = new int[1];
            OS.VtblCall((int)4, (int)this.mLangFontLink2, (char[])chars, (int)chars.length, (int)0, (int[])dwCodePages, (int[])cchCodePages);
            int[] hNewFont = new int[1];
            if (OS.VtblCall((int)10, (int)this.mLangFontLink2, (int)hdc, (int)dwCodePages[0], (int)chars[0], (int[])hNewFont) == 0) {
                int hFont = OS.SelectObject((int)hdc, (int)hNewFont[0]);
                if (this.shape(hdc, run, chars, buffer, maxGlyphs)) {
                    run.fallbackFont = hNewFont[0];
                } else {
                    OS.VtblCall((int)8, (int)this.mLangFontLink2, (int)hNewFont[0]);
                    OS.SelectObject((int)hdc, (int)hFont);
                    OS.ScriptShape((int)hdc, (int)run.psc, (char[])chars, (int)chars.length, (int)maxGlyphs, (SCRIPT_ANALYSIS)run.analysis, (int)run.glyphs, (int)run.clusters, (int)run.visAttrs, (int[])buffer);
                    run.glyphCount = buffer[0];
                }
            }
        }
        int[] abc = new int[3];
        run.advances = OS.HeapAlloc((int)hHeap, (int)8, (int)(run.glyphCount * 4));
        run.goffsets = OS.HeapAlloc((int)hHeap, (int)8, (int)(run.glyphCount * 8));
        OS.ScriptPlace((int)hdc, (int)run.psc, (int)run.glyphs, (int)run.glyphCount, (int)run.visAttrs, (SCRIPT_ANALYSIS)run.analysis, (int)run.advances, (int)run.goffsets, (int[])abc);
        run.width = abc[0] + abc[1] + abc[2];
        TEXTMETRICW lptm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics((int)hdc, (TEXTMETRIC)lptm);
        run.ascent = lptm.tmAscent;
        run.descent = lptm.tmDescent;
        run.leading = lptm.tmInternalLeading;
    }

    int validadeOffset(int offset, int step) {
        offset += step;
        if (this.segments != null && this.segments.length > 2) {
            for (int i = 0; i < this.segments.length; ++i) {
                if (this.translateOffset(this.segments[i]) - 1 != offset) continue;
                offset += step;
                break;
            }
        }
        return offset;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {}";
    }

    int translateOffset(int offset) {
        if (this.segments == null) {
            return offset;
        }
        int nSegments = this.segments.length;
        if (nSegments <= 1) {
            return offset;
        }
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
            return offset;
        }
        for (int i = 0; i < nSegments && offset - i >= this.segments[i]; ++i) {
            ++offset;
        }
        return offset;
    }

    int untranslateOffset(int offset) {
        if (this.segments == null) {
            return offset;
        }
        int nSegments = this.segments.length;
        if (nSegments <= 1) {
            return offset;
        }
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
            return offset;
        }
        for (int i = 0; i < nSegments && offset > this.segments[i]; --offset, ++i) {
        }
        return offset;
    }

    void forceMonospace(int srcHdc, StyleItem run) {
        if (run.style == null) {
            return;
        }
        StyleItem dummyRun = new StyleItem();
        dummyRun.style = new TextStyle(this.font, run.style.foreground, run.style.background);
        dummyRun.analysis = run.analysis;
        dummyRun.start = run.start;
        dummyRun.length = run.length;
        OS.SelectObject((int)srcHdc, (int)this.font.handle);
        this.shape(srcHdc, dummyRun);
        int temp = run.advances;
        run.advances = dummyRun.advances;
        dummyRun.advances = temp;
        temp = run.goffsets;
        run.goffsets = dummyRun.goffsets;
        dummyRun.goffsets = temp;
        run.width = dummyRun.width;
        dummyRun.free();
    }

    static {
        OS.IIDFromString((char[])"{275c23e2-3747-11d0-9fea-00aa003f8646}\u0000".toCharArray(), (byte[])CLSID_CMultiLanguage);
        OS.IIDFromString((char[])"{DCCFC162-2B38-11d2-B7EC-00C04F8F5D9A}\u0000".toCharArray(), (byte[])IID_IMLangFontLink2);
    }

    public static class JStyleSWTBridge {
        public static volatile RGB lineBreakRGB;
        public static volatile RGB tabRGB;
        public static volatile RGB fullWidthSpaceRGB;
        public static volatile RGB halfWidthSpaceRGB;
        public static volatile boolean forceMonospace;

        static class JStyle {
            final Color lineBreakColor;
            final Color tabColor;
            final Color fullWidthSpaceColor;
            final Color halfWidthSpaceColor;

            JStyle(Device device) {
                this.lineBreakColor = this.createColor(device, lineBreakRGB);
                this.tabColor = this.createColor(device, tabRGB);
                this.fullWidthSpaceColor = this.createColor(device, fullWidthSpaceRGB);
                this.halfWidthSpaceColor = this.createColor(device, halfWidthSpaceRGB);
            }

            Color createColor(Device device, RGB rgb) {
                return rgb == null ? null : new Color(device, rgb);
            }
        }
    }

    public static class NullControlCharRenderer
    extends ControlCharRenderer {
        private static final ControlCharRenderer singleton = new NullControlCharRenderer();

        public static ControlCharRenderer getInstance() {
            return singleton;
        }

        private NullControlCharRenderer() {
        }

        public void setLineDelimiter(String lineDelimiter) {
        }

        void init(GC gc, Device device) {
        }

        boolean isDrawLineBreak() {
            return false;
        }

        boolean isDrawTab() {
            return false;
        }

        boolean isDrawFullWidthSpace() {
            return false;
        }

        boolean isDrawHalfWidthSpace() {
            return false;
        }

        void drawLineBreak(int x, int y, int lineHeight) {
        }

        void drawTab(int x, int y, int lineHeight) {
        }

        void drawFullWidthSpace(int x, int y, int lineHeight, int spaceWidth) {
        }

        void drawHalfWidthSpace(int x, int y, int lineHeight, int spaceWidth) {
        }
    }

    public static class ControlCharRenderer {
        private JStyleSWTBridge.JStyle jStyle;
        private String lineDelimiter;
        private GC gc;
        private Color originColor;

        public void setLineDelimiter(String lineDelimiter) {
            this.lineDelimiter = lineDelimiter;
        }

        void init(GC gc, Device device) {
            this.jStyle = new JStyleSWTBridge.JStyle(device);
            this.gc = gc;
            this.originColor = gc.getForeground();
        }

        boolean isDrawLineBreak() {
            return this.jStyle.lineBreakColor != null;
        }

        boolean isDrawTab() {
            return this.jStyle.tabColor != null;
        }

        boolean isDrawFullWidthSpace() {
            return this.jStyle.fullWidthSpaceColor != null;
        }

        boolean isDrawHalfWidthSpace() {
            return this.jStyle.halfWidthSpaceColor != null;
        }

        void drawLineBreak(int x, int y, int lineHeight) {
            if (this.lineDelimiter == null || this.lineDelimiter.length() == 0) {
                return;
            }
            int lastX = x + 1;
            int underY = y + lineHeight - 1;
            int pt = lineHeight / 8;
            this.gc.setForeground(this.jStyle.lineBreakColor);
            if (this.lineDelimiter.equals("\n")) {
                this.gc.drawLine(lastX + pt * 2, y + pt * 2, lastX + pt * 2, underY - pt * 2);
                this.gc.drawLine(lastX + pt * 0, underY - pt * 4, lastX + pt * 2, underY - pt * 2);
                this.gc.drawLine(lastX + pt * 4, underY - pt * 4, lastX + pt * 2, underY - pt * 2);
            } else if (this.lineDelimiter.equals("\r\n")) {
                this.gc.drawLine(lastX + pt * 5, y + pt * 2, lastX + pt * 5, underY - pt * 3);
                this.gc.drawLine(lastX + pt * 0, underY - pt * 3, lastX + pt * 5, underY - pt * 3);
                this.gc.drawLine(lastX + pt * 0, underY - pt * 3, lastX + pt * 2, underY - pt * 5);
                this.gc.drawLine(lastX + pt * 0, underY - pt * 3, lastX + pt * 2, underY - pt * 1);
            } else {
                this.gc.drawLine(lastX + pt * 0, underY - pt * 4, lastX + pt * 6, underY - pt * 4);
                this.gc.drawLine(lastX + pt * 0, underY - pt * 4, lastX + pt * 2, underY - pt * 6);
                this.gc.drawLine(lastX + pt * 0, underY - pt * 4, lastX + pt * 2, underY - pt * 2);
            }
            this.gc.setForeground(this.originColor);
        }

        void drawTab(int x, int y, int lineHeight) {
            int pt = lineHeight / 8;
            int leftX = x + 1;
            this.gc.setForeground(this.jStyle.tabColor);
            this.gc.drawLine(leftX + pt * 0, y + pt * 4, leftX + pt * 2, y + pt * 2);
            this.gc.drawLine(leftX + pt * 4, y + pt * 4, leftX + pt * 2, y + pt * 2);
            this.gc.setForeground(this.originColor);
        }

        void drawFullWidthSpace(int x, int y, int lineHeight, int spaceWidth) {
            int rightX = x + spaceWidth - 1;
            int pt = lineHeight / 8;
            int underY = y + lineHeight - 1;
            this.gc.setForeground(this.jStyle.fullWidthSpaceColor);
            this.gc.drawLine(x + pt * 2, y + pt * 2, rightX - pt * 2, y + pt * 2);
            this.gc.drawLine(x + pt * 2, underY - pt * 2, rightX - pt * 2, underY - pt * 2);
            this.gc.drawLine(x + pt * 2, y + pt * 2, x + pt * 2, underY - pt * 2);
            this.gc.drawLine(rightX - pt * 2, y + pt * 2, rightX - pt * 2, underY - pt * 2);
            this.gc.setForeground(this.originColor);
        }

        void drawHalfWidthSpace(int x, int y, int lineHeight, int spaceWidth) {
            int rightX = x + spaceWidth - 1;
            int pt = lineHeight / 8;
            int underY = y + lineHeight - 1;
            int x1 = x + pt * 1;
            int x2 = rightX - pt * 1;
            if (x1 >= x2 - 1) {
                x1 = x + 1;
                x2 = rightX - 1;
            }
            this.gc.setForeground(this.jStyle.halfWidthSpaceColor);
            this.gc.drawLine(x1, underY - pt * 2, x2, underY - pt * 2);
            this.gc.drawLine(x1, underY - pt * 4, x1, underY - pt * 2);
            this.gc.drawLine(x2, underY - pt * 4, x2, underY - pt * 2);
            this.gc.setForeground(this.originColor);
        }
    }

    class StyleItem {
        TextStyle style;
        int start;
        int length;
        boolean lineBreak;
        boolean softBreak;
        boolean tab;
        SCRIPT_ANALYSIS analysis;
        int psc = 0;
        int glyphs;
        int glyphCount;
        int clusters;
        int visAttrs;
        int advances;
        int goffsets;
        int width;
        int ascent;
        int descent;
        int leading;
        int x;
        int psla;
        int fallbackFont;

        StyleItem() {
        }

        void free() {
            int hHeap = OS.GetProcessHeap();
            if (this.psc != 0) {
                OS.ScriptFreeCache((int)this.psc);
                OS.HeapFree((int)hHeap, (int)0, (int)this.psc);
                this.psc = 0;
            }
            if (this.glyphs != 0) {
                OS.HeapFree((int)hHeap, (int)0, (int)this.glyphs);
                this.glyphs = 0;
                this.glyphCount = 0;
            }
            if (this.clusters != 0) {
                OS.HeapFree((int)hHeap, (int)0, (int)this.clusters);
                this.clusters = 0;
            }
            if (this.visAttrs != 0) {
                OS.HeapFree((int)hHeap, (int)0, (int)this.visAttrs);
                this.visAttrs = 0;
            }
            if (this.advances != 0) {
                OS.HeapFree((int)hHeap, (int)0, (int)this.advances);
                this.advances = 0;
            }
            if (this.goffsets != 0) {
                OS.HeapFree((int)hHeap, (int)0, (int)this.goffsets);
                this.goffsets = 0;
            }
            if (this.psla != 0) {
                OS.HeapFree((int)hHeap, (int)0, (int)this.psla);
                this.psla = 0;
            }
            if (this.fallbackFont != 0) {
                if (TextLayout.this.mLangFontLink2 != 0) {
                    OS.VtblCall((int)8, (int)TextLayout.this.mLangFontLink2, (int)this.fallbackFont);
                }
                this.fallbackFont = 0;
            }
            this.x = 0;
            this.descent = 0;
            this.ascent = 0;
            this.width = 0;
            this.softBreak = false;
            this.lineBreak = false;
        }
    }
}

