/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

class WebSite
extends OleControlSite {
    COMObject iDocHostUIHandler;
    COMObject iDocHostShowUI;
    COMObject iServiceProvider;
    COMObject iInternetSecurityManager;
    COMObject iOleCommandTarget;
    static final int OLECMDID_SHOWSCRIPTERROR = 40;

    public WebSite(Composite parent, int style, String progId) {
        super(parent, style, progId);
    }

    protected void createCOMInterfaces() {
        super.createCOMInterfaces();
        int[] nArray = new int[18];
        nArray[0] = 2;
        nArray[3] = 4;
        nArray[4] = 1;
        nArray[5] = 5;
        nArray[8] = 1;
        nArray[9] = 1;
        nArray[10] = 1;
        nArray[11] = 3;
        nArray[12] = 3;
        nArray[13] = 2;
        nArray[14] = 2;
        nArray[15] = 1;
        nArray[16] = 3;
        nArray[17] = 2;
        this.iDocHostUIHandler = new COMObject(nArray){

            public int method0(int[] args) {
                return WebSite.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return WebSite.this.AddRef();
            }

            public int method2(int[] args) {
                return WebSite.this.Release();
            }

            public int method3(int[] args) {
                return WebSite.this.ShowContextMenu(args[0], args[1], args[2], args[3]);
            }

            public int method4(int[] args) {
                return WebSite.this.GetHostInfo(args[0]);
            }

            public int method5(int[] args) {
                return WebSite.this.ShowUI(args[0], args[1], args[2], args[3], args[4]);
            }

            public int method6(int[] args) {
                return WebSite.this.HideUI();
            }

            public int method7(int[] args) {
                return WebSite.this.UpdateUI();
            }

            public int method8(int[] args) {
                return WebSite.this.EnableModeless(args[0]);
            }

            public int method9(int[] args) {
                return WebSite.this.OnDocWindowActivate(args[0]);
            }

            public int method10(int[] args) {
                return WebSite.this.OnFrameWindowActivate(args[0]);
            }

            public int method11(int[] args) {
                return WebSite.this.ResizeBorder(args[0], args[1], args[2]);
            }

            public int method12(int[] args) {
                return WebSite.this.TranslateAccelerator(args[0], args[1], args[2]);
            }

            public int method13(int[] args) {
                return WebSite.this.GetOptionKeyPath(args[0], args[1]);
            }

            public int method14(int[] args) {
                return WebSite.this.GetDropTarget(args[0], args[1]);
            }

            public int method15(int[] args) {
                return WebSite.this.GetExternal(args[0]);
            }

            public int method16(int[] args) {
                return WebSite.this.TranslateUrl(args[0], args[1], args[2]);
            }

            public int method17(int[] args) {
                return WebSite.this.FilterDataObject(args[0], args[1]);
            }
        };
        int[] nArray2 = new int[5];
        nArray2[0] = 2;
        nArray2[3] = 7;
        nArray2[4] = 7;
        this.iDocHostShowUI = new COMObject(nArray2){

            public int method0(int[] args) {
                return WebSite.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return WebSite.this.AddRef();
            }

            public int method2(int[] args) {
                return WebSite.this.Release();
            }

            public int method3(int[] args) {
                return WebSite.this.ShowMessage(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }

            public int method4(int[] args) {
                return WebSite.this.ShowHelp(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }
        };
        int[] nArray3 = new int[4];
        nArray3[0] = 2;
        nArray3[3] = 3;
        this.iServiceProvider = new COMObject(nArray3){

            public int method0(int[] args) {
                return WebSite.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return WebSite.this.AddRef();
            }

            public int method2(int[] args) {
                return WebSite.this.Release();
            }

            public int method3(int[] args) {
                return WebSite.this.QueryService(args[0], args[1], args[2]);
            }
        };
        int[] nArray4 = new int[11];
        nArray4[0] = 2;
        nArray4[3] = 1;
        nArray4[4] = 1;
        nArray4[5] = 3;
        nArray4[6] = 4;
        nArray4[7] = 8;
        nArray4[8] = 7;
        nArray4[9] = 3;
        nArray4[10] = 3;
        this.iInternetSecurityManager = new COMObject(nArray4){

            public int method0(int[] args) {
                return WebSite.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return WebSite.this.AddRef();
            }

            public int method2(int[] args) {
                return WebSite.this.Release();
            }

            public int method3(int[] args) {
                return WebSite.this.SetSecuritySite(args[0]);
            }

            public int method4(int[] args) {
                return WebSite.this.GetSecuritySite(args[0]);
            }

            public int method5(int[] args) {
                return WebSite.this.MapUrlToZone(args[0], args[1], args[2]);
            }

            public int method6(int[] args) {
                return WebSite.this.GetSecurityId(args[0], args[1], args[2], args[3]);
            }

            public int method7(int[] args) {
                return WebSite.this.ProcessUrlAction(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);
            }

            public int method8(int[] args) {
                return WebSite.this.QueryCustomPolicy(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }

            public int method9(int[] args) {
                return WebSite.this.SetZoneMapping(args[0], args[1], args[2]);
            }

            public int method10(int[] args) {
                return WebSite.this.GetZoneMappings(args[0], args[1], args[2]);
            }
        };
        int[] nArray5 = new int[5];
        nArray5[0] = 2;
        nArray5[3] = 4;
        nArray5[4] = 5;
        this.iOleCommandTarget = new COMObject(nArray5){

            public int method0(int[] args) {
                return WebSite.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return WebSite.this.AddRef();
            }

            public int method2(int[] args) {
                return WebSite.this.Release();
            }

            public int method3(int[] args) {
                return WebSite.this.QueryStatus(args[0], args[1], args[2], args[3]);
            }

            public int method4(int[] args) {
                return WebSite.this.Exec(args[0], args[1], args[2], args[3], args[4]);
            }
        };
    }

    protected void disposeCOMInterfaces() {
        super.disposeCOMInterfaces();
        if (this.iDocHostUIHandler != null) {
            this.iDocHostUIHandler.dispose();
            this.iDocHostUIHandler = null;
        }
        if (this.iDocHostShowUI != null) {
            this.iDocHostShowUI.dispose();
            this.iDocHostShowUI = null;
        }
        if (this.iServiceProvider != null) {
            this.iServiceProvider.dispose();
            this.iServiceProvider = null;
        }
        if (this.iInternetSecurityManager != null) {
            this.iInternetSecurityManager.dispose();
            this.iInternetSecurityManager = null;
        }
        if (this.iOleCommandTarget != null) {
            this.iOleCommandTarget.dispose();
            this.iOleCommandTarget = null;
        }
    }

    protected int AddRef() {
        return super.AddRef();
    }

    protected int QueryInterface(int riid, int ppvObject) {
        int result = super.QueryInterface(riid, ppvObject);
        if (result == 0) {
            return result;
        }
        if (riid == 0 || ppvObject == 0) {
            return -2147024809;
        }
        GUID guid = new GUID();
        COM.MoveMemory(guid, riid, 16);
        if (COM.IsEqualGUID(guid, COM.IIDIDocHostUIHandler)) {
            COM.MoveMemory(ppvObject, new int[]{this.iDocHostUIHandler.getAddress()}, 4);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(guid, COM.IIDIDocHostShowUI)) {
            COM.MoveMemory(ppvObject, new int[]{this.iDocHostShowUI.getAddress()}, 4);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(guid, COM.IIDIServiceProvider)) {
            COM.MoveMemory(ppvObject, new int[]{this.iServiceProvider.getAddress()}, 4);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(guid, COM.IIDIOleCommandTarget)) {
            COM.MoveMemory(ppvObject, new int[]{this.iOleCommandTarget.getAddress()}, 4);
            this.AddRef();
            return 0;
        }
        COM.MoveMemory(ppvObject, new int[1], 4);
        return -2147467262;
    }

    int EnableModeless(int EnableModeless) {
        return -2147467263;
    }

    int FilterDataObject(int pDO, int ppDORet) {
        return -2147467263;
    }

    int GetDropTarget(int pDropTarget, int ppDropTarget) {
        return -2147467263;
    }

    int GetExternal(int ppDispatch) {
        return -2147467263;
    }

    int GetHostInfo(int pInfo) {
        Browser browser = (Browser)this.getParent().getParent();
        OS.MoveMemory(pInfo + 4, new int[]{browser.info}, 4);
        return 0;
    }

    int GetOptionKeyPath(int pchKey, int dw) {
        return -2147467263;
    }

    int HideUI() {
        return -2147467263;
    }

    int OnDocWindowActivate(int fActivate) {
        return -2147467263;
    }

    int OnFrameWindowActivate(int fActivate) {
        return -2147467263;
    }

    protected int Release() {
        return super.Release();
    }

    int ResizeBorder(int prcBorder, int pUIWindow, int fFrameWindow) {
        return -2147467263;
    }

    int ShowContextMenu(int dwID, int ppt, int pcmdtReserved, int pdispReserved) {
        Browser browser = (Browser)this.getParent().getParent();
        Event event = new Event();
        POINT pt = new POINT();
        OS.MoveMemory(pt, ppt, 8);
        event.x = pt.x;
        event.y = pt.y;
        browser.notifyListeners(35, event);
        if (!event.doit) {
            return 0;
        }
        Menu menu = browser.getMenu();
        if (menu != null && !menu.isDisposed()) {
            if (pt.x != event.x || pt.y != event.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            return 0;
        }
        return 1;
    }

    int ShowUI(int dwID, int pActiveObject, int pCommandTarget, int pFrame, int pDoc) {
        return -2147467263;
    }

    int TranslateAccelerator(int lpMsg, int pguidCmdGroup, int nCmdID) {
        Menu menubar = this.getShell().getMenuBar();
        if (menubar != null && !menubar.isDisposed() && menubar.isEnabled()) {
            Shell shell = menubar.getShell();
            int hwnd = shell.handle;
            int hAccel = OS.SendMessage(hwnd, 32769, 0, 0);
            if (hAccel != 0) {
                MSG msg = new MSG();
                OS.MoveMemory(msg, lpMsg, 28);
                if (OS.TranslateAccelerator(hwnd, hAccel, msg) != 0) {
                    return 0;
                }
            }
        }
        OleAutomation auto = new OleAutomation(this);
        int[] rgdispid = auto.getIDsOfNames(new String[]{"LocationURL"});
        Variant pVarResult = auto.getProperty(rgdispid[0]);
        auto.dispose();
        int result = 1;
        if (pVarResult != null) {
            String url;
            if (pVarResult.getType() == 8 && (url = pVarResult.getString()).equals("about:blank")) {
                MSG msg = new MSG();
                OS.MoveMemory(msg, lpMsg, 28);
                if (msg.message == 256 && msg.wParam == 116) {
                    result = 0;
                }
                if (msg.message == 256 && msg.wParam == 78 && OS.GetKeyState(17) < 0) {
                    result = 0;
                }
            }
            pVarResult.dispose();
        }
        return result;
    }

    int TranslateUrl(int dwTranslate, int pchURLIn, int ppchURLOut) {
        return -2147467263;
    }

    int UpdateUI() {
        return -2147467263;
    }

    int ShowMessage(int hwnd, int lpstrText, int lpstrCaption, int dwType, int lpstrHelpFile, int dwHelpContext, int plResult) {
        TCHAR lpLibFileName;
        int hModule;
        int IDS_MESSAGE_BOX_CAPTION = 8033;
        if (lpstrText != 0 && (hModule = OS.LoadLibrary(lpLibFileName = new TCHAR(0, "SHDOCLC.DLL", true))) != 0) {
            int cnt = OS.wcslen(lpstrText);
            char[] buffer = new char[cnt];
            OS.MoveMemory(buffer, lpstrText, cnt * 2);
            String text = new String(buffer);
            int length = (OS.IsUnicode ? cnt : OS.WideCharToMultiByte(0, 0, buffer, cnt, 0, 0, null, null)) + 1;
            TCHAR lpBuffer = new TCHAR(0, length);
            int result = OS.LoadString(hModule, IDS_MESSAGE_BOX_CAPTION, lpBuffer, length);
            OS.FreeLibrary(hModule);
            return result > 0 && text.equals(lpBuffer.toString(0, result)) ? 0 : 1;
        }
        return 1;
    }

    int ShowHelp(int hwnd, int pszHelpFile, int uCommand, int dwData, int ptMouse_x, int ptMouse_y, int pDispatchObjectHit) {
        Browser browser = (Browser)this.getParent().getParent();
        Event event = new Event();
        event.type = 28;
        event.display = this.getDisplay();
        event.widget = browser;
        Shell shell = browser.getShell();
        Composite control = browser;
        while (true) {
            if (control.isListening(28)) {
                control.notifyListeners(28, event);
                break;
            }
            if (control == shell) break;
            control = control.getParent();
        }
        return 0;
    }

    int QueryService(int guidService, int riid, int ppvObject) {
        if (riid == 0 || ppvObject == 0) {
            return -2147024809;
        }
        GUID guid = new GUID();
        COM.MoveMemory(guid, riid, 16);
        if (COM.IsEqualGUID(guid, COM.IIDIInternetSecurityManager)) {
            COM.MoveMemory(ppvObject, new int[]{this.iInternetSecurityManager.getAddress()}, 4);
            this.AddRef();
            return 0;
        }
        COM.MoveMemory(ppvObject, new int[1], 4);
        return -2147467262;
    }

    int SetSecuritySite(int pSite) {
        return -2146697199;
    }

    int GetSecuritySite(int ppSite) {
        return -2146697199;
    }

    int MapUrlToZone(int pwszUrl, int pdwZone, int dwFlags) {
        COM.MoveMemory(pdwZone, new int[]{1}, 4);
        return 0;
    }

    int GetSecurityId(int pwszUrl, int pbSecurityId, int pcbSecurityId, int dwReserved) {
        return -2146697199;
    }

    int ProcessUrlAction(int pwszUrl, int dwAction, int pPolicy, int cbPolicy, int pContext, int cbContext, int dwFlags, int dwReserved) {
        int policy = 0;
        if (dwAction >= 7168 && dwAction <= 7423) {
            policy = 196608;
        }
        if (dwAction == 4608) {
            GUID guid = new GUID();
            COM.MoveMemory(guid, pContext, 16);
            if (COM.IsEqualGUID(guid, COM.IIDJavaBeansBridge) || COM.IsEqualGUID(guid, COM.IIDShockwaveActiveXControl)) {
                policy = 3;
            }
        }
        if (cbPolicy >= 4) {
            COM.MoveMemory(pPolicy, new int[]{policy}, 4);
        }
        return 0;
    }

    int QueryCustomPolicy(int pwszUrl, int guidKey, int ppPolicy, int pcbPolicy, int pContext, int cbContext, int dwReserved) {
        return -2146697199;
    }

    int SetZoneMapping(int dwZone, int lpszPattern, int dwFlags) {
        return -2146697199;
    }

    int GetZoneMappings(int dwZone, int ppenumString, int dwFlags) {
        return -2147467263;
    }

    int QueryStatus(int pguidCmdGroup, int cCmds, int prgCmds, int pCmdText) {
        return -2147221248;
    }

    int Exec(int pguidCmdGroup, int nCmdID, int nCmdExecOpt, int pvaIn, int pvaOut) {
        if (pguidCmdGroup != 0) {
            GUID guid = new GUID();
            COM.MoveMemory(guid, pguidCmdGroup, 16);
            if (COM.IsEqualGUID(guid, COM.CGID_DocHostCommandHandler) && nCmdID == 40) {
                return 0;
            }
            if (nCmdID == 1 && COM.IsEqualGUID(guid, COM.CGID_Explorer) && (nCmdExecOpt & 0xFFFF) == 10) {
                Browser browser = (Browser)this.getParent().getParent();
                browser.toolBar = (nCmdExecOpt & 0xFFFF0000) != 0;
            }
        }
        return -2147221248;
    }
}

