/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.zip.Deflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

import jp.sourceforge.mergedoc.pleiades.log.Logger;

import org.apache.commons.io.IOUtils;

/**
 * AXyNgKpς݃NXELbVłB
 * <p>
 * @author C/pHeR
 */
public class TransformedClassCache {

	/** K[ */
	private static final Logger log = Logger.getLogger(TransformedClassCache.class);
	
	/** AXyNgKpς݃NXELbVEt@C */
	public static final File file = new File(Pleiades.configurationPath, "transformed-class.cache");
	
	/** ̃NX̃VOgECX^X */
	private static final TransformedClassCache singleton = new TransformedClassCache();
	
	/**
	 * AXyNgKpς݃NXELbVEIuWFNg擾܂B
	 * <p>
	 * @return AXyNgKpς݃NXELbVEIuWFNg
	 */
	public static TransformedClassCache getInstance() {
		return singleton;
	}
	
	/** ϊς݃NXE}bv */
	private Map<String, byte[]> map = new HashMap<String, byte[]>();
	
	/**
	 * AXyNgKpς݃NXELbV\z܂B
	 */
	private TransformedClassCache() {
		
		if (Pleiades.getInstance().getPleiadesOption().isClean()) {
			log.info("-clean ɂAXyNgKpς݃NXELbV̓[h܂B");
			return;
		}
		if (!file.exists()) {
			log.info("AXyNgKpς݃NXELbV݂܂B");
			return;
		}
		
		ZipInputStream in = null;
		try {
			in = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
	        ZipEntry inEntry = null;
	        while ((inEntry = in.getNextEntry()) != null) {
                byte[] bytecode = IOUtils.toByteArray(in);
                map.put(inEntry.getName(), bytecode);
	        }
			log.info("AXyNgKpς݃NXELbV[h܂B" + map.size());

		} catch (IOException e) {
			log.fatal("AXyNgKpς݃NXELbṼ[hɎs܂B", e);

		} finally {
			IOUtils.closeQuietly(in);
		}
	}
	
	/**
	 * ǉꂽNXLbVƂĉi܂B
	 */
	public void store() {
		
        ZipOutputStream out = null;
		try {
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            out.setLevel(Deflater.BEST_SPEED);
            
            for (Entry<String, byte[]> entry : map.entrySet()) {
                out.putNextEntry(new ZipEntry(entry.getKey()));
                out.write(entry.getValue());
			}
			log.info("AXyNgKpς݃NXELbVۊǂ܂B" + map.size());
			
		} catch (IOException e) {
			log.error("AXyNgKpς݃NXELbV̕ۊǂɎs܂B", e);
			
		} finally {
			IOUtils.closeQuietly(out);
		}
	}
	
	/**
	 * LbVփoCgR[hǉ܂B
	 * <p>
	 * @param className NX
	 * @param bytecode oCgR[h
	 */
	public void put(String className, byte[] bytecode) {
		map.put(className, bytecode);
	}
	
	/**
	 * LbVoCgR[h擾܂B
	 * <p>
	 * @param className NX
	 * @return oCgR[h
	 */
	public byte[] get(String className) {
		return map.get(className);
	}
}
