/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;

/**
 * Eclipse ÑoCgR[hϊsgXtH[}[łB
 * <p>
 * @author C/pHeR
 */
public class LauncherTransformer extends AbstractTransformer {

	/** K[ */
	private static final Logger log = Logger.getLogger(LauncherTransformer.class);

	/**
	 * NgXtH[}[\z܂B
	 */
	public LauncherTransformer() {
	}

	/**
	 * oCgR[hϊs܂B
	 */
	@Override
	protected byte[] transform(
			ClassLoader loader,
			String className,
			ProtectionDomain protectionDomain,
			byte[] bytecode)
		throws CannotCompileException, NotFoundException, IOException {

		if (isEclipseLauncherClass(className)) {
			
			// ̃gXtH[}[G[WFg폜
			Pleiades.getInstance().getInstrumentation().removeTransformer(this);
			
			// |JnAXyNg̖ߍ
			return weaveStartTranslationAspect(protectionDomain, bytecode);
		}
		return null;
	}

	/**
	 * Eclipse NNX肵܂B
	 * <p>
	 * 3.2 ȑOF org.eclipse.core.launcher.Main<br>
	 * 3.3 ȍ~F org.eclipse.equinox.launcher.Main
	 * <p>
	 * @param className NX
	 * @return NNX̏ꍇ true
	 */
	protected boolean isEclipseLauncherClass(String className) {
		return className.endsWith(".launcher.Main");
	}
	
	/**
	 * |JnAXyNg𖄂ߍ݂܂B
	 * <ul>
	 * <li>OF {@link #startTranslationTransformer(String[])} Ăяo
	 * <li>㏈F {@link #destroyTranslationTransformer()} Ăяo
	 * </ul>
	 * @param protectionDomain veNVEhC
	 * @param bytecode oCgR[h
	 * @return ߍ݌̃oCgR[h
	 */
	protected byte[] weaveStartTranslationAspect(ProtectionDomain protectionDomain, byte[] bytecode)
		throws CannotCompileException, NotFoundException, IOException {
		
		log.info("Eclipse ̋NJn܂B");

		// Eclipse Main NXɊJnǉ
		CtClass ctClass = createCtClass(bytecode, protectionDomain);
		CtMethod run = ctClass.getMethod("basicRun", "([Ljava/lang/String;)V");
		String className = getClass().getName();
		run.insertBefore("$1 = " + className + ".startTranslationTransformer($$);");

		// Eclipse Main NXɏIǉ
		run.insertAfter(className + ".destroyTranslationTransformer();", true);

		// XvbV摜pXύX
		PleiadesOption agentOption = Pleiades.getInstance().getPleiadesOption();
		if (!agentOption.isDefaultSplash()) {

			System.setProperty("osgi.splashLocation", getSplashLocation());
		}
		return ctClass.toBytecode();
	}
	
	/**
	 * |gXtH[}[Jn܂B
	 * <p>
	 * @param args Eclipse NIvVz
	 * @return NIvVz
	 */
	public static String[] startTranslationTransformer(String... args) {

		try {
			List<String> argList = new LinkedList<String>(Arrays.asList(args));

			// N -clean 擾
			Pleiades pleiades = Pleiades.getInstance();
			PleiadesOption option = pleiades.getPleiadesOption();
			option.setClean(argList.contains("-clean"));

			// LbVꍇ͋I -claen w
			if (!option.isClean()) {
				boolean isClean = false;
				if (!ExcludesClassList.file.exists()) {
					isClean = true;
					log.info("AXyNgONXEXg݂Ȃ߁A" +
						"I -clean [hŋN܂B");
				}
				if (isClean) {
					argList.add("-clean");
					option.setClean(true);
				}
			}
			log.info("-clean: " + option.isClean());

			// |gXtH[}[Jn
			Instrumentation inst = pleiades.getInstrumentation();
			if (log.isDebugEnabled()) {
				inst.addTransformer(new TranslationLoggingTransformer());
			} else {
				inst.addTransformer(new TranslationTransformer());
			}

			return argList.toArray(new String[0]);

		} catch (Throwable e) {

			String msg = "|gXtH[}[̊JnɎs܂B";
			log.fatal(msg, e);
			throw new IllegalStateException(msg, e);
		}
	}
	
	/**
	 * |gXtH[}[j܂B
	 */
	public static void destroyTranslationTransformer() {
		TranslationTransformer.destroy();
	}

	/**
	 * XvbV摜pX擾܂B
	 * @return XvbV摜pX
	 */
	public static String getSplashLocation() {

		String version = "";

		File pluginsFolder = FileSystem.resourceRoot.getParentFile().getParentFile();
		for (File folder : pluginsFolder.listFiles()) {
			String folderName = folder.getName();
			if (folderName.startsWith("org.eclipse.osgi_")) {
				version = folderName.replaceFirst(".*?_(\\d+\\.\\d+).*", "$1");
				break;
			}
		}
		String fileName = "splash" + version + ".bmp";

		File file = FileSystem.getResourceFile(fileName);
		if (!file.exists()) {
			fileName = "splash.bmp";
		}
		File splashFile = FileSystem.getResourceFile(fileName);
		return splashFile.getAbsolutePath().replace('\\', '/');
	}
}
