/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.IOException;
import java.security.ProtectionDomain;

import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.AspectMapping;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.RegexDictionary;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.TranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.TranslationExcludeProperties;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

/**
 * |󏈗𖄂ߍނ߂̃oCgR[hϊsgXtH[}[łB
 * <p>
 * @author C/pHeR
 */
public class TranslationTransformer extends AbstractTransformer {

	/** K[ */
	@SuppressWarnings("unused")
	private static final Logger log = Logger.getLogger(TranslationTransformer.class);

	/**
	 * |gXtH[}[\z܂B
	 */
	public TranslationTransformer() {
		load();
	}
	
	/**
	 * |ɕKvȃvpeB[[h܂B
	 */
	protected void load() {
		
		// ϊONXEXg[h
		ExcludesClassList.getInstance();

		// AXyNgKpς݃NXELbV[h
		TransformedClassCache.getInstance();

		// AXyNg`[h
		AspectMapping.getInstance();

		// |󏜊OvpeB[[h
		TranslationExcludeProperties.getInstance();

		// |vpeB[[h
		TranslationDictionary.getInstance();

		// K\|vpeB[[h
		RegexDictionary.getInstance();
	}

	/**
	 * oCgR[hϊ܂B
	 * <p>
	 * {@link TranslationEditor |GfB^[} gpAoCgR[hϊ܂B
	 * A{@link ExcludesClassList ϊONXEXg}
	 * ɏNX܂܂ꍇAs܂B
	 */
	@Override
	protected byte[] transform(
			ClassLoader loader,
			String className,
			ProtectionDomain protectionDomain,
			byte[] bytecode)
		throws CannotCompileException, NotFoundException, IOException {
		
		// ϊONX̏ꍇ͉Ȃ
		boolean isClean = Pleiades.getInstance().getPleiadesOption().isClean();
		ExcludesClassList excludeList = ExcludesClassList.getInstance();
		if (!isClean && excludeList.remove(className)) {
			return null;
		}
		
		// AXyNgKpς݃NXELbVꍇ͂Ԃ
		TransformedClassCache classCache = TransformedClassCache.getInstance();
		byte[] cachedBytecode = classCache.get(className);
		if (cachedBytecode != null) {
			return cachedBytecode;
		}

		// oCgR[hɖ|AXyNg𖄂ߍ
		CtClass ctClass = createCtClass(bytecode, protectionDomain);
		byte[] transformedBytecode = weaveTranslationAspect(ctClass);

		// -clean ̏ꍇ͎Np̏쐬
		if (isClean) {
			if (transformedBytecode == null) {
				// ϊΏۊȌꍇ́AϊOXgɒǉ
				excludeList.add(className);
			} else {
				// ϊꍇ́AAXyNgKpς݃NXELbVɒǉ
				classCache.put(className, transformedBytecode);
			}
		}
		return transformedBytecode;
	}
	
	/**
	 * NXEIuWFNgɖ|AXyNg𖄂ߍ݂܂B
	 * <p>
	 * @param ctClass ϊΏۃNXEIuWFNg
	 * @return ߍ݌̃oCgR[h
	 */
	protected byte[] weaveTranslationAspect(CtClass ctClass)
		throws CannotCompileException, NotFoundException, IOException {
		
		TranslationEditor editor = new TranslationEditor(ctClass);

		// RXgN^[A\bh̕ϊ
		for (CtBehavior ctBehavior : ctClass.getDeclaredBehaviors()) {
			
			// R[hAĂяoҏW
			ctBehavior.instrument(editor);
			
			// \bhҏW
			editor.editBehavior(ctBehavior);
		}

		// X^eBbNECjVCU[̕ϊ
		CtConstructor ctInitializer = ctClass.getClassInitializer();
		if (ctInitializer != null) {
			ctInitializer.instrument(editor);
		}
		return editor.toBytecode();
	}

	/**
	 * |gXtH[}[j܂B
	 */
	public static void destroy() {

		if (Pleiades.getInstance().getPleiadesOption().isClean()) {

			// |vpeB[LbVƂĕۑ
			TranslationDictionary.getInstance().store();

			// |󏜊OXgۑ
			ExcludesClassList.getInstance().store();
			
			// AXyNgKpς݃NXELbVۑ
			TransformedClassCache.getInstance().store();
		}
	}
}
