/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.IOException;
import java.security.ProtectionDomain;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import jp.sourceforge.mergedoc.pleiades.aspect.AbstractTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.ExcludesClassList;
import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.aspect.TransformedClassCache;
import jp.sourceforge.mergedoc.pleiades.aspect.TranslationEditor;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.AspectMapping;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.RegexDictionary;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.TranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.TranslationExcludeProperties;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

public class TranslationTransformer
extends AbstractTransformer {
    private static final Logger log = Logger.getLogger(TranslationTransformer.class);

    public TranslationTransformer() {
        this.load();
    }

    protected void load() {
        ExcludesClassList.getInstance();
        TransformedClassCache.getInstance();
        AspectMapping.getInstance();
        TranslationExcludeProperties.getInstance();
        TranslationDictionary.getInstance();
        RegexDictionary.getInstance();
    }

    protected byte[] transform(ClassLoader loader, String className, ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        boolean isClean = Pleiades.getInstance().getPleiadesOption().isClean();
        ExcludesClassList excludeList = ExcludesClassList.getInstance();
        if (!isClean && excludeList.remove(className)) {
            return null;
        }
        TransformedClassCache classCache = TransformedClassCache.getInstance();
        byte[] cachedBytecode = classCache.get(className);
        if (cachedBytecode != null) {
            return cachedBytecode;
        }
        CtClass ctClass = this.createCtClass(bytecode, protectionDomain);
        byte[] transformedBytecode = this.weaveTranslationAspect(ctClass);
        if (isClean) {
            if (transformedBytecode == null) {
                excludeList.add(className);
            } else {
                classCache.put(className, transformedBytecode);
            }
        }
        return transformedBytecode;
    }

    protected byte[] weaveTranslationAspect(CtClass ctClass) throws CannotCompileException, NotFoundException, IOException {
        TranslationEditor editor = new TranslationEditor(ctClass);
        CtBehavior[] ctBehaviorArray = ctClass.getDeclaredBehaviors();
        int n = ctBehaviorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CtBehavior ctBehavior = ctBehaviorArray[n2];
            ctBehavior.instrument((ExprEditor)editor);
            editor.editBehavior(ctBehavior);
            ++n2;
        }
        CtConstructor ctInitializer = ctClass.getClassInitializer();
        if (ctInitializer != null) {
            ctInitializer.instrument((ExprEditor)editor);
        }
        return editor.toBytecode();
    }

    public static void destroy() {
        if (Pleiades.getInstance().getPleiadesOption().isClean()) {
            TranslationDictionary.getInstance().store();
            ExcludesClassList.getInstance().store();
            TransformedClassCache.getInstance().store();
        }
    }
}

