/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import org.apache.commons.io.IOUtils;

public class TransformedClassCache {
    private static final Logger log = Logger.getLogger(TransformedClassCache.class);
    public static final File file = new File(Pleiades.configurationPath, "transformed-class.cache");
    private static final TransformedClassCache singleton = new TransformedClassCache();
    private Map<String, byte[]> map;

    public static TransformedClassCache getInstance() {
        return singleton;
    }

    private TransformedClassCache() {
        block8: {
            this.map = new HashMap<String, byte[]>();
            if (Pleiades.getInstance().getPleiadesOption().isClean()) {
                log.info("-clean \u306b\u3088\u308a\u30a2\u30b9\u30da\u30af\u30c8\u9069\u7528\u6e08\u307f\u30af\u30e9\u30b9\u30fb\u30ad\u30e3\u30c3\u30b7\u30e5\u306f\u30ed\u30fc\u30c9\u3055\u308c\u307e\u305b\u3093\u3002");
                return;
            }
            if (!file.exists()) {
                log.info("\u30a2\u30b9\u30da\u30af\u30c8\u9069\u7528\u6e08\u307f\u30af\u30e9\u30b9\u30fb\u30ad\u30e3\u30c3\u30b7\u30e5\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                return;
            }
            ZipInputStream in = null;
            try {
                try {
                    in = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
                    ZipEntry inEntry = null;
                    while ((inEntry = in.getNextEntry()) != null) {
                        byte[] bytecode = IOUtils.toByteArray((InputStream)in);
                        this.map.put(inEntry.getName(), bytecode);
                    }
                    log.info("\u30a2\u30b9\u30da\u30af\u30c8\u9069\u7528\u6e08\u307f\u30af\u30e9\u30b9\u30fb\u30ad\u30e3\u30c3\u30b7\u30e5\u3092\u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f\u3002" + this.map.size());
                }
                catch (IOException e) {
                    log.fatal("\u30a2\u30b9\u30da\u30af\u30c8\u9069\u7528\u6e08\u307f\u30af\u30e9\u30b9\u30fb\u30ad\u30e3\u30c3\u30b7\u30e5\u306e\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
                    IOUtils.closeQuietly(in);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public void store() {
        block6: {
            ZipOutputStream out = null;
            try {
                try {
                    out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                    out.setLevel(1);
                    for (Map.Entry<String, byte[]> entry : this.map.entrySet()) {
                        out.putNextEntry(new ZipEntry(entry.getKey()));
                        out.write(entry.getValue());
                    }
                    log.info("\u30a2\u30b9\u30da\u30af\u30c8\u9069\u7528\u6e08\u307f\u30af\u30e9\u30b9\u30fb\u30ad\u30e3\u30c3\u30b7\u30e5\u3092\u4fdd\u7ba1\u3057\u307e\u3057\u305f\u3002" + this.map.size());
                }
                catch (IOException e) {
                    log.error("\u30a2\u30b9\u30da\u30af\u30c8\u9069\u7528\u6e08\u307f\u30af\u30e9\u30b9\u30fb\u30ad\u30e3\u30c3\u30b7\u30e5\u306e\u4fdd\u7ba1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
                    IOUtils.closeQuietly(out);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public void put(String className, byte[] bytecode) {
        this.map.put(className, bytecode);
    }

    public byte[] get(String className) {
        return this.map.get(className);
    }
}

