/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import org.apache.commons.io.FileUtils;

public class ExcludesClassList {
    private static final Logger log = Logger.getLogger(ExcludesClassList.class);
    public static final File file = new File(Pleiades.configurationPath, "excludes-class.list");
    private static final ExcludesClassList singleton = new ExcludesClassList();
    private Set<String> excludeSet = new HashSet<String>();

    public static ExcludesClassList getInstance() {
        return singleton;
    }

    private ExcludesClassList() {
        if (Pleiades.getInstance().getPleiadesOption().isClean()) {
            log.info("-clean \u306b\u3088\u308a\u30a2\u30b9\u30da\u30af\u30c8\u9664\u5916\u30af\u30e9\u30b9\u30fb\u30ea\u30b9\u30c8\u306f\u30ed\u30fc\u30c9\u3055\u308c\u307e\u305b\u3093\u3002");
            return;
        }
        if (!file.exists()) {
            log.info("\u30a2\u30b9\u30da\u30af\u30c8\u9664\u5916\u30af\u30e9\u30b9\u30fb\u30ea\u30b9\u30c8\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            return;
        }
        try {
            this.excludeSet.addAll(FileUtils.readLines((File)file, null));
            log.info("\u30a2\u30b9\u30da\u30af\u30c8\u9664\u5916\u30af\u30e9\u30b9\u30fb\u30ea\u30b9\u30c8\u3092\u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f\u3002" + this.excludeSet.size());
        }
        catch (IOException e) {
            log.fatal("\u30a2\u30b9\u30da\u30af\u30c8\u9664\u5916\u30af\u30e9\u30b9\u30fb\u30ea\u30b9\u30c8\u306e\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    public void store() {
        try {
            FileUtils.writeLines((File)file, null, this.excludeSet);
            log.info("\u30a2\u30b9\u30da\u30af\u30c8\u9664\u5916\u30af\u30e9\u30b9\u30fb\u30ea\u30b9\u30c8\u3092\u4fdd\u7ba1\u3057\u307e\u3057\u305f\u3002" + this.excludeSet.size());
        }
        catch (IOException e) {
            log.error("\u30a2\u30b9\u30da\u30af\u30c8\u9664\u5916\u30af\u30e9\u30b9\u30fb\u30ea\u30b9\u30c8\u306e\u4fdd\u7ba1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    public void add(String className) {
        this.excludeSet.add(className);
    }

    public boolean remove(String className) {
        return this.excludeSet.remove(className);
    }
}

