/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FileSystem {
    private static final Logger log = Logger.getLogger(FileSystem.class);
    public static final File resourceRoot;

    static {
        String markResource = "/.marker";
        URL url = FileSystem.class.getResource(markResource);
        if (url == null) {
            String msg = "\u30af\u30e9\u30b9\u30d1\u30b9\u4e0a\u306b\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" + markResource;
            FileNotFoundException e = new FileNotFoundException(msg);
            log.fatal(msg, e);
            throw new IllegalStateException(e);
        }
        String path = new File(url.getPath()).getParent();
        String unicodePath = FileSystem.decodePath(path);
        resourceRoot = new File(unicodePath);
    }

    private FileSystem() {
    }

    public static String decodePath(String path) {
        try {
            return URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static File getResourceFile(String resourcePath) {
        return new File(resourceRoot, resourcePath);
    }

    public static String relativePath(File folder, File file) {
        try {
            String folderPath = folder.getCanonicalPath();
            String filePath = file.getCanonicalPath();
            return filePath.replace(folderPath, "");
        }
        catch (IOException e) {
            throw new IllegalArgumentException(folder + ", " + file, e);
        }
    }

    public static Properties loadProperties(File file) {
        Properties prop = new Properties();
        if (!file.exists()) {
            return prop;
        }
        BufferedInputStream is = null;
        try {
            try {
                is = new BufferedInputStream(new FileInputStream(file));
                prop.load(is);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(file.toString(), e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return prop;
    }

    public static void storeProperties(Properties prop, File file) {
        BufferedOutputStream os = null;
        try {
            try {
                os = new BufferedOutputStream(new FileOutputStream(file));
                prop.store(os, "Generated by Pleiades. " + prop.size() + " entries.");
                List list = FileUtils.readLines((File)file, (String)"ISO-8859-1");
                LinkedList<String> resultList = new LinkedList<String>();
                resultList.add((String)list.remove(0));
                resultList.add((String)list.remove(0));
                Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
                resultList.addAll(list);
                FileUtils.writeLines((File)file, (String)"ISO-8859-1", resultList);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(file.toString(), e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)os);
    }
}

