/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.zip.ZipInputStream;
import jp.sourceforge.mergedoc.pleiades.aspect.Agent;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.AbstractDictionary;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import org.apache.commons.io.IOUtils;

public class CachedDictionary
extends AbstractDictionary {
    private static final Logger log = Logger.getLogger(CachedDictionary.class);
    public static final File cacheFile = new File(Agent.configurationPath, "translation.properties.cache");

    CachedDictionary() {
    }

    protected void load() {
        if (!cacheFile.exists()) {
            FileNotFoundException e = new FileNotFoundException(cacheFile.getPath());
            log.fatal(e.toString(), e);
            throw new IllegalStateException(e);
        }
        ZipInputStream in = null;
        try {
            try {
                in = new ZipInputStream(new BufferedInputStream(new FileInputStream(cacheFile)));
                in.getNextEntry();
                Properties prop = new Properties();
                prop.load(in);
                this.getMap().putAll(prop);
            }
            catch (IOException e) {
                log.error(cacheFile.toString(), e);
                throw new IllegalArgumentException(cacheFile.toString(), e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        log.info("\u7ffb\u8a33\u30ad\u30e3\u30c3\u30b7\u30e5\u3092\u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f\u3002" + this.getMap().size());
    }
}

