/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.AspectMapping;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PointCut;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

public class TranslationEditor
extends ExprEditor {
    private static final Logger log = Logger.getLogger(TranslationEditor.class);
    private final CtClass ctClass;
    private boolean isEdited;

    public TranslationEditor(CtClass ctClass) {
        this.ctClass = ctClass;
    }

    public void edit(MethodCall methodCall) throws CannotCompileException {
        String className = methodCall.getClassName();
        String methodName = methodCall.getMethodName();
        AspectMapping mapping = AspectMapping.getInstance();
        if (!mapping.containesMethodCall(className, methodName)) {
            return;
        }
        JointPoint jointPoint = new JointPoint();
        jointPoint.setEditPoint(JointPoint.EditPoint.CALL);
        jointPoint.setClassName(className);
        jointPoint.setMethodName(methodName);
        try {
            CtMethod calledMethod = methodCall.getMethod();
            jointPoint.setDescriptor(calledMethod.getMethodInfo().getDescriptor());
            jointPoint.setModifier(calledMethod.getModifiers());
        }
        catch (NotFoundException e) {
            log.warn("\u30af\u30e9\u30b9\u30d1\u30b9\u306a\u3057\u3002" + className + " \u2190 " + this.ctClass.getName());
            return;
        }
        PointCut pointCut = mapping.getPointCut(jointPoint);
        if (pointCut == null) {
            return;
        }
        CtBehavior where = methodCall.where();
        JointPoint whereJointPoint = new JointPoint();
        whereJointPoint.setClassName(where.getDeclaringClass().getName());
        whereJointPoint.setMethodName(where.getName());
        List<JointPoint> excludeWheres = pointCut.getExcludeWheres();
        if (excludeWheres.contains(whereJointPoint)) {
            return;
        }
        List<JointPoint> includeWheres = pointCut.getIncludeWheres();
        if (includeWheres.size() > 0 && !includeWheres.contains(whereJointPoint)) {
            return;
        }
        String advice = pointCut.getAdvice();
        methodCall.replace(advice);
        this.isEdited = true;
    }

    public void editBehavior(CtBehavior ctBehavior) throws CannotCompileException {
        String className = this.ctClass.getName();
        String methodName = ctBehavior.getName();
        JointPoint jointPoint = new JointPoint();
        jointPoint.setEditPoint(JointPoint.EditPoint.EXECUTION);
        jointPoint.setClassName(className);
        jointPoint.setMethodName(methodName);
        jointPoint.setDescriptor(ctBehavior.getMethodInfo().getDescriptor());
        jointPoint.setModifier(ctBehavior.getModifiers());
        AspectMapping mapping = AspectMapping.getInstance();
        PointCut pointCut = mapping.getPointCut(jointPoint);
        if (pointCut == null) {
            return;
        }
        PointCut.Timing timing = pointCut.getTiming();
        String advice = pointCut.getAdvice();
        if (advice.contains("?{JOINT_POINT}")) {
            String replacement = Matcher.quoteReplacement("new " + JointPoint.class.getName() + "(" + JointPoint.EditPoint.class.getName() + ".EXECUTION," + "\"" + className + "\"," + "\"" + methodName + "\"," + "\"" + jointPoint.getDescriptor() + "\"," + ctBehavior.getModifiers() + ")");
            advice = advice.replaceAll("\\?\\{JOINT_POINT\\}", replacement);
        }
        if (timing == PointCut.Timing.BEFORE) {
            ctBehavior.insertBefore(advice);
        } else if (timing == PointCut.Timing.AFTER) {
            ctBehavior.insertAfter(advice);
        } else {
            throw new IllegalStateException("\u7de8\u96c6\u30dd\u30a4\u30f3\u30c8\u304c execution \u306e\u5834\u5408\u3001timing \u306f before \u307e\u305f\u306f after \u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002" + jointPoint);
        }
        this.isEdited = true;
    }

    public byte[] toBytecode() throws IOException, CannotCompileException {
        return this.isEdited ? this.ctClass.toBytecode() : null;
    }
}

