/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Properties;
import mergedoc.MergeDocException;
import mergedoc.xml.ConfigManager;

public class Persister {
    public static final Key DOC_DIR = new Key("api.document.directory");
    public static final Key IN_FILE = new Key("input.source.archeve.file");
    public static final Key OUT_FILE = new Key("output.source.archeve.file");
    public static final Key DOC_ENC = new Key("api.document.charset");
    public static final Key IN_ENC = new Key("input.source.charset");
    public static final Key OUT_ENC = new Key("output.source.charset");
    public static final Key REPLACE_DESCRIPTION_ARRAY = new Key("replace.entry.descprition");
    public static final Key WINDOW_WIDTH = new Key("window.dimention.width");
    public static final Key WINDOW_HEIGHT = new Key("window.dimention.height");
    public static final Key WINDOW_X = new Key("window.position.x");
    public static final Key WINDOW_Y = new Key("window.position.y");
    public static final Key WINDOW_STATE = new Key("window.state");
    public static final Key DETAIL_PANEL_HEIGHT = new Key("window.replace.panel.height");
    private final File parsistFile;
    private final Properties prop = new Properties();
    private static Persister parsister;

    private Persister() throws MergeDocException {
        ConfigManager config = ConfigManager.getInstance();
        this.parsistFile = config.getFile("mergedoc.properties");
        try {
            this.parsistFile.createNewFile();
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.parsistFile));
            this.prop.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MergeDocException(this.parsistFile + " \u306e\u64cd\u4f5c\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
        }
    }

    public static Persister getInstance() throws MergeDocException {
        if (parsister == null) {
            parsister = new Persister();
        }
        return parsister;
    }

    public void store() throws MergeDocException {
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.parsistFile));
            this.prop.store(os, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MergeDocException(this.parsistFile + " \u306e\u66f8\u304d\u8fbc\u307f\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
        }
    }

    public int size() {
        return this.prop.size();
    }

    public void setString(Key key, String value) {
        this.prop.setProperty(key.toString(), value == null ? "" : value);
    }

    public String getString(Key key) {
        return this.getString(key, null);
    }

    public String getString(Key key, String def) {
        String str = this.prop.getProperty(key.toString());
        return str == null ? def : str;
    }

    public void setInt(Key key, int value) {
        this.setString(key, String.valueOf(value));
    }

    public int getInt(Key key) {
        return Integer.parseInt(this.getString(key));
    }

    public int getInt(Key key, int def) {
        try {
            return this.getInt(key);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public void setStrings(Key key, String[] values) {
        String str;
        int i = 0;
        while ((str = this.prop.getProperty(key.toString() + i)) != null) {
            this.prop.remove(key.toString() + i);
            ++i;
        }
        for (i = 0; i < values.length; ++i) {
            this.prop.setProperty(key.toString() + i, values[i]);
        }
    }

    public String[] getStrings(Key key) {
        String str;
        LinkedList<String> list = new LinkedList<String>();
        int i = 0;
        while ((str = this.prop.getProperty(key.toString() + i)) != null) {
            list.add(str);
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    public static class Key {
        private final String str;

        private Key(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

