/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.ui;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import mergedoc.MergeDocException;
import mergedoc.core.FastStringUtils;
import mergedoc.core.Preference;
import mergedoc.ui.ComponentFactory;
import mergedoc.ui.EntryCheckBox;
import mergedoc.ui.FileChooserField;
import mergedoc.ui.PreviewScrollPane;
import mergedoc.ui.TitledPanel;
import mergedoc.xml.ConfigManager;
import mergedoc.xml.Persister;
import mergedoc.xml.ReplaceEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PreferencePanel
extends JPanel {
    private static final Log log = LogFactory.getLog(PreferencePanel.class);
    private FileChooserField docField = new FileChooserField();
    private FileChooserField srcField = new FileChooserField();
    private FileChooserField outField = new FileChooserField();
    private JSplitPane splitPane = new JSplitPane();
    private List<EntryCheckBox> entryCheckList = new LinkedList<EntryCheckBox>();
    private PreviewScrollPane previewScrollPane;

    public PreferencePanel() throws MergeDocException {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 1));
        this.setMaximumSize(ComponentFactory.createMaxDimension());
        this.add(this.createUpperPanel());
        this.add(ComponentFactory.createSpacer(0, 7));
        this.add(this.createLowerPanel());
    }

    private JComponent createUpperPanel() throws MergeDocException {
        JLabel docLabel = this.docField.getLabel();
        JLabel srcLabel = this.srcField.getLabel();
        JLabel outLabel = this.outField.getLabel();
        docLabel.setText("API \u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea");
        srcLabel.setText("\u5165\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb");
        outLabel.setText("\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb");
        JComponent[] labels = new JLabel[]{docLabel, srcLabel, outLabel};
        ComponentFactory.ensureMaxFontWidth(labels);
        JComboBox docCombo = this.docField.getComboBox();
        JComboBox srcCombo = this.srcField.getComboBox();
        JComboBox outCombo = this.outField.getComboBox();
        docCombo.addItem("JISAutoDetect");
        srcCombo.addItem("JISAutoDetect");
        docCombo.setSelectedItem("EUC-JP");
        srcCombo.setSelectedItem(FileChooserField.ENCODING_DEFAULT);
        outCombo.setSelectedItem(FileChooserField.ENCODING_DEFAULT);
        JComponent[] combos = new JComboBox[]{docCombo, srcCombo, outCombo};
        ComponentFactory.ensureMaxFontWidth(combos);
        this.docField.setSelectionMode(FileChooserField.DIRECTORIES);
        this.srcField.setSelectionMode(FileChooserField.ZIP_TGZ_FILES);
        this.outField.setSelectionMode(FileChooserField.ZIP_FILES);
        this.docField.setChooseListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencePanel.this.resolveArchivePath(PreferencePanel.this.docField.getFile());
            }
        });
        TitledPanel panel = new TitledPanel("\u57fa\u672c\u8a2d\u5b9a");
        ((Container)panel).add(this.docField);
        ((Container)panel).add(this.srcField);
        ((Container)panel).add(this.outField);
        String OPTION_KEY = "target.directory";
        String targetStr = System.getProperty("target.directory");
        if (targetStr != null) {
            File targetDir = new File(targetStr);
            if (!targetDir.exists() || targetDir.isFile()) {
                throw new MergeDocException("\u30aa\u30d7\u30b7\u30e7\u30f3 target.directory \u306b\u6307\u5b9a\u3055\u308c\u305f\u5024 " + targetStr + " \u306f\n\u5b58\u5728\u3057\u306a\u3044\u304b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
            }
            File docDir = this.searchDocDirectory(targetDir);
            if (docDir != null) {
                this.docField.setFile(docDir);
            }
            this.srcField.setFile(new File(""));
            this.outField.setFile(new File(""));
            this.resolveArchivePath(targetDir);
        }
        this.loadPersister(this.docField, Persister.DOC_DIR, Persister.DOC_ENC);
        this.loadPersister(this.srcField, Persister.IN_FILE, Persister.IN_ENC);
        this.loadPersister(this.outField, Persister.OUT_FILE, Persister.OUT_ENC);
        String docPath = this.docField.getFile().getPath();
        if (docPath.equals("")) {
            File docDir;
            File home = new File(System.getProperty("java.home"));
            if (home.getName().equals("jre")) {
                home = home.getParentFile();
            }
            if ((docDir = new File(home, "docs/ja/api")).exists()) {
                this.docField.setFile(docDir);
                this.resolveArchivePath(home);
            }
        }
        return panel;
    }

    private JComponent createLowerPanel() throws MergeDocException {
        JPanel checkPanel = new JPanel();
        checkPanel.setLayout(new BoxLayout(checkPanel, 1));
        List<ReplaceEntry> list = ConfigManager.getInstance().getGlobalEntries();
        for (ReplaceEntry entry : list) {
            EntryCheckBox cb = new EntryCheckBox(entry);
            cb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PreferencePanel.this.previewScrollPane.updatePreview(PreferencePanel.this.entryCheckList);
                }
            });
            checkPanel.add(cb);
            this.entryCheckList.add(cb);
        }
        JScrollPane checkScrollPane = ComponentFactory.createScrollPane(checkPanel);
        checkScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.previewScrollPane = new PreviewScrollPane();
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.splitPane.setOrientation(0);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setTopComponent(checkScrollPane);
        this.splitPane.setBottomComponent(this.previewScrollPane);
        JPanel splitPanel = new JPanel();
        splitPanel.setLayout(new BoxLayout(splitPanel, 0));
        splitPanel.add(this.splitPane);
        TitledPanel panel = new TitledPanel("\u8a73\u7d30\u8a2d\u5b9a");
        panel.setMaximumSize(ComponentFactory.createMaxDimension());
        ((Container)panel).add(splitPanel);
        Persister psst = Persister.getInstance();
        int loc = psst.getInt(Persister.DETAIL_PANEL_HEIGHT, 88);
        this.splitPane.setDividerLocation(loc);
        String[] pDescs = psst.getStrings(Persister.REPLACE_DESCRIPTION_ARRAY);
        block1: for (EntryCheckBox ecb : this.entryCheckList) {
            ReplaceEntry entry = ecb.getReplaceEntry();
            String desc = entry.getDescription();
            for (String pDesc : pDescs) {
                if (!desc.equals(pDesc)) continue;
                ecb.setSelected(true);
                continue block1;
            }
        }
        this.previewScrollPane.updatePreview(this.entryCheckList);
        return panel;
    }

    private void resolveArchivePath(File baseDir) {
        String src = this.srcField.getFile().getPath();
        String out = this.outField.getFile().getPath();
        if (!src.equals("") || !out.equals("")) {
            return;
        }
        for (File dir = baseDir; dir != null; dir = dir.getParentFile()) {
            File zip = new File(dir, "src.zip");
            if (zip.exists()) {
                this.srcField.setFile(zip);
                break;
            }
            File jar = new File(dir, "src.jar");
            if (!jar.exists()) continue;
            this.srcField.setFile(jar);
            break;
        }
        if (!(src = this.srcField.getFile().getPath()).equals("")) {
            String outName = FastStringUtils.replaceFirst(src, "\\.(zip|jar)$", "ja.zip");
            this.outField.setFile(new File(outName));
        }
    }

    private File searchDocDirectory(File baseDir) {
        File dir = null;
        for (File file : baseDir.listFiles()) {
            if (file.isFile()) {
                if (file.getName().equals("allclasses-frame.html")) {
                    dir = baseDir;
                }
            } else {
                dir = this.searchDocDirectory(file);
            }
            if (dir != null) break;
        }
        return dir;
    }

    private void loadPersister(FileChooserField field, Persister.Key pathKey, Persister.Key charKey) throws MergeDocException {
        String path;
        Persister psst = Persister.getInstance();
        if (field.getFile().getPath().equals("") && (path = psst.getString(pathKey, "")).length() > 0) {
            field.setFile(new File(path));
        }
        try {
            String enc = psst.getString(charKey);
            field.getComboBox().setSelectedItem(enc);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public ReplaceEntry[] getSelectedEntries() {
        LinkedList<ReplaceEntry> enables = new LinkedList<ReplaceEntry>();
        for (EntryCheckBox cb : this.entryCheckList) {
            if (!cb.isSelected()) continue;
            ReplaceEntry entry = cb.getReplaceEntry();
            enables.add(entry);
        }
        ReplaceEntry[] entries = enables.toArray(new ReplaceEntry[enables.size()]);
        return entries;
    }

    public Preference getPreference() {
        return new Preference(){
            File docDir;
            File srcFile;
            File outFile;
            String docEnc;
            String srcEnc;
            String outEnc;
            ReplaceEntry[] entries;
            {
                this.docDir = PreferencePanel.this.docField.getFile();
                this.srcFile = PreferencePanel.this.srcField.getFile();
                this.outFile = PreferencePanel.this.outField.getFile();
                this.docEnc = PreferencePanel.this.docField.getComboBox().getSelectedItem().toString();
                this.srcEnc = PreferencePanel.this.srcField.getComboBox().getSelectedItem().toString();
                this.outEnc = PreferencePanel.this.outField.getComboBox().getSelectedItem().toString();
                this.entries = PreferencePanel.this.getSelectedEntries();
            }

            public File getDocDirectory() {
                return this.docDir;
            }

            public File getInputArchive() {
                return this.srcFile;
            }

            public File getOutputArchive() {
                return this.outFile;
            }

            public String getDocEncoding() {
                return this.docEnc;
            }

            public String getInputEncoding() {
                return this.srcEnc;
            }

            public String getOutputEncoding() {
                return this.outEnc;
            }

            public ReplaceEntry[] getGlobalEntries() {
                return this.entries;
            }
        };
    }

    public void persistent() throws MergeDocException {
        Preference pref = this.getPreference();
        Persister psst = Persister.getInstance();
        psst.setString(Persister.DOC_DIR, pref.getDocDirectory().getPath());
        psst.setString(Persister.IN_FILE, pref.getInputArchive().getPath());
        psst.setString(Persister.OUT_FILE, pref.getOutputArchive().getPath());
        psst.setString(Persister.DOC_ENC, pref.getDocEncoding());
        psst.setString(Persister.IN_ENC, pref.getInputEncoding());
        psst.setString(Persister.OUT_ENC, pref.getOutputEncoding());
        psst.setInt(Persister.DETAIL_PANEL_HEIGHT, this.splitPane.getDividerLocation());
        LinkedList<String> descList = new LinkedList<String>();
        for (ReplaceEntry entry : pref.getGlobalEntries()) {
            descList.add(entry.getDescription());
        }
        String[] descs = descList.toArray(new String[descList.size()]);
        psst.setStrings(Persister.REPLACE_DESCRIPTION_ARRAY, descs);
    }
}

