/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.ui;

import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import mergedoc.ui.ComponentFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ButtonBar
extends JPanel {
    private static final Log log = LogFactory.getLog(ButtonBar.class);
    private JButton runButton;
    private ActionListener runListener;
    private ActionListener backListener;
    private JButton endButton;
    private ActionListener cancelListener;
    private ActionListener endListener;
    public final ButtonState INIT_STATE = new ButtonState(){

        public void apply() {
            ButtonBar.this.runButton.setText("\u5b9f\u884c(R)");
            ButtonBar.this.runButton.setMnemonic(82);
            ButtonBar.this.runButton.setEnabled(true);
            ButtonBar.this.runButton.addActionListener(ButtonBar.this.runListener);
            ButtonBar.this.endButton.setText("\u7d42\u4e86(E)");
            ButtonBar.this.endButton.setMnemonic(69);
            ButtonBar.this.endButton.setEnabled(true);
            ButtonBar.this.endButton.addActionListener(ButtonBar.this.endListener);
        }
    };
    public final ButtonState WORKING_STATE = new ButtonState(){

        public void apply() {
            ButtonBar.this.runButton.setText("\u5b9f\u884c(R)");
            ButtonBar.this.runButton.setEnabled(false);
            ButtonBar.this.endButton.setText("\u30ad\u30e3\u30f3\u30bb\u30eb(C)");
            ButtonBar.this.endButton.setMnemonic(67);
            ButtonBar.this.endButton.setEnabled(true);
            ButtonBar.this.endButton.addActionListener(ButtonBar.this.cancelListener);
        }
    };
    public final ButtonState FINISH_STATE = new ButtonState(){

        public void apply() {
            ButtonBar.this.runButton.setText("\u623b\u308b(B)");
            ButtonBar.this.runButton.setMnemonic(66);
            ButtonBar.this.runButton.setEnabled(true);
            ButtonBar.this.runButton.addActionListener(ButtonBar.this.backListener);
            ButtonBar.this.endButton.setText("\u7d42\u4e86(E)");
            ButtonBar.this.endButton.setMnemonic(69);
            ButtonBar.this.endButton.setEnabled(true);
            ButtonBar.this.endButton.addActionListener(ButtonBar.this.endListener);
        }
    };
    public final ButtonState CANCEL_STATE = new ButtonState(){

        public void apply() {
            ButtonBar.this.runButton.setText("\u623b\u308b(B)");
            ButtonBar.this.runButton.setMnemonic(66);
            ButtonBar.this.runButton.setEnabled(true);
            ButtonBar.this.runButton.addActionListener(ButtonBar.this.backListener);
            ButtonBar.this.endButton.setText("\u30ad\u30e3\u30f3\u30bb\u30eb(C)");
            ButtonBar.this.endButton.setEnabled(false);
        }
    };

    public ButtonBar() {
        this.setLayout(new BoxLayout(this, 0));
    }

    public void setState(final ButtonState state) {
        if (this.runListener == null || this.backListener == null || this.cancelListener == null || this.endListener == null) {
            String m = "\u30dc\u30bf\u30f3\u30d0\u30fc\u306e\u30ea\u30b9\u30ca\u30fc\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u72b6\u614b\u3092\u5909\u66f4\u51fa\u6765\u307e\u305b\u3093\u3002";
            IllegalStateException e = new IllegalStateException(m);
            log.fatal(m, e);
            throw e;
        }
        final JLabel filler = new JLabel();
        int maxWidth = (int)ComponentFactory.createMaxDimension().getWidth();
        filler.setMaximumSize(new Dimension(maxWidth, 0));
        this.runButton = this.createButton();
        this.endButton = this.createButton();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ButtonBar.this.removeAll();
                ButtonBar.this.add(filler);
                ButtonBar.this.add(ButtonBar.this.runButton);
                ButtonBar.this.add(ComponentFactory.createSpacer(10, 0));
                ButtonBar.this.add(ButtonBar.this.endButton);
                state.apply();
            }
        });
    }

    private JButton createButton() {
        JButton button = new JButton();
        ComponentFactory.ensureSize(button, 100, 21);
        return button;
    }

    public void setRunListener(ActionListener runListener) {
        this.runListener = runListener;
    }

    public void setBackListener(ActionListener backListener) {
        this.backListener = backListener;
    }

    public void setCancelListener(ActionListener cancelListener) {
        this.cancelListener = cancelListener;
    }

    public void setEndListener(ActionListener endListener) {
        this.endListener = endListener;
    }

    public void setEnabled(final boolean enabled) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ButtonBar.this.runButton.setEnabled(enabled);
                ButtonBar.this.endButton.setEnabled(enabled);
            }
        });
    }

    private static interface ButtonState {
        public void apply();
    }
}

