/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.core;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mergedoc.core.APIDocument;
import mergedoc.core.Comment;
import mergedoc.core.JavaBuffer;
import mergedoc.core.PatternCache;
import mergedoc.core.Signature;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Merger {
    private static final Log log = LogFactory.getLog(Merger.class);
    private String className;
    private File docDirectory;
    private String docEncoding = System.getProperty("file.encoding");

    public Merger(File docDirectory) {
        this.docDirectory = docDirectory;
    }

    public void setDocEncoding(String docEncoding) {
        this.docEncoding = docEncoding;
    }

    public String merge(String source) throws IOException {
        this.className = this.scanClassName(source);
        if (this.className == null) {
            return source;
        }
        APIDocument apiDoc = new APIDocument(this.docDirectory, this.className, this.docEncoding);
        if (apiDoc.isEmpty()) {
            return source;
        }
        JavaBuffer javaBuf = new JavaBuffer(this.className, source);
        while (javaBuf.nextComment()) {
            Signature sig = javaBuf.getSignature();
            Comment com = apiDoc.getComment(sig);
            javaBuf.setLocalizedComment(sig, com);
        }
        String result = javaBuf.finishToString();
        return result;
    }

    private String scanClassName(String source) {
        Pattern pkgPat = PatternCache.getPattern("(?m)^\\s*package\\s+([\\w\\.]+)");
        Matcher pkgMat = pkgPat.matcher(source);
        if (pkgMat.find()) {
            String packageName = pkgMat.group(1);
            String clsReg = "(?m)^(|[\\w\\s]*?\\s+|.*?\\*/\\s+)(class|interface|@interface|enum)\\s+(\\w+)";
            Pattern clsPat = PatternCache.getPattern(clsReg);
            Matcher clsMat = clsPat.matcher(source);
            if (clsMat.find()) {
                String name = packageName + "." + clsMat.group(3);
                return name;
            }
            throw new IllegalArgumentException("Java \u30bd\u30fc\u30b9\u304b\u3089\u30af\u30e9\u30b9\u540d\u3092\u53d6\u5f97\u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002\n" + source);
        }
        return null;
    }

    public String getMergedClassName() {
        return this.className;
    }
}

