/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.core;

import java.util.ArrayList;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mergedoc.core.Comment;
import mergedoc.core.FastStringUtils;
import mergedoc.core.PatternCache;
import mergedoc.core.Signature;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaBuffer {
    private static final Log log = LogFactory.getLog(JavaBuffer.class);
    private final String className;
    private final String source;
    private static final Pattern commentPattern = PatternCache.getPattern("(?sm)^ *?/\\*\\*.*?\\*/ *?\n");
    private final Matcher commentMatcher;
    private final StringBuffer outputBuffer = new StringBuffer();
    private final Stack<ClassBlock> classStack = new Stack();
    private static final String DUMMY_COMMENT = "/** Empty comment. " + JavaBuffer.class.getName() + ". */\n";

    public JavaBuffer(String className, String javaSource) {
        this.className = className;
        this.source = this.setupDummyComment(javaSource);
        this.commentMatcher = commentPattern.matcher(this.source);
        ClassBlock cb = new ClassBlock(className, this.source.length());
        this.classStack.push(cb);
    }

    private String setupDummyComment(String src) {
        int declareMaxLength;
        char[] c = src.toCharArray();
        int last = c.length - 1;
        ArrayList<Integer> dummyInsertPositions = new ArrayList<Integer>();
        for (int i = declareMaxLength = 12; i <= last; ++i) {
            if (c[i - 1] == '/' && c[i] == '*') {
                ++i;
                while (i <= last && (c[i - 1] != '*' || c[i] != '/')) {
                    ++i;
                }
            } else if (c[i - 1] == '/' && c[i] == '/') {
                ++i;
                while (i <= last) {
                    if (c[i] == '\n') {
                        ++i;
                        break;
                    }
                    ++i;
                }
            } else if (c[i - 1] != '\\' && c[i - 1] != '\'' && c[i] == '\"') {
                ++i;
                while (i <= last && (c[i - 1] == '\\' || c[i - 1] == '\'' || c[i] != '\"')) {
                    ++i;
                }
            }
            if (i >= last) break;
            int declaPos = -1;
            if (c[i] == ' ' || c[i] == '\n' || c[i] == '<') {
                if (c[i - 5] == 'c' && c[i - 4] == 'l' && c[i - 3] == 'a' && c[i - 2] == 's' && c[i - 1] == 's') {
                    if (c[i - 6] == ' ' || c[i - 6] == '\n') {
                        declaPos = i - 7;
                    }
                } else if (c[i - 9] == 'i' && c[i - 8] == 'n' && c[i - 7] == 't' && c[i - 6] == 'e' && c[i - 5] == 'r' && c[i - 4] == 'f' && c[i - 3] == 'a' && c[i - 2] == 'c' && c[i - 1] == 'e') {
                    if (c[i - 10] == ' ' || c[i - 10] == '\n') {
                        declaPos = i - 11;
                    } else if (c[i - 10] == '@' && (c[i - 11] == ' ' || c[i - 11] == '\n')) {
                        declaPos = i - 12;
                    }
                } else if (c[i - 4] == 'e' && c[i - 3] == 'n' && c[i - 2] == 'u' && c[i - 1] == 'm' && (c[i - 5] == ' ' || c[i - 5] == '\n')) {
                    declaPos = i - 6;
                }
            }
            for (int j = declaPos; j > 0 && (c[j - 1] != '*' || c[j] != '/'); --j) {
                if (c[j] != ';' && c[j] != '}' && c[j] != '{') continue;
                block5: for (int k = j - 1; k > 0 && (c[k - 1] != '/' || c[k] != '/'); --k) {
                    if (c[k] != '\n') continue;
                    for (int l = j + 1; l < i; ++l) {
                        if (c[l] != '\n') continue;
                        dummyInsertPositions.add(l + 1);
                        k = -1;
                        j = -1;
                        continue block5;
                    }
                }
            }
        }
        StringBuilder sb = new StringBuilder(src);
        for (int i = dummyInsertPositions.size() - 1; i >= 0; --i) {
            int pos = (Integer)dummyInsertPositions.get(i);
            sb.insert(pos, DUMMY_COMMENT);
        }
        return sb.toString();
    }

    public boolean nextComment() {
        while (this.commentMatcher.find()) {
            String c2c;
            int currentEnd;
            String sourceComment = this.getSourceComment();
            if (FastStringUtils.matches(sourceComment, "\\s*/\\*+/\\s*\n")) continue;
            if (sourceComment.contains(DUMMY_COMMENT)) {
                this.getSignature();
                this.commentMatcher.appendReplacement(this.outputBuffer, "");
                continue;
            }
            Matcher nextMat = commentPattern.matcher(this.source);
            if (nextMat.find(currentEnd = this.commentMatcher.end()) && FastStringUtils.matches(c2c = this.source.substring(currentEnd, nextMat.start()), "\\s*")) continue;
            return true;
        }
        return false;
    }

    private String getSourceComment() {
        return this.commentMatcher.group();
    }

    public Signature getSignature() {
        int commentEndPos = this.commentMatcher.end();
        String commentEndToEOF = this.source.substring(commentEndPos, this.source.length());
        Pattern sigPattern = PatternCache.getPattern("(?s)(.+?)(throws|\\{|\\=|;|,\\s*/\\*|\\})");
        Matcher sigMatcher = sigPattern.matcher(commentEndToEOF);
        if (sigMatcher.find()) {
            ClassBlock classBlock = this.classStack.peek();
            while (commentEndPos > classBlock.end && this.classStack.size() > 1) {
                this.classStack.pop();
                classBlock = this.classStack.peek();
            }
            String sigStr = sigMatcher.group(1);
            Signature sig = new Signature(classBlock.name, sigStr = FastStringUtils.replaceFirst(sigStr, "(?s)/\\*[^\\*].*?\\*/\\s*", ""));
            if (sig.isDeclareInnerClass()) {
                String name = sig.getClassName();
                int end = this.searchEndOfInner(commentEndToEOF, name);
                classBlock = new ClassBlock(name, end);
                this.classStack.push(classBlock);
            }
            return sig;
        }
        log.warn("Javadoc \u30b3\u30e1\u30f3\u30c8\u306e\u5f8c\u306e\u30b7\u30b0\u30cd\u30c1\u30e3\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\n" + commentEndToEOF);
        return null;
    }

    private int searchEndOfInner(String currentToEnd, String iClassName) {
        int nestLevel = 1;
        for (int i = currentToEnd.indexOf(123) + 1; i < currentToEnd.length(); ++i) {
            char c = currentToEnd.charAt(i);
            if (c == '{') {
                ++nestLevel;
            }
            if (c == '}') {
                --nestLevel;
            }
            if (nestLevel != 0) continue;
            return this.commentMatcher.end() + i;
        }
        log.warn("\u30a4\u30f3\u30ca\u30fc\u30af\u30e9\u30b9 " + this.className + "#" + iClassName + " \u306e\u7d42\u4e86\u4f4d\u7f6e\u304c\u691c\u51fa\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        return -1;
    }

    public void setLocalizedComment(Signature sig, Comment comment) {
        if (comment == null) {
            return;
        }
        String srcComment = this.getSourceComment();
        comment.setSourceBody(srcComment);
        String docComment = comment.buildComment();
        if (docComment == null || docComment.length() == 0) {
            return;
        }
        docComment = FastStringUtils.quoteReplacement(docComment);
        this.commentMatcher.appendReplacement(this.outputBuffer, docComment);
    }

    public String finishToString() {
        this.commentMatcher.appendTail(this.outputBuffer);
        String str = this.outputBuffer.toString();
        return str;
    }

    private static class ClassBlock {
        final String name;
        final int end;

        ClassBlock(String name, int end) {
            this.name = name;
            this.end = end;
        }
    }
}

