/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public abstract class ArchiveInputStream {
    private ArchiveInputStream() {
    }

    public static ArchiveInputStream create(File file) throws IOException {
        String fileName = file.getName();
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        if (fileName.endsWith(".zip") || fileName.endsWith(".jar")) {
            return new ZipStreamProxy(new ZipInputStream(bis));
        }
        if (fileName.endsWith(".tar.gz") || fileName.endsWith(".tgz")) {
            return new TarStreamProxy(new TarInputStream(new GZIPInputStream(bis)));
        }
        throw new IllegalArgumentException("\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u5f62\u5f0f\u306f\u30b5\u30dd\u30fc\u30c8\u3057\u307e\u305b\u3093\u3002\n" + fileName);
    }

    public abstract void close() throws IOException;

    public abstract Entry getNextEntry() throws IOException;

    public abstract int read(byte[] var1) throws IOException;

    private static class TarEntryProxy
    implements Entry {
        TarEntry entry;

        TarEntryProxy(TarEntry entry) {
            this.entry = entry;
        }

        public String getName() {
            return this.entry.getName();
        }
    }

    private static class TarStreamProxy
    extends ArchiveInputStream {
        TarInputStream is;

        TarStreamProxy(TarInputStream is) {
            this.is = is;
        }

        public void close() throws IOException {
            this.is.close();
        }

        public Entry getNextEntry() throws IOException {
            TarEntry entry = this.is.getNextEntry();
            return entry != null ? new TarEntryProxy(entry) : null;
        }

        public int read(byte[] b) throws IOException {
            return this.is.read(b);
        }
    }

    private static class ZipEntryProxy
    implements Entry {
        ZipEntry entry;

        ZipEntryProxy(ZipEntry entry) {
            this.entry = entry;
        }

        public String getName() {
            return this.entry.getName();
        }
    }

    private static class ZipStreamProxy
    extends ArchiveInputStream {
        ZipInputStream is;

        ZipStreamProxy(ZipInputStream is) {
            this.is = is;
        }

        public void close() throws IOException {
            this.is.close();
        }

        public Entry getNextEntry() throws IOException {
            ZipEntry entry = this.is.getNextEntry();
            return entry != null ? new ZipEntryProxy(entry) : null;
        }

        public int read(byte[] b) throws IOException {
            return this.is.read(b);
        }
    }

    public static interface Entry {
        public String getName();
    }
}

